/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.streaming;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.json.JSONException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.PrettyJSON;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.test.GraphDescription;

public class StreamingBatchOperationDocIT
extends AbstractRestFunctionalTestBase {
    @Test
    @GraphDescription.Graph(value={"Joe knows John"})
    public void execute_multiple_operations_in_batch_streaming() throws Exception {
        long idJoe = ((Node)((Map)this.data.get()).get("Joe")).getId();
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"PUT").key("to").value((Object)("/node/" + idJoe + "/properties")).key("body").object().key("age").value(1L).endObject().key("id").value(0L).endObject().object().key("method").value((Object)"GET").key("to").value((Object)("/node/" + idJoe)).key("id").value(1L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key("age").value(1L).endObject().key("id").value(2L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key("age").value(1L).endObject().key("id").value(3L).endObject().endArray().toString();
        String entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedType(MediaType.APPLICATION_JSON_TYPE).withHeader("X-Stream", "true").payload(jsonString).expectedStatus(200).post(this.batchUri()).entity();
        System.out.println("entity = " + entity);
        List results = JsonHelper.jsonToList((String)entity);
        Assert.assertEquals((long)4L, (long)results.size());
        Map putResult = (Map)results.get(0);
        Map getResult = (Map)results.get(1);
        Map firstPostResult = (Map)results.get(2);
        Map secondPostResult = (Map)results.get(3);
        Assert.assertEquals((Object)0, putResult.get("id"));
        Assert.assertEquals((Object)2, firstPostResult.get("id"));
        Assert.assertEquals((Object)3, secondPostResult.get("id"));
        Assert.assertEquals((Object)("/node/" + idJoe + "/properties"), putResult.get("from"));
        Assert.assertEquals((Object)("/node/" + idJoe), getResult.get("from"));
        Assert.assertEquals((Object)"/node", firstPostResult.get("from"));
        Assert.assertEquals((Object)"/node", secondPostResult.get("from"));
        Assert.assertTrue((((String)firstPostResult.get("location")).length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((((String)secondPostResult.get("location")).length() > 0 ? 1 : 0) != 0);
        Map body = (Map)getResult.get("body");
        Assert.assertEquals((Object)1, ((Map)body.get("data")).get("age"));
    }

    @Test
    public void refer_to_items_created_earlier_in_the_same_batch_job_streaming() throws Exception {
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("id").value(0L).key("body").object().key("name").value((Object)"bob").endObject().endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("id").value(1L).key("body").object().key("age").value(12L).endObject().endObject().object().key("method").value((Object)"POST").key("to").value((Object)"{0}/relationships").key("id").value(3L).key("body").object().key("to").value((Object)"{1}").key("data").object().key("since").value((Object)"2010").endObject().key("type").value((Object)"KNOWS").endObject().endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/index/relationship/my_rels").key("id").value(4L).key("body").object().key("key").value((Object)"since").key("value").value((Object)"2010").key("uri").value((Object)"{3}").endObject().endObject().endArray().toString();
        String entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedType(MediaType.APPLICATION_JSON_TYPE).withHeader("X-Stream", "true").expectedStatus(200).payload(jsonString).post(this.batchUri()).entity();
        List results = JsonHelper.jsonToList((String)entity);
        Assert.assertEquals((long)4L, (long)results.size());
    }

    @Test
    public void shouldGetLocationHeadersWhenCreatingThings() throws Exception {
        int originalNodeCount = this.countNodes();
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key("age").value(1L).endObject().endObject().endArray().toString();
        JaxRsResponse response = RestRequest.req().accept(MediaType.APPLICATION_JSON_TYPE).header("X-Stream", "true").post(this.batchUri(), jsonString);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String entity = response.getEntity();
        System.out.println("result = " + entity);
        List results = JsonHelper.jsonToList((String)entity);
        Assert.assertEquals((long)(originalNodeCount + 1), (long)this.countNodes());
        Assert.assertEquals((long)1L, (long)results.size());
        Map result = (Map)results.get(0);
        Assert.assertTrue((((String)result.get("location")).length() > 0 ? 1 : 0) != 0);
    }

    private String batchUri() {
        return this.getDataUri() + "batch";
    }

    @Test
    public void shouldForwardUnderlyingErrors() throws Exception {
        JaxRsResponse response = RestRequest.req().accept(MediaType.APPLICATION_JSON_TYPE).header("X-Stream", "true").post(this.batchUri(), new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key("age").array().value(true).value((Object)"hello").endArray().endObject().endObject().endArray().toString());
        Map<String, Object> res = this.singleResult(response, 0);
        Assert.assertTrue((boolean)((String)res.get("message")).startsWith("Invalid JSON array in POST body"));
        Assert.assertEquals((Object)400, (Object)res.get("status"));
    }

    private Map<String, Object> singleResult(JaxRsResponse response, int i) throws JsonParseException {
        return (Map)JsonHelper.jsonToList((String)response.getEntity()).get(i);
    }

    @Test
    public void shouldRollbackAllWhenGivenIncorrectRequest() throws JsonParseException, ClientHandlerException, UniformInterfaceException, JSONException {
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key("age").value((Object)"1").endObject().endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").array().value((Object)"a_list").value((Object)"this_makes_no_sense").endArray().endObject().endArray().toString();
        int originalNodeCount = this.countNodes();
        JaxRsResponse response = RestRequest.req().accept(MediaType.APPLICATION_JSON_TYPE).header("X-Stream", "true").post(this.batchUri(), jsonString);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((boolean)((Map)this.singleResult(response, 1).get("body")).get("message").toString().contains("java.util.ArrayList cannot be cast to java.util.Map"));
        Assert.assertEquals((Object)400, (Object)this.singleResult(response, 1).get("status"));
        Assert.assertEquals((long)originalNodeCount, (long)this.countNodes());
    }

    @Test
    public void shouldHandleUnicodeGetCorrectly() throws Exception {
        String asianText = "\u4f8b\u5b50";
        String germanText = "\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\u00df";
        String complicatedString = asianText + germanText;
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key(complicatedString).value((Object)complicatedString).endObject().endObject().endArray().toString();
        String entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedType(MediaType.APPLICATION_JSON_TYPE).withHeader("X-Stream", "true").expectedStatus(200).payload(jsonString).post(this.batchUri()).entity();
        Map response = (Map)((Map)JsonHelper.jsonToList((String)entity).get(0)).get("body");
        String returnedValue = (String)((Map)response.get("data")).get(complicatedString);
        Assert.assertThat((Object)returnedValue, (Matcher)Matchers.is((Object)complicatedString));
    }

    @Test
    @GraphDescription.Graph(value={"Peter likes Jazz"})
    public void shouldHandleEscapedStrings() throws ClientHandlerException, UniformInterfaceException, JSONException, PropertyValueException {
        String string = "Jazz";
        Node gnode = this.getNode(string);
        Assert.assertEquals((Object)gnode.getProperty("name"), (Object)string);
        String name = "string\\ and \"test\"";
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"PUT").key("to").value((Object)("/node/" + gnode.getId() + "/properties")).key("body").object().key("name").value((Object)name).endObject().endObject().endArray().toString();
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedType(MediaType.APPLICATION_JSON_TYPE).withHeader("X-Stream", "true").expectedStatus(200).payload(jsonString).post(this.batchUri()).entity();
        jsonString = new PrettyJSON().array().object().key("method").value((Object)"GET").key("to").value((Object)("/node/" + gnode.getId() + "/properties/name")).endObject().endArray().toString();
        String entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).payload(jsonString).post(this.batchUri()).entity();
        List results = JsonHelper.jsonToList((String)entity);
        Assert.assertEquals(((Map)results.get(0)).get("body"), (Object)name);
    }

    @Test
    public void shouldRollbackAllWhenInsertingIllegalData() throws JsonParseException, ClientHandlerException, UniformInterfaceException, JSONException {
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key("age").value(1L).endObject().endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key("age").object().key("age").value(1L).endObject().endObject().endObject().endArray().toString();
        int originalNodeCount = this.countNodes();
        JaxRsResponse response = RestRequest.req().accept(MediaType.APPLICATION_JSON_TYPE).header("X-Stream", "true").post(this.batchUri(), jsonString);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)400, (Object)this.singleResult(response, 1).get("status"));
        Assert.assertEquals((long)originalNodeCount, (long)this.countNodes());
    }

    @Test
    public void shouldRollbackAllOnSingle404() throws JsonParseException, ClientHandlerException, UniformInterfaceException, JSONException {
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key("age").value(1L).endObject().endObject().object().key("method").value((Object)"POST").key("to").value((Object)"www.google.com").endObject().endArray().toString();
        int originalNodeCount = this.countNodes();
        JaxRsResponse response = RestRequest.req().accept(MediaType.APPLICATION_JSON_TYPE).header("X-Stream", "true").post(this.batchUri(), jsonString);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)404, (Object)this.singleResult(response, 1).get("status"));
        Assert.assertEquals((long)originalNodeCount, (long)this.countNodes());
    }

    @Test
    public void shouldBeAbleToReferToUniquelyCreatedEntities() throws Exception {
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/index/node/Cultures?unique").key("body").object().key("key").value((Object)"ID").key("value").value((Object)"fra").key("properties").object().key("ID").value((Object)"fra").endObject().endObject().key("id").value(0L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("id").value(1L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"{1}/relationships").key("body").object().key("to").value((Object)"{0}").key("type").value((Object)"has").endObject().key("id").value(2L).endObject().endArray().toString();
        JaxRsResponse response = RestRequest.req().accept(MediaType.APPLICATION_JSON_TYPE).header("X-Stream", "true").post(this.batchUri(), jsonString);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void shouldBeAbleToReferToNotCreatedUniqueEntities() throws Exception {
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/index/node/Cultures?unique").key("body").object().key("key").value((Object)"name").key("value").value((Object)"tobias").key("properties").object().key("name").value((Object)"Tobias Tester").endObject().endObject().key("id").value(0L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/index/node/Cultures?unique").key("body").object().key("key").value((Object)"name").key("value").value((Object)"andres").key("properties").object().key("name").value((Object)"Andres Tester").endObject().endObject().key("id").value(1L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/index/node/Cultures?unique").key("body").object().key("key").value((Object)"name").key("value").value((Object)"andres").key("properties").object().key("name").value((Object)"Andres Tester").endObject().endObject().key("id").value(2L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/index/relationship/my_rels/?unique").key("body").object().key("key").value((Object)"name").key("value").value((Object)"tobias-andres").key("start").value((Object)"{0}").key("end").value((Object)"{1}").key("type").value((Object)"FRIENDS").endObject().key("id").value(3L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/index/relationship/my_rels/?unique").key("body").object().key("key").value((Object)"name").key("value").value((Object)"andres-tobias").key("start").value((Object)"{2}").key("end").value((Object)"{0}").key("type").value((Object)"FRIENDS").endObject().key("id").value(4L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/index/relationship/my_rels/?unique").key("body").object().key("key").value((Object)"name").key("value").value((Object)"andres-tobias").key("start").value((Object)"{1}").key("end").value((Object)"{0}").key("type").value((Object)"FRIENDS").endObject().key("id").value(5L).endObject().endArray().toString();
        JaxRsResponse response = RestRequest.req().accept(MediaType.APPLICATION_JSON_TYPE).header("X-Stream", "true").post(this.batchUri(), jsonString);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String entity = response.getEntity();
        System.out.println("entity = " + entity);
        List results = JsonHelper.jsonToList((String)entity);
        Assert.assertEquals((long)6L, (long)results.size());
        Map andresResult1 = (Map)results.get(1);
        Map andresResult2 = (Map)results.get(2);
        Map secondRelationship = (Map)results.get(4);
        Map thirdRelationship = (Map)results.get(5);
        Map body1 = (Map)andresResult1.get("body");
        Map body2 = (Map)andresResult2.get("body");
        Assert.assertEquals(body1.get("id"), body2.get("id"));
        body1 = (Map)secondRelationship.get("body");
        body2 = (Map)thirdRelationship.get("body");
        Assert.assertEquals(body1.get("self"), body2.get("self"));
        Assert.assertTrue((((String)secondRelationship.get("location")).length() > 0 ? 1 : 0) != 0);
        body1 = (Map)secondRelationship.get("body");
        body2 = (Map)andresResult1.get("body");
        Assert.assertEquals(body1.get("start"), body2.get("self"));
    }

    private int countNodes() {
        return IteratorUtil.count((Iterable)this.graphdb().getAllNodes());
    }
}

