/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.GraphDbHelper;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.domain.URIHelper;
import org.neo4j.server.rest.web.PropertyValueException;

public class IndexRelationshipFunctionalTest
extends AbstractRestFunctionalTestBase {
    private static FunctionalTestHelper functionalTestHelper;
    private static GraphDbHelper helper;
    private static RestRequest request;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(IndexRelationshipFunctionalTest.server());
        helper = functionalTestHelper.getGraphDbHelper();
        request = RestRequest.req();
    }

    @Before
    public void cleanTheDatabase() {
        this.cleanDatabase();
    }

    public JaxRsResponse httpGetIndexRelationshipRoot() {
        return this.httpGet(functionalTestHelper.relationshipIndexUri());
    }

    @Test
    public void shouldCreateANamedRelationshipIndexAndAddToIt() throws JsonParseException {
        String indexName = "favorites";
        int expectedIndexes = helper.getRelationshipIndexes().length + 1;
        HashMap<String, String> indexSpecification = new HashMap<String, String>();
        indexSpecification.put("name", indexName);
        JaxRsResponse response = this.httpPostIndexRelationshipRoot(JsonHelper.createJsonFrom(indexSpecification));
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull(((List)response.getHeaders().get((Object)"Location")).get(0));
        Assert.assertEquals((long)expectedIndexes, (long)helper.getRelationshipIndexes().length);
        Assert.assertNotNull(helper.getRelationshipIndex(indexName));
        String key = "key";
        String value = "value";
        String relationshipType = "related-to";
        long relationshipId = helper.createRelationship(relationshipType);
        response = this.httpPostIndexRelationshipNameKeyValue(indexName, relationshipId, key, value);
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        String indexUri = (String)((List)response.getHeaders().get((Object)"Location")).get(0);
        Assert.assertNotNull((Object)indexUri);
        Assert.assertEquals(Arrays.asList(relationshipId), helper.getIndexedRelationships(indexName, key, value));
        response = this.httpGet(indexUri);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String discovredEntity = response.getEntity();
        Map map = JsonHelper.jsonToMap((String)discovredEntity);
        Assert.assertNotNull(map.get("self"));
    }

    private JaxRsResponse httpPostIndexRelationshipRoot(String jsonIndexSpecification) {
        return RestRequest.req().post(functionalTestHelper.relationshipIndexUri(), jsonIndexSpecification);
    }

    private JaxRsResponse httpGetIndexRelationshipNameKeyValue(String indexName, String key, String value) {
        return RestRequest.req().get(functionalTestHelper.indexRelationshipUri(indexName, key, value));
    }

    private JaxRsResponse httpPostIndexRelationshipNameKeyValue(String indexName, long relationshipId, String key, String value) {
        return RestRequest.req().post(functionalTestHelper.indexRelationshipUri(indexName), this.createJsonStringFor(relationshipId, key, value));
    }

    private String createJsonStringFor(long relationshipId, String key, String value) {
        return "{\"key\": \"" + key + "\", \"value\": \"" + value + "\", \"uri\": \"" + functionalTestHelper.relationshipUri(relationshipId) + "\"}";
    }

    private JaxRsResponse httpGet(String indexUri) {
        return request.get(indexUri);
    }

    @Test
    public void shouldGet404WhenRequestingIndexUriWhichDoesntExist() {
        String key = "key3";
        String value = "value";
        String indexName = "nosuchindex";
        String indexUri = functionalTestHelper.relationshipIndexUri() + indexName + "/" + key + "/" + value;
        JaxRsResponse response = this.httpGet(indexUri);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGet404WhenDeletingNonExtistentIndex() {
        String indexName = "nosuchindex";
        String indexUri = functionalTestHelper.relationshipIndexUri() + indexName;
        JaxRsResponse response = request.delete(indexUri);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGet200AndArrayOfRelationshipRepsWhenGettingFromIndex() throws PropertyValueException {
        long startNode = helper.createNode(new Label[0]);
        long endNode = helper.createNode(new Label[0]);
        String key = "key_get";
        String value = "value";
        String relationshipName1 = "related-to";
        String relationshipName2 = "dislikes";
        String jsonString = this.jsonRelationshipCreationSpecification("related-to", endNode, "key_get", "value");
        JaxRsResponse createRelationshipResponse = this.httpPostCreateRelationship(startNode, jsonString);
        Assert.assertEquals((long)201L, (long)createRelationshipResponse.getStatus());
        String relationshipLocation1 = createRelationshipResponse.getLocation().toString();
        jsonString = this.jsonRelationshipCreationSpecification("dislikes", endNode, "key_get", "value");
        createRelationshipResponse = this.httpPostCreateRelationship(startNode, jsonString);
        Assert.assertEquals((long)201L, (long)createRelationshipResponse.getStatus());
        String relationshipLocation2 = (String)((List)createRelationshipResponse.getHeaders().get((Object)"Location")).get(0);
        String indexName = "matrix";
        JaxRsResponse indexCreationResponse = this.httpPostIndexRelationshipRoot("{\"name\":\"" + indexName + "\"}");
        Assert.assertEquals((long)201L, (long)indexCreationResponse.getStatus());
        JaxRsResponse indexedRelationshipResponse = this.httpPostIndexRelationshipNameKeyValue(indexName, functionalTestHelper.getRelationshipIdFromUri(relationshipLocation1), "key_get", "value");
        String indexLocation1 = (String)((List)indexedRelationshipResponse.getHeaders().get((Object)"Location")).get(0);
        indexedRelationshipResponse = this.httpPostIndexRelationshipNameKeyValue(indexName, functionalTestHelper.getRelationshipIdFromUri(relationshipLocation2), "key_get", "value");
        String indexLocation2 = (String)((List)indexedRelationshipResponse.getHeaders().get((Object)"Location")).get(0);
        HashMap<String, String> uriToName = new HashMap<String, String>();
        uriToName.put(indexLocation1.toString(), "related-to");
        uriToName.put(indexLocation2.toString(), "dislikes");
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.indexRelationshipUri(indexName, "key_get", "value"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Collection items = (Collection)JsonHelper.jsonToSingleValue((String)response.getEntity());
        int counter = 0;
        for (Object item : items) {
            Map map = (Map)item;
            Assert.assertNotNull(map.get("self"));
            String indexedUri = (String)map.get("indexed");
            Assert.assertEquals(uriToName.get(indexedUri), map.get("type"));
            ++counter;
        }
        Assert.assertEquals((long)2L, (long)counter);
        response.close();
    }

    private JaxRsResponse httpPostCreateRelationship(long startNode, String jsonString) {
        return RestRequest.req().post(functionalTestHelper.dataUri() + "node/" + startNode + "/relationships", jsonString);
    }

    private String jsonRelationshipCreationSpecification(String relationshipName, long endNode, String key, String value) {
        return "{\"to\" : \"" + functionalTestHelper.dataUri() + "node/" + endNode + "\"," + "\"type\" : \"" + relationshipName + "\", " + "\"data\" : {\"" + key + "\" : \"" + value + "\"}}";
    }

    @Test
    public void shouldGet200WhenGettingRelationshipFromIndexWithNoHits() {
        String indexName = "empty-index";
        helper.createRelationshipIndex(indexName);
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.indexRelationshipUri(indexName, "non-existent-key", "non-existent-value"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void shouldGet200WhenQueryingIndex() throws PropertyValueException {
        String indexName = "bobTheIndex";
        String key = "bobsKey";
        String value = "bobsValue";
        long relationship = helper.createRelationship("TYPE");
        helper.addRelationshipToIndex(indexName, key, value, relationship);
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.indexRelationshipUri(indexName) + "?query=" + key + ":" + value);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void shouldBeAbleToRemoveIndexing() throws JsonParseException {
        String key1 = "kvkey1";
        String key2 = "kvkey2";
        String value1 = "value1";
        String value2 = "value2";
        String indexName = "kvrel";
        long relationship = helper.createRelationship("some type");
        helper.setRelationshipProperties(relationship, MapUtil.map((Object[])new Object[]{key1, value1, key1, value2, key2, value1, key2, value2}));
        helper.addRelationshipToIndex(indexName, key1, value1, relationship);
        helper.addRelationshipToIndex(indexName, key1, value2, relationship);
        helper.addRelationshipToIndex(indexName, key2, value1, relationship);
        helper.addRelationshipToIndex(indexName, key2, value2, relationship);
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key1, value1).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key1, value2).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key2, value1).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key2, value2).size());
        JaxRsResponse response = RestRequest.req().delete(functionalTestHelper.relationshipIndexUri() + indexName + "/" + key1 + "/" + value1 + "/" + relationship);
        Assert.assertEquals((long)204L, (long)response.getStatus());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key1, value1).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key1, value2).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key2, value1).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key2, value2).size());
        response = RestRequest.req().delete(functionalTestHelper.relationshipIndexUri() + indexName + "/" + key2 + "/" + relationship);
        Assert.assertEquals((long)204L, (long)response.getStatus());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key1, value1).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key1, value2).size());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key2, value1).size());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key2, value2).size());
        response = RestRequest.req().delete(functionalTestHelper.relationshipIndexUri() + indexName + "/" + relationship);
        Assert.assertEquals((long)204L, (long)response.getStatus());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key1, value1).size());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key1, value2).size());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key2, value1).size());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key2, value2).size());
        response = RestRequest.req().delete(functionalTestHelper.indexRelationshipUri(indexName));
        Assert.assertEquals((long)204L, (long)response.getStatus());
        Assert.assertFalse((boolean)Arrays.asList(helper.getRelationshipIndexes()).contains(indexName));
    }

    @Test
    public void shouldBeAbleToIndexValuesContainingSpaces() throws Exception {
        long startNodeId = helper.createNode(new Label[0]);
        long endNodeId = helper.createNode(new Label[0]);
        String relationshiptype = "tested-together";
        long relationshipId = helper.createRelationship("tested-together", startNodeId, endNodeId);
        String key = "key";
        String value = "value with   spaces  in it";
        String indexName = "spacey-values";
        helper.createRelationshipIndex("spacey-values");
        JaxRsResponse response = this.httpPostIndexRelationshipNameKeyValue("spacey-values", relationshipId, "key", "value with   spaces  in it");
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        URI location = response.getLocation();
        response.close();
        response = this.httpGetIndexRelationshipNameKeyValue("spacey-values", "key", URIHelper.encode((String)"value with   spaces  in it"));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        String responseEntity = response.getEntity();
        Collection hits = (Collection)JsonHelper.jsonToSingleValue((String)responseEntity);
        Assert.assertEquals((long)1L, (long)hits.size());
        response.close();
        FunctionalTestHelper.CLIENT.resource(location).delete();
        response = this.httpGetIndexRelationshipNameKeyValue("spacey-values", "key", URIHelper.encode((String)"value with   spaces  in it"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        responseEntity = response.getEntity();
        hits = (Collection)JsonHelper.jsonToSingleValue((String)responseEntity);
        Assert.assertEquals((long)0L, (long)hits.size());
        response.close();
    }

    @Test
    public void shouldRespondWith400WhenSendingCorruptJson() throws Exception {
        String indexName = "botherable-index";
        helper.createRelationshipIndex("botherable-index");
        String corruptJson = "{[}";
        JaxRsResponse response = RestRequest.req().post(functionalTestHelper.indexRelationshipUri("botherable-index"), "{[}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Documented(value=" Get or create unique relationship (create).\n \n Create a unique relationship in an index.\n")
    @Test
    public void get_or_create_relationship() throws Exception {
        String index = "knowledge";
        String key = "name";
        String value = "Tobias";
        helper.createRelationshipIndex("knowledge");
        long start = helper.createNode(new Label[0]);
        long end = helper.createNode(new Label[0]);
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(201).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\":\"Tobias\", \"start\": \"" + functionalTestHelper.nodeUri(start) + "\", \"end\": \"" + functionalTestHelper.nodeUri(end) + "\", \"type\": \"" + "knowledge" + "\"}").post(functionalTestHelper.relationshipIndexUri() + "knowledge" + "/?uniqueness=get_or_create");
    }

    @Documented(value=" Get or create unique relationship (create).\n \n Add a relationship to an index unless a relationship already exists for the given mapping.\n Here, no previous relationship is found in the index, a new one is created and indexed.\n")
    @Test
    public void get_or_create_unique_relationship_create() throws Exception {
        String index = "knowledge";
        String key = "name";
        String value = "Mattias";
        helper.createRelationshipIndex("knowledge");
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(201).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\":\"Mattias\", \"uri\": \"" + functionalTestHelper.relationshipUri(helper.createRelationship("knowledge")) + "\"}").post(functionalTestHelper.relationshipIndexUri() + "knowledge" + "/?uniqueness=get_or_create");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Documented(value=" Get or create unique relationship (existing).\n \n Here, in case\n of an already existing relationship, the sent data is ignored and the\n existing relationship returned.\n")
    @Test
    public void get_or_create_unique_relationship_existing() throws Exception {
        String index = "rels";
        String key = "name";
        String value = "Peter";
        GraphDatabaseService graphdb = this.graphdb();
        helper.createRelationshipIndex("rels");
        Transaction tx = graphdb.beginTx();
        try {
            Node node1 = graphdb.createNode();
            Node node2 = graphdb.createNode();
            Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelationshipTypes.KNOWS);
            graphdb.index().forRelationships("rels").add((PropertyContainer)rel, "name", (Object)"Peter");
            tx.success();
        }
        finally {
            tx.finish();
        }
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Peter\", \"start\": \"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\", \"end\": \"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\", \"type\":\"" + (Object)((Object)MyRelationshipTypes.KNOWS) + "\"}").post(functionalTestHelper.relationshipIndexUri() + "rels" + "?uniqueness=get_or_create");
    }

    @Documented(value=" Create a unique relationship or return fail (create).\n \n Here, in case\n of an already existing relationship, an error should be returned. In this\n example, no existing relationship is found and a new relationship is created.\n")
    @Test
    public void create_a_unique_relationship_or_return_fail___create() throws Exception {
        String index = "rels";
        String key = "name";
        String value = "Tobias";
        helper.createRelationshipIndex("rels");
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(201).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Tobias\", \"start\": \"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\", \"end\": \"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\", \"type\":\"" + (Object)((Object)MyRelationshipTypes.KNOWS) + "\"}").post(functionalTestHelper.relationshipIndexUri() + "rels" + "?uniqueness=create_or_fail");
        MultivaluedMap<String, String> headers = response.response().getHeaders();
        Map result = JsonHelper.jsonToMap((String)response.entity());
        Assert.assertEquals(result.get("indexed"), (Object)headers.getFirst((Object)"Location"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Documented(value=" Create a unique relationship or return fail (fail).\n \n Here, in case\n of an already existing relationship, an error should be returned. In this\n example, an existing relationship is found and an error is returned.\n")
    @Test
    public void create_a_unique_relationship_or_return_fail___fail() throws Exception {
        String index = "rels";
        String key = "name";
        String value = "Peter";
        GraphDatabaseService graphdb = this.graphdb();
        helper.createRelationshipIndex("rels");
        Transaction tx = graphdb.beginTx();
        try {
            Node node1 = graphdb.createNode();
            Node node2 = graphdb.createNode();
            Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelationshipTypes.KNOWS);
            graphdb.index().forRelationships("rels").add((PropertyContainer)rel, "name", (Object)"Peter");
            tx.success();
        }
        finally {
            tx.finish();
        }
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(409).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Peter\", \"start\": \"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\", \"end\": \"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\", \"type\":\"" + (Object)((Object)MyRelationshipTypes.KNOWS) + "\"}").post(functionalTestHelper.relationshipIndexUri() + "rels" + "?uniqueness=create_or_fail");
    }

    @Documented(value=" Add a relationship to an index \n unless a node already exists for the given mapping then return fail (case create).\n")
    @Test
    public void put_relationship_or_fail_if_absent() throws Exception {
        String index = "rels";
        String key = "name";
        String value = "Peter";
        helper.createRelationshipIndex("rels");
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(201).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Peter\", \"uri\":\"" + functionalTestHelper.relationshipUri(helper.createRelationship("KNOWS", helper.createNode(new Label[0]), helper.createNode(new Label[0]))) + "\"}").post(functionalTestHelper.relationshipIndexUri() + "rels" + "?uniqueness=create_or_fail");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Documented(value=" Add a relationship to an index \n unless a node already exists for the given mapping then return fail (case fail).\n")
    @Test
    public void put_relationship_if_absent_only_fail() throws Exception {
        Relationship rel;
        String index = "rels";
        String key = "name";
        String value = "Peter";
        GraphDatabaseService graphdb = this.graphdb();
        helper.createRelationshipIndex("rels");
        Transaction tx = graphdb.beginTx();
        try {
            Node node1 = graphdb.createNode();
            Node node2 = graphdb.createNode();
            rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelationshipTypes.KNOWS);
            graphdb.index().forRelationships("rels").add((PropertyContainer)rel, "name", (Object)"Peter");
            tx.success();
        }
        finally {
            tx.finish();
        }
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(409).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Peter\", \"uri\":\"" + functionalTestHelper.relationshipUri(rel.getId()) + "\"}").post(functionalTestHelper.relationshipIndexUri() + "rels" + "?uniqueness=create_or_fail");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createUniqueShouldBeBackwardsCompatibleWith1_8() throws Exception {
        String index = "rels";
        String key = "name";
        String value = "Peter";
        GraphDatabaseService graphdb = this.graphdb();
        helper.createRelationshipIndex("rels");
        Transaction tx = graphdb.beginTx();
        try {
            Node node1 = graphdb.createNode();
            Node node2 = graphdb.createNode();
            Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelationshipTypes.KNOWS);
            graphdb.index().forRelationships("rels").add((PropertyContainer)rel, "name", (Object)"Peter");
            tx.success();
        }
        finally {
            tx.finish();
        }
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Peter\", \"start\": \"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\", \"end\": \"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\", \"type\":\"" + (Object)((Object)MyRelationshipTypes.KNOWS) + "\"}").post(functionalTestHelper.relationshipIndexUri() + "rels" + "?unique");
    }

    private static enum MyRelationshipTypes implements RelationshipType
    {
        KNOWS;

    }
}

