/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.IteratorUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.cypher.javacompat.PlanDescription;
import org.neo4j.cypher.javacompat.ProfilerStatistics;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.repr.CypherResultRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;

public class CypherResultRepresentationTest {
    @Test
    public void shouldSerializeProfilingResult() throws Exception {
        String name = "Kalle";
        PlanDescription plan = this.getMockDescription(name);
        PlanDescription childPlan = this.getMockDescription("child");
        Mockito.when((Object)plan.getChildren()).thenReturn(Arrays.asList(childPlan));
        Mockito.when((Object)plan.hasProfilerStatistics()).thenReturn((Object)true);
        ProfilerStatistics stats = (ProfilerStatistics)Mockito.mock(ProfilerStatistics.class);
        Mockito.when((Object)stats.getDbHits()).thenReturn((Object)13L);
        Mockito.when((Object)stats.getRows()).thenReturn((Object)25L);
        Mockito.when((Object)plan.getProfilerStatistics()).thenReturn((Object)stats);
        ExecutionResult result = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)result.iterator()).thenReturn((Object)IteratorUtils.emptyIterator());
        Mockito.when((Object)result.columns()).thenReturn(new ArrayList());
        Mockito.when((Object)result.executionPlanDescription()).thenReturn((Object)plan);
        Map<String, Object> serialized = this.serialize(new CypherResultRepresentation(result, false, true));
        Map serializedPlan = (Map)serialized.get("plan");
        Assert.assertThat((Object)((String)serializedPlan.get("name")), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat((Object)((Integer)serializedPlan.get("rows")), (Matcher)CoreMatchers.is((Object)25));
        Assert.assertThat((Object)((Integer)serializedPlan.get("dbHits")), (Matcher)CoreMatchers.is((Object)13));
        List children = (List)serializedPlan.get("children");
        Assert.assertThat((Object)children.size(), (Matcher)CoreMatchers.is((Object)1));
        Map args = (Map)serializedPlan.get("args");
        Assert.assertThat((Object)((String)args.get("argumentKey")), (Matcher)CoreMatchers.is((Object)"argumentValue"));
    }

    @Test
    public void shouldNotIncludePlanUnlessAskedFor() throws Exception {
        ExecutionResult result = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)result.iterator()).thenReturn((Object)IteratorUtils.emptyIterator());
        Mockito.when((Object)result.columns()).thenReturn(new ArrayList());
        Map<String, Object> serialized = this.serialize(new CypherResultRepresentation(result, false, false));
        Assert.assertFalse((String)"Didn't expect to see a plan here", (boolean)serialized.containsKey("plan"));
    }

    private PlanDescription getMockDescription(String name) {
        PlanDescription plan = (PlanDescription)Mockito.mock(PlanDescription.class);
        Mockito.when((Object)plan.getName()).thenReturn((Object)name);
        Mockito.when((Object)plan.getArguments()).thenReturn((Object)MapUtil.map((Object[])new Object[]{"argumentKey", "argumentValue"}));
        return plan;
    }

    private Map<String, Object> serialize(CypherResultRepresentation repr) throws URISyntaxException, JsonParseException {
        OutputFormat format = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://localhost/"), null);
        return JsonHelper.jsonToMap((String)format.assemble((Representation)repr));
    }
}

