/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.ServerBuilder;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class ConfigureEnabledManagementConsolesTest
extends ExclusiveServerTestBase {
    private NeoServer server;

    @After
    public void stopTheServer() {
        this.server.stop();
    }

    @Test
    public void shouldBeAbleToExplicitlySetConsolesToEnabled() throws Exception {
        this.server = ServerBuilder.server().withProperty("org.neo4j.server.manage.console_engines", "").build();
        this.server.start();
        Assert.assertThat((Object)this.exec("ls", "shell").getStatus(), (Matcher)Matchers.is((Object)400));
    }

    @Test
    public void shellConsoleShouldBeEnabledByDefault() throws Exception {
        this.server = ServerBuilder.server().build();
        this.server.start();
        Assert.assertThat((Object)this.exec("ls", "shell").getStatus(), (Matcher)Matchers.is((Object)200));
    }

    private JaxRsResponse exec(String command, String engine) {
        return RestRequest.req().post(this.server.baseUri() + "db/manage/server/console", "{\"engine\":\"" + engine + "\"," + "\"command\":\"" + command + "\\n\"}");
    }
}

