/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.server.webadmin.console.ConsoleSessionFactory;
import org.neo4j.server.webadmin.console.ScriptSession;
import org.neo4j.server.webadmin.rest.console.ConsoleService;

public class ConsoleServiceTest {
    private final URI uri = URI.create("http://peteriscool.com:6666/");

    @Test
    public void correctRepresentation() throws URISyntaxException, UnsupportedEncodingException {
        ConsoleService consoleService = new ConsoleService((ConsoleSessionFactory)new ShellOnlyConsoleSessionFactory(), null, new OutputFormat((RepresentationFormat)new JsonFormat(), this.uri, null));
        Response consoleResponse = consoleService.getServiceDefinition();
        Assert.assertEquals((long)200L, (long)consoleResponse.getStatus());
        String response = this.decode(consoleResponse);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"resources"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)this.uri.toString()));
    }

    @Test
    public void advertisesAvailableConsoleEngines() throws URISyntaxException, UnsupportedEncodingException {
        ConsoleService consoleServiceWithJustShellEngine = new ConsoleService((ConsoleSessionFactory)new ShellOnlyConsoleSessionFactory(), null, new OutputFormat((RepresentationFormat)new JsonFormat(), this.uri, null));
        String response = this.decode(consoleServiceWithJustShellEngine.getServiceDefinition());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\"engines\" : [ \"shell\" ]"));
    }

    private String decode(Response response) throws UnsupportedEncodingException {
        return new String((byte[])response.getEntity(), "UTF-8");
    }

    private static class ShellOnlyConsoleSessionFactory
    implements ConsoleSessionFactory {
        private ShellOnlyConsoleSessionFactory() {
        }

        public ScriptSession createSession(String engineName, Database database) {
            return null;
        }

        public Iterable<String> supportedEngines() {
            return new ArrayList<String>(){
                {
                    this.add("shell");
                }
            };
        }
    }
}

