/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import com.sun.jersey.api.core.HttpContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.search.Sort;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Expander;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.graphdb.index.ReadableRelationshipIndex;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.graphdb.index.UniqueFactory;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.TransactionBuilder;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.InjectableProvider;
import org.neo4j.server.rest.domain.EndNodeNotFoundException;
import org.neo4j.server.rest.domain.PropertySettingStrategy;
import org.neo4j.server.rest.domain.RelationshipExpanderBuilder;
import org.neo4j.server.rest.domain.StartNodeNotFoundException;
import org.neo4j.server.rest.domain.TraversalDescriptionBuilder;
import org.neo4j.server.rest.domain.TraverserReturnType;
import org.neo4j.server.rest.paging.Lease;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.paging.PagedTraverser;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.DatabaseRepresentation;
import org.neo4j.server.rest.repr.IndexDefinitionRepresentation;
import org.neo4j.server.rest.repr.IndexRepresentation;
import org.neo4j.server.rest.repr.IndexedEntityRepresentation;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.NodeIndexRepresentation;
import org.neo4j.server.rest.repr.NodeIndexRootRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.PropertiesRepresentation;
import org.neo4j.server.rest.repr.RelationshipIndexRepresentation;
import org.neo4j.server.rest.repr.RelationshipIndexRootRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ScoredNodeRepresentation;
import org.neo4j.server.rest.repr.ScoredRelationshipRepresentation;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.server.rest.repr.WeightedPathRepresentation;
import org.neo4j.server.rest.web.NoSuchPropertyException;
import org.neo4j.server.rest.web.NodeNotFoundException;
import org.neo4j.server.rest.web.OperationFailureException;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.server.rest.web.RelationshipNotFoundException;
import org.neo4j.tooling.GlobalGraphOperations;

public class DatabaseActions {
    public static final String SCORE_ORDER = "score";
    public static final String RELEVANCE_ORDER = "relevance";
    public static final String INDEX_ORDER = "index";
    private final Database database;
    private final GraphDatabaseAPI graphDb;
    private final LeaseManager leases;
    private final ForceMode defaultForceMode;
    private final TraversalDescriptionBuilder traversalDescriptionBuilder;
    private final boolean enableScriptSandboxing;
    private final PropertySettingStrategy propertySetter;
    private static final PathRepresentationCreator<Path> PATH_REPRESENTATION_CREATOR = new PathRepresentationCreator<Path>(){

        @Override
        public PathRepresentation<Path> from(Path path) {
            return new PathRepresentation<Path>(path);
        }
    };
    private static final PathRepresentationCreator<WeightedPath> WEIGHTED_PATH_REPRESENTATION_CREATOR = new PathRepresentationCreator<WeightedPath>(){

        @Override
        public PathRepresentation<WeightedPath> from(WeightedPath path) {
            return new WeightedPathRepresentation(path);
        }
    };

    public DatabaseActions(Database database, LeaseManager leaseManager, ForceMode defaultForceMode, boolean enableScriptSandboxing) {
        this.leases = leaseManager;
        this.defaultForceMode = defaultForceMode;
        this.database = database;
        this.graphDb = database.getGraph();
        this.enableScriptSandboxing = enableScriptSandboxing;
        this.traversalDescriptionBuilder = new TraversalDescriptionBuilder(enableScriptSandboxing);
        this.propertySetter = new PropertySettingStrategy(this.graphDb);
    }

    public DatabaseActions(Database database, LeaseManager leaseManager, ForceMode defaultForceMode) {
        this(database, leaseManager, defaultForceMode, true);
    }

    public DatabaseActions forceMode(ForceMode forceMode) {
        return forceMode == this.defaultForceMode || forceMode == null ? this : new DatabaseActions(this.database, this.leases, forceMode, this.enableScriptSandboxing);
    }

    private Node node(long id) throws NodeNotFoundException {
        try {
            return this.graphDb.getNodeById(id);
        }
        catch (NotFoundException e) {
            throw new NodeNotFoundException(String.format("Cannot find node with id [%d] in database.", id));
        }
    }

    private Relationship relationship(long id) throws RelationshipNotFoundException {
        try {
            return this.graphDb.getRelationshipById(id);
        }
        catch (NotFoundException e) {
            throw new RelationshipNotFoundException();
        }
    }

    public DatabaseRepresentation root() {
        return new DatabaseRepresentation((GraphDatabaseService)this.graphDb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRepresentation createNode(Map<String, Object> properties, Label ... labels) throws PropertyValueException {
        NodeRepresentation result;
        Transaction tx = this.beginTx();
        try {
            Node node = this.graphDb.createNode();
            this.propertySetter.setProperties((PropertyContainer)node, properties);
            if (labels != null) {
                for (Label label : labels) {
                    node.addLabel(label);
                }
            }
            result = new NodeRepresentation(node);
            tx.success();
        }
        finally {
            tx.finish();
        }
        return result;
    }

    private Transaction beginTx() {
        TransactionBuilder tx = this.graphDb.tx();
        if (this.defaultForceMode == ForceMode.unforced) {
            tx = tx.unforced();
        }
        return tx.begin();
    }

    public NodeRepresentation getNode(long nodeId) throws NodeNotFoundException {
        return new NodeRepresentation(this.node(nodeId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(long nodeId) throws NodeNotFoundException, OperationFailureException {
        Node node = this.node(nodeId);
        Transaction tx = this.beginTx();
        try {
            node.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            try {
                tx.finish();
            }
            catch (TransactionFailureException e) {
                throw new OperationFailureException(String.format("The node with id %d cannot be deleted. Check that the node is orphaned before deletion.", nodeId));
            }
            throw throwable;
        }
        try {
            tx.finish();
        }
        catch (TransactionFailureException e) {
            throw new OperationFailureException(String.format("The node with id %d cannot be deleted. Check that the node is orphaned before deletion.", nodeId));
        }
    }

    @Deprecated
    public NodeRepresentation getReferenceNode() {
        return new NodeRepresentation(this.graphDb.getReferenceNode());
    }

    public Representation getNodeProperty(long nodeId, String key) throws NodeNotFoundException, NoSuchPropertyException {
        Node node = this.node(nodeId);
        try {
            return PropertiesRepresentation.value(node.getProperty(key));
        }
        catch (NotFoundException e) {
            throw new NoSuchPropertyException((PropertyContainer)node, key);
        }
    }

    public void setNodeProperty(long nodeId, String key, Object value) throws PropertyValueException, NodeNotFoundException {
        Node node = this.node(nodeId);
        this.propertySetter.setProperty((PropertyContainer)node, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeProperty(long nodeId, String key) throws NodeNotFoundException, NoSuchPropertyException {
        Node node = this.node(nodeId);
        Transaction tx = this.beginTx();
        try {
            if (node.removeProperty(key) == null) {
                throw new NoSuchPropertyException((PropertyContainer)node, key);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public PropertiesRepresentation getAllNodeProperties(long nodeId) throws NodeNotFoundException {
        return new PropertiesRepresentation((PropertyContainer)this.node(nodeId));
    }

    public void setAllNodeProperties(long nodeId, Map<String, Object> properties) throws PropertyValueException, NodeNotFoundException {
        this.propertySetter.setAllProperties((PropertyContainer)this.node(nodeId), properties);
    }

    public void removeAllNodeProperties(long nodeId) throws NodeNotFoundException, PropertyValueException {
        this.propertySetter.setAllProperties((PropertyContainer)this.node(nodeId), null);
    }

    public void addLabelToNode(long nodeId, Collection<String> labelNames) throws NodeNotFoundException, BadInputException {
        Node node = this.node(nodeId);
        Transaction tx = this.beginTx();
        try {
            for (String labelName : labelNames) {
                node.addLabel(DynamicLabel.label((String)labelName));
            }
            tx.success();
        }
        catch (ConstraintViolationException e) {
            throw new BadInputException("Unable to add label, see nested exception.", (Throwable)e);
        }
        finally {
            tx.finish();
        }
    }

    public void setLabelsOnNode(long nodeId, Collection<String> labels) throws NodeNotFoundException, BadInputException {
        Node node = this.node(nodeId);
        Transaction tx = this.beginTx();
        try {
            for (Label label : node.getLabels()) {
                node.removeLabel(label);
            }
            for (String labelName : labels) {
                node.addLabel(DynamicLabel.label((String)labelName));
            }
            tx.success();
        }
        catch (ConstraintViolationException e) {
            throw new BadInputException("Unable to add label, see nested exception.", (Throwable)e);
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLabelFromNode(long nodeId, String labelName) throws NodeNotFoundException {
        Node node = this.node(nodeId);
        Transaction tx = this.beginTx();
        try {
            node.removeLabel(DynamicLabel.label((String)labelName));
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public ListRepresentation getNodeLabels(long nodeId) throws NodeNotFoundException {
        IterableWrapper<String, Label> labels = new IterableWrapper<String, Label>(this.node(nodeId).getLabels()){

            protected String underlyingObjectToObject(Label object) {
                return object.name();
            }
        };
        return ListRepresentation.string((Iterable)labels);
    }

    public String[] getNodeIndexNames() {
        return this.graphDb.index().nodeIndexNames();
    }

    public String[] getRelationshipIndexNames() {
        return this.graphDb.index().relationshipIndexNames();
    }

    public IndexRepresentation createNodeIndex(Map<String, Object> indexSpecification) {
        String indexName = (String)indexSpecification.get("name");
        this.assertIsLegalIndexName(indexName);
        if (indexSpecification.containsKey("config")) {
            Map config = (Map)indexSpecification.get("config");
            this.graphDb.index().forNodes(indexName, config);
            return new NodeIndexRepresentation(indexName, config);
        }
        this.graphDb.index().forNodes(indexName);
        return new NodeIndexRepresentation(indexName, Collections.<String, String>emptyMap());
    }

    public IndexRepresentation createRelationshipIndex(Map<String, Object> indexSpecification) {
        String indexName = (String)indexSpecification.get("name");
        this.assertIsLegalIndexName(indexName);
        if (indexSpecification.containsKey("config")) {
            Map config = (Map)indexSpecification.get("config");
            this.graphDb.index().forRelationships(indexName, config);
            return new RelationshipIndexRepresentation(indexName, config);
        }
        this.graphDb.index().forRelationships(indexName);
        return new RelationshipIndexRepresentation(indexName, Collections.<String, String>emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeIndex(String indexName) {
        if (!this.graphDb.index().existsForNodes(indexName)) {
            throw new NotFoundException("No node index named '" + indexName + "'.");
        }
        Index index = this.graphDb.index().forNodes(indexName);
        Transaction tx = this.beginTx();
        try {
            index.delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRelationshipIndex(String indexName) {
        if (!this.graphDb.index().existsForRelationships(indexName)) {
            throw new NotFoundException("No relationship index named '" + indexName + "'.");
        }
        RelationshipIndex index = this.graphDb.index().forRelationships(indexName);
        Transaction tx = this.beginTx();
        try {
            index.delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nodeIsIndexed(String indexName, String key, Object value, long nodeId) {
        Index index = this.graphDb.index().forNodes(indexName);
        Transaction tx = this.beginTx();
        try {
            Node expectedNode = this.graphDb.getNodeById(nodeId);
            IndexHits hits = index.get(key, value);
            boolean contains = this.iterableContains((Iterable)hits, (Object)expectedNode);
            tx.success();
            boolean bl = contains;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relationshipIsIndexed(String indexName, String key, Object value, long relationshipId) {
        RelationshipIndex index = this.graphDb.index().forRelationships(indexName);
        Transaction tx = this.beginTx();
        try {
            Relationship expectedNode = this.graphDb.getRelationshipById(relationshipId);
            IndexHits hits = index.get(key, value);
            boolean contains = this.iterableContains((Iterable)hits, (Object)expectedNode);
            tx.success();
            boolean bl = contains;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    private <T> boolean iterableContains(Iterable<T> iterable, T expectedElement) {
        for (T possibleMatch : iterable) {
            if (!possibleMatch.equals(expectedElement)) continue;
            return true;
        }
        return false;
    }

    public Representation isAutoIndexerEnabled(String type) {
        AutoIndexer<? extends PropertyContainer> index = this.getAutoIndexerForType(type);
        return ValueRepresentation.bool((boolean)index.isEnabled());
    }

    public void setAutoIndexerEnabled(String type, boolean enable) {
        AutoIndexer<? extends PropertyContainer> index = this.getAutoIndexerForType(type);
        index.setEnabled(enable);
    }

    private AutoIndexer<? extends PropertyContainer> getAutoIndexerForType(String type) {
        IndexManager indexManager = this.graphDb.index();
        if ("node".equals(type)) {
            return indexManager.getNodeAutoIndexer();
        }
        if ("relationship".equals(type)) {
            return indexManager.getRelationshipAutoIndexer();
        }
        throw new IllegalArgumentException("invalid type " + type);
    }

    public Representation getAutoIndexedProperties(String type) {
        AutoIndexer<? extends PropertyContainer> indexer = this.getAutoIndexerForType(type);
        return ListRepresentation.string((Iterable)indexer.getAutoIndexedProperties());
    }

    public void startAutoIndexingProperty(String type, String property) {
        AutoIndexer<? extends PropertyContainer> indexer = this.getAutoIndexerForType(type);
        indexer.startAutoIndexingProperty(property);
    }

    public void stopAutoIndexingProperty(String type, String property) {
        AutoIndexer<? extends PropertyContainer> indexer = this.getAutoIndexerForType(type);
        indexer.stopAutoIndexingProperty(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipRepresentation createRelationship(long startNodeId, long endNodeId, String type, Map<String, Object> properties) throws StartNodeNotFoundException, EndNodeNotFoundException, PropertyValueException {
        RelationshipRepresentation result;
        Node end;
        Node start;
        try {
            start = this.node(startNodeId);
        }
        catch (NodeNotFoundException e) {
            throw new StartNodeNotFoundException();
        }
        try {
            end = this.node(endNodeId);
        }
        catch (NodeNotFoundException e) {
            throw new EndNodeNotFoundException();
        }
        Transaction tx = this.beginTx();
        try {
            Relationship rel = start.createRelationshipTo(end, (RelationshipType)DynamicRelationshipType.withName((String)type));
            this.propertySetter.setProperties((PropertyContainer)rel, properties);
            result = new RelationshipRepresentation(rel);
            tx.success();
        }
        finally {
            tx.finish();
        }
        return result;
    }

    public RelationshipRepresentation getRelationship(long relationshipId) throws RelationshipNotFoundException {
        return new RelationshipRepresentation(this.relationship(relationshipId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRelationship(long relationshipId) throws RelationshipNotFoundException {
        Relationship relationship = this.relationship(relationshipId);
        Transaction tx = this.beginTx();
        try {
            relationship.delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public ListRepresentation getNodeRelationships(long nodeId, RelationshipDirection direction, Collection<String> types) throws NodeNotFoundException {
        Expander expander;
        Node node = this.node(nodeId);
        if (types.isEmpty()) {
            expander = Traversal.expanderForAllTypes((Direction)direction.internal);
        } else {
            expander = Traversal.emptyExpander();
            for (String type : types) {
                expander = expander.add((RelationshipType)DynamicRelationshipType.withName((String)type), direction.internal);
            }
        }
        return RelationshipRepresentation.list(expander.expand(node));
    }

    public PropertiesRepresentation getAllRelationshipProperties(long relationshipId) throws RelationshipNotFoundException {
        return new PropertiesRepresentation((PropertyContainer)this.relationship(relationshipId));
    }

    public Representation getRelationshipProperty(long relationshipId, String key) throws NoSuchPropertyException, RelationshipNotFoundException {
        Relationship relationship = this.relationship(relationshipId);
        try {
            return PropertiesRepresentation.value(relationship.getProperty(key));
        }
        catch (NotFoundException e) {
            throw new NoSuchPropertyException((PropertyContainer)relationship, key);
        }
    }

    public void setAllRelationshipProperties(long relationshipId, Map<String, Object> properties) throws PropertyValueException, RelationshipNotFoundException {
        this.propertySetter.setAllProperties((PropertyContainer)this.relationship(relationshipId), properties);
    }

    public void setRelationshipProperty(long relationshipId, String key, Object value) throws PropertyValueException, RelationshipNotFoundException {
        Relationship relationship = this.relationship(relationshipId);
        this.propertySetter.setProperty((PropertyContainer)relationship, key, value);
    }

    public void removeAllRelationshipProperties(long relationshipId) throws RelationshipNotFoundException, PropertyValueException {
        this.propertySetter.setAllProperties((PropertyContainer)this.relationship(relationshipId), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRelationshipProperty(long relationshipId, String key) throws RelationshipNotFoundException, NoSuchPropertyException {
        Relationship relationship = this.relationship(relationshipId);
        Transaction tx = this.beginTx();
        try {
            if (relationship.removeProperty(key) == null) {
                throw new NoSuchPropertyException((PropertyContainer)relationship, key);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public Representation nodeIndexRoot() {
        return new NodeIndexRootRepresentation(this.graphDb.index());
    }

    public Representation relationshipIndexRoot() {
        return new RelationshipIndexRootRepresentation(this.graphDb.index());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexedEntityRepresentation addToRelationshipIndex(String indexName, String key, String value, long relationshipId) {
        Transaction tx = this.beginTx();
        try {
            Relationship relationship = this.graphDb.getRelationshipById(relationshipId);
            RelationshipIndex index = this.graphDb.index().forRelationships(indexName);
            index.add((PropertyContainer)relationship, key, (Object)value);
            tx.success();
            IndexedEntityRepresentation indexedEntityRepresentation = new IndexedEntityRepresentation(relationship, key, value, (IndexRepresentation)new RelationshipIndexRepresentation(indexName, Collections.<String, String>emptyMap()));
            return indexedEntityRepresentation;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexedEntityRepresentation addToNodeIndex(String indexName, String key, String value, long nodeId) {
        Transaction tx = this.beginTx();
        try {
            Node node = this.graphDb.getNodeById(nodeId);
            Index index = this.graphDb.index().forNodes(indexName);
            index.add((PropertyContainer)node, key, (Object)value);
            tx.success();
            IndexedEntityRepresentation indexedEntityRepresentation = new IndexedEntityRepresentation(node, key, value, (IndexRepresentation)new NodeIndexRepresentation(indexName, Collections.<String, String>emptyMap()));
            return indexedEntityRepresentation;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromNodeIndex(String indexName, String key, String value, long id) {
        Index index = this.graphDb.index().forNodes(indexName);
        Transaction tx = this.beginTx();
        try {
            index.remove((PropertyContainer)this.graphDb.getNodeById(id), key, (Object)value);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromNodeIndexNoValue(String indexName, String key, long id) {
        Index index = this.graphDb.index().forNodes(indexName);
        Transaction tx = this.beginTx();
        try {
            index.remove((PropertyContainer)this.graphDb.getNodeById(id), key);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromNodeIndexNoKeyValue(String indexName, long id) {
        Index index = this.graphDb.index().forNodes(indexName);
        Transaction tx = this.beginTx();
        try {
            index.remove((PropertyContainer)this.graphDb.getNodeById(id));
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromRelationshipIndex(String indexName, String key, String value, long id) {
        RelationshipIndex index = this.graphDb.index().forRelationships(indexName);
        Transaction tx = this.beginTx();
        try {
            index.remove((PropertyContainer)this.graphDb.getRelationshipById(id), key, (Object)value);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromRelationshipIndexNoValue(String indexName, String key, long id) {
        RelationshipIndex index = this.graphDb.index().forRelationships(indexName);
        Transaction tx = this.beginTx();
        try {
            index.remove((PropertyContainer)this.graphDb.getRelationshipById(id), key);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromRelationshipIndexNoKeyValue(String indexName, long id) {
        RelationshipIndex index = this.graphDb.index().forRelationships(indexName);
        Transaction tx = this.beginTx();
        try {
            index.remove((PropertyContainer)this.graphDb.getRelationshipById(id));
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public IndexedEntityRepresentation getIndexedNode(String indexName, String key, String value, long id) {
        if (!this.nodeIsIndexed(indexName, key, value, id)) {
            throw new NotFoundException();
        }
        Node node = this.graphDb.getNodeById(id);
        return new IndexedEntityRepresentation(node, key, value, (IndexRepresentation)new NodeIndexRepresentation(indexName, Collections.<String, String>emptyMap()));
    }

    public IndexedEntityRepresentation getIndexedRelationship(String indexName, String key, String value, long id) {
        if (!this.relationshipIsIndexed(indexName, key, value, id)) {
            throw new NotFoundException();
        }
        Relationship node = this.graphDb.getRelationshipById(id);
        return new IndexedEntityRepresentation(node, key, value, (IndexRepresentation)new RelationshipIndexRepresentation(indexName, Collections.<String, String>emptyMap()));
    }

    public ListRepresentation getIndexedNodes(String indexName, final String key, final String value) {
        if (!this.graphDb.index().existsForNodes(indexName)) {
            throw new NotFoundException();
        }
        Index index = this.graphDb.index().forNodes(indexName);
        final NodeIndexRepresentation indexRepresentation = new NodeIndexRepresentation(indexName);
        IndexHits indexHits = index.get(key, (Object)value);
        IterableWrapper<Representation, Node> results = new IterableWrapper<Representation, Node>((Iterable)indexHits){

            protected Representation underlyingObjectToObject(Node node) {
                return new IndexedEntityRepresentation(node, key, value, indexRepresentation);
            }
        };
        return new ListRepresentation(RepresentationType.NODE, (Iterable)results);
    }

    public ListRepresentation getIndexedNodesByQuery(String indexName, String query, String sort) {
        return this.getIndexedNodesByQuery(indexName, null, query, sort);
    }

    public ListRepresentation getIndexedNodesByQuery(String indexName, String key, String query, String sort) {
        if (!this.graphDb.index().existsForNodes(indexName)) {
            throw new NotFoundException();
        }
        if (query == null) {
            return this.toListNodeRepresentation();
        }
        Index index = this.graphDb.index().forNodes(indexName);
        IndexResultOrder order = this.getOrdering(sort);
        QueryContext queryCtx = order.updateQueryContext(new QueryContext((Object)query));
        IndexHits result = index.query(key, (Object)queryCtx);
        return this.toListNodeRepresentation((IndexHits<Node>)result, order);
    }

    private ListRepresentation toListNodeRepresentation() {
        return new ListRepresentation(RepresentationType.NODE, Collections.emptyList());
    }

    private ListRepresentation toListNodeRepresentation(final IndexHits<Node> result, final IndexResultOrder order) {
        if (result == null) {
            return new ListRepresentation(RepresentationType.NODE, Collections.emptyList());
        }
        IterableWrapper<Representation, Node> results = new IterableWrapper<Representation, Node>(result){

            protected Representation underlyingObjectToObject(Node node) {
                NodeRepresentation nodeRepresentation = new NodeRepresentation(node);
                if (order == null) {
                    return nodeRepresentation;
                }
                return order.getRepresentationFor((Representation)nodeRepresentation, result.currentScore());
            }
        };
        return new ListRepresentation(RepresentationType.NODE, (Iterable)results);
    }

    private ListRepresentation toListRelationshipRepresentation() {
        return new ListRepresentation(RepresentationType.RELATIONSHIP, Collections.emptyList());
    }

    private ListRepresentation toListRelationshipRepresentation(final IndexHits<Relationship> result, final IndexResultOrder order) {
        if (result == null) {
            return new ListRepresentation(RepresentationType.RELATIONSHIP, Collections.emptyList());
        }
        IterableWrapper<Representation, Relationship> results = new IterableWrapper<Representation, Relationship>(result){

            protected Representation underlyingObjectToObject(Relationship rel) {
                RelationshipRepresentation relationshipRepresentation = new RelationshipRepresentation(rel);
                if (order != null) {
                    return order.getRepresentationFor((Representation)relationshipRepresentation, result.currentScore());
                }
                return relationshipRepresentation;
            }
        };
        return new ListRepresentation(RepresentationType.RELATIONSHIP, (Iterable)results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<IndexedEntityRepresentation, Boolean> getOrCreateIndexedNode(String indexName, String key, String value, Long nodeOrNull, Map<String, Object> properties) throws BadInputException, NodeNotFoundException {
        this.assertIsLegalIndexName(indexName);
        Transaction tx = this.beginTx();
        try {
            boolean created;
            Node result;
            if (nodeOrNull != null) {
                if (properties != null) {
                    throw new BadInputException("Cannot specify properties for a new node, when a node to index is specified.");
                }
                Node node = this.node(nodeOrNull);
                result = (Node)this.graphDb.index().forNodes(indexName).putIfAbsent((PropertyContainer)node, key, (Object)value);
                created = result == null;
                if (created) {
                    result = node;
                }
            } else {
                UniqueNodeFactory factory = new UniqueNodeFactory(indexName, properties);
                result = (Node)factory.getOrCreate(key, value);
                created = factory.created;
            }
            tx.success();
            Pair pair = Pair.of((Object)new IndexedEntityRepresentation(result, key, value, (IndexRepresentation)new NodeIndexRepresentation(indexName, Collections.<String, String>emptyMap())), (Object)created);
            return pair;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<IndexedEntityRepresentation, Boolean> getOrCreateIndexedRelationship(String indexName, String key, String value, Long relationshipOrNull, Long startNode, String type, Long endNode, Map<String, Object> properties) throws BadInputException, RelationshipNotFoundException, NodeNotFoundException {
        this.assertIsLegalIndexName(indexName);
        Transaction tx = this.beginTx();
        try {
            boolean created;
            Relationship result;
            if (relationshipOrNull != null) {
                if (startNode != null || type != null || endNode != null || properties != null) {
                    throw new BadInputException("Either specify a relationship to index uniquely, or the means for creating it.");
                }
                Relationship relationship = this.relationship(relationshipOrNull);
                result = (Relationship)this.graphDb.index().forRelationships(indexName).putIfAbsent((PropertyContainer)relationship, key, (Object)value);
                created = result == null;
                if (created) {
                    result = relationship;
                }
            } else {
                if (startNode == null || type == null || endNode == null) {
                    throw new BadInputException("Either specify a relationship to index uniquely, or the means for creating it.");
                }
                UniqueRelationshipFactory factory = new UniqueRelationshipFactory(indexName, this.node(startNode), this.node(endNode), type, properties);
                result = (Relationship)factory.getOrCreate(key, value);
                created = factory.created;
            }
            tx.success();
            Pair pair = Pair.of((Object)new IndexedEntityRepresentation(result, key, value, (IndexRepresentation)new RelationshipIndexRepresentation(indexName, Collections.<String, String>emptyMap())), (Object)created);
            return pair;
        }
        finally {
            tx.finish();
        }
    }

    public Representation getAutoIndexedNodes(String key, String value) {
        ReadableIndex index = this.graphDb.index().getNodeAutoIndexer().getAutoIndex();
        return this.toListNodeRepresentation((IndexHits<Node>)index.get(key, (Object)value), null);
    }

    public ListRepresentation getAutoIndexedNodesByQuery(String query) {
        if (query != null) {
            ReadableIndex index = this.graphDb.index().getNodeAutoIndexer().getAutoIndex();
            return this.toListNodeRepresentation((IndexHits<Node>)index.query((Object)query), null);
        }
        return this.toListNodeRepresentation();
    }

    public ListRepresentation getIndexedRelationships(String indexName, final String key, final String value) {
        if (!this.graphDb.index().existsForRelationships(indexName)) {
            throw new NotFoundException();
        }
        RelationshipIndex index = this.graphDb.index().forRelationships(indexName);
        final RelationshipIndexRepresentation indexRepresentation = new RelationshipIndexRepresentation(indexName);
        IterableWrapper<Representation, Relationship> result = new IterableWrapper<Representation, Relationship>((Iterable)index.get(key, (Object)value)){

            protected Representation underlyingObjectToObject(Relationship relationship) {
                return new IndexedEntityRepresentation(relationship, key, value, indexRepresentation);
            }
        };
        return new ListRepresentation(RepresentationType.RELATIONSHIP, (Iterable)result);
    }

    public ListRepresentation getIndexedRelationshipsByQuery(String indexName, String query, String sort) {
        return this.getIndexedRelationshipsByQuery(indexName, null, query, sort);
    }

    public ListRepresentation getIndexedRelationshipsByQuery(String indexName, String key, String query, String sort) {
        if (!this.graphDb.index().existsForRelationships(indexName)) {
            throw new NotFoundException();
        }
        if (query == null) {
            return this.toListRelationshipRepresentation();
        }
        RelationshipIndex index = this.graphDb.index().forRelationships(indexName);
        IndexResultOrder order = this.getOrdering(sort);
        QueryContext queryCtx = order.updateQueryContext(new QueryContext((Object)query));
        return this.toListRelationshipRepresentation((IndexHits<Relationship>)index.query(key, (Object)queryCtx), order);
    }

    public Representation getAutoIndexedRelationships(String key, String value) {
        ReadableRelationshipIndex index = this.graphDb.index().getRelationshipAutoIndexer().getAutoIndex();
        return this.toListRelationshipRepresentation((IndexHits<Relationship>)index.get(key, (Object)value), null);
    }

    public ListRepresentation getAutoIndexedRelationshipsByQuery(String query) {
        ReadableRelationshipIndex index = this.graphDb.index().getRelationshipAutoIndexer().getAutoIndex();
        IndexHits results = query != null ? index.query((Object)query) : null;
        return this.toListRelationshipRepresentation((IndexHits<Relationship>)results, null);
    }

    public ListRepresentation traverse(long startNode, Map<String, Object> description, TraverserReturnType returnType) {
        Node node = this.graphDb.getNodeById(startNode);
        TraversalDescription traversalDescription = this.traversalDescriptionBuilder.from(description);
        Traverser paths = traversalDescription.traverse(node);
        return this.toListPathRepresentation((Iterable<Path>)paths, returnType);
    }

    private ListRepresentation toListPathRepresentation(Iterable<Path> paths, final TraverserReturnType returnType) {
        IterableWrapper<Representation, Path> result = new IterableWrapper<Representation, Path>(paths){

            protected Representation underlyingObjectToObject(Path position) {
                return returnType.toRepresentation(position);
            }
        };
        return new ListRepresentation(returnType.repType, (Iterable)result);
    }

    public ListRepresentation pagedTraverse(String traverserId, TraverserReturnType returnType) {
        Lease lease = this.leases.getLeaseById(traverserId);
        if (lease == null) {
            throw new NotFoundException(String.format("The traverser with id [%s] was not found", traverserId));
        }
        PagedTraverser traverser = lease.getLeasedItemAndRenewLease();
        Object paths = traverser.next();
        if (paths != null) {
            return this.toListPathRepresentation((Iterable<Path>)paths, returnType);
        }
        this.leases.remove(traverserId);
        throw new NotFoundException(String.format("The results for paged traverser with id [%s] have been fully enumerated", traverserId));
    }

    public String createPagedTraverser(long nodeId, Map<String, Object> description, int pageSize, int leaseTime) {
        Node node = this.graphDb.getNodeById(nodeId);
        TraversalDescription traversalDescription = this.traversalDescriptionBuilder.from(description);
        PagedTraverser traverser = new PagedTraverser(traversalDescription.traverse(node), pageSize);
        return this.leases.createLease(leaseTime, traverser).getId();
    }

    public boolean removePagedTraverse(String traverserId) {
        Lease lease = this.leases.getLeaseById(traverserId);
        if (lease == null) {
            return false;
        }
        this.leases.remove(lease.getId());
        return true;
    }

    public PathRepresentation findSinglePath(long startId, long endId, Map<String, Object> map) {
        Node endNode;
        Node startNode;
        FindParams findParams = new FindParams(startId, endId, map).invoke();
        PathFinder<? extends Path> finder = findParams.getFinder();
        Path path = finder.findSinglePath(startNode = findParams.getStartNode(), endNode = findParams.getEndNode());
        if (path == null) {
            throw new NotFoundException();
        }
        return findParams.pathRepresentationOf(path);
    }

    public ListRepresentation findPaths(long startId, long endId, Map<String, Object> map) {
        final FindParams findParams = new FindParams(startId, endId, map).invoke();
        PathFinder<? extends Path> finder = findParams.getFinder();
        Node startNode = findParams.getStartNode();
        Node endNode = findParams.getEndNode();
        Iterable paths = finder.findAllPaths(startNode, endNode);
        IterableWrapper<PathRepresentation, Path> pathRepresentations = new IterableWrapper<PathRepresentation, Path>(paths){

            protected PathRepresentation underlyingObjectToObject(Path path) {
                return findParams.pathRepresentationOf(path);
            }
        };
        return new ListRepresentation(RepresentationType.PATH, (Iterable)pathRepresentations);
    }

    private final IndexResultOrder getOrdering(String order) {
        if (INDEX_ORDER.equalsIgnoreCase(order)) {
            return IndexResultOrder.INDEX_ORDER;
        }
        if (RELEVANCE_ORDER.equalsIgnoreCase(order)) {
            return IndexResultOrder.RELEVANCE_ORDER;
        }
        if (SCORE_ORDER.equalsIgnoreCase(order)) {
            return IndexResultOrder.SCORE_ORDER;
        }
        return IndexResultOrder.NONE;
    }

    private void assertIsLegalIndexName(String indexName) {
        if (indexName == null || indexName.equals("")) {
            throw new IllegalArgumentException("Index name must not be empty.");
        }
    }

    public ListRepresentation getNodesWithLabel(String labelName, Map<String, Object> properties) {
        ResourceIterable nodes = null;
        if (properties.size() == 0) {
            nodes = GlobalGraphOperations.at((GraphDatabaseService)this.graphDb).getAllNodesWithLabel(DynamicLabel.label((String)labelName));
        } else if (properties.size() == 1) {
            Map.Entry prop = (Map.Entry)Iterables.single(properties.entrySet());
            nodes = this.graphDb.findNodesByLabelAndProperty(DynamicLabel.label((String)labelName), (String)prop.getKey(), prop.getValue());
        } else {
            throw new IllegalArgumentException("Too many properties specified. Either specify one property to filter by, or none at all.");
        }
        IterableWrapper<NodeRepresentation, Node> nodeRepresentations = new IterableWrapper<NodeRepresentation, Node>((Iterable)nodes){

            protected NodeRepresentation underlyingObjectToObject(Node node) {
                return new NodeRepresentation(node);
            }
        };
        return new ListRepresentation(RepresentationType.NODE, (Iterable)nodeRepresentations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexDefinitionRepresentation createSchemaIndex(String labelName, Iterable<String> propertyKey) {
        Transaction tx = this.graphDb.beginTx();
        try {
            IndexCreator indexCreator = this.graphDb.schema().indexCreator(DynamicLabel.label((String)labelName));
            for (String key : propertyKey) {
                indexCreator = indexCreator.on(key);
            }
            IndexDefinitionRepresentation result = new IndexDefinitionRepresentation(indexCreator.create());
            tx.success();
            IndexDefinitionRepresentation indexDefinitionRepresentation = result;
            return indexDefinitionRepresentation;
        }
        finally {
            tx.finish();
        }
    }

    public ListRepresentation getSchemaIndexes(String labelName) {
        ResourceIterable definitions = this.graphDb.schema().getIndexes(DynamicLabel.label((String)labelName));
        Iterable representations = Iterables.map((Function)new Function<IndexDefinition, IndexDefinitionRepresentation>(){

            public IndexDefinitionRepresentation apply(IndexDefinition definition) {
                return new IndexDefinitionRepresentation(definition);
            }
        }, (Iterable)definitions);
        return new ListRepresentation(RepresentationType.INDEX_DEFINITION, representations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropSchemaIndex(String labelName, String propertyKey) {
        Transaction tx = this.graphDb.beginTx();
        try {
            boolean found = false;
            for (IndexDefinition index : this.graphDb.schema().getIndexes(DynamicLabel.label((String)labelName))) {
                if (!propertyKey.equals(IteratorUtil.single((Iterable)index.getPropertyKeys()))) continue;
                index.drop();
                found = true;
                break;
            }
            tx.success();
            boolean bl = found;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    static /* synthetic */ PathRepresentationCreator access$200() {
        return PATH_REPRESENTATION_CREATOR;
    }

    private static interface PathRepresentationCreator<T extends Path> {
        public PathRepresentation<T> from(T var1);
    }

    private static enum IndexResultOrder {
        INDEX_ORDER{

            @Override
            QueryContext updateQueryContext(QueryContext original) {
                return original.sort(Sort.INDEXORDER);
            }
        }
        ,
        RELEVANCE_ORDER{

            @Override
            QueryContext updateQueryContext(QueryContext original) {
                return original.sort(Sort.RELEVANCE);
            }
        }
        ,
        SCORE_ORDER{

            @Override
            QueryContext updateQueryContext(QueryContext original) {
                return original.sortByScore();
            }
        }
        ,
        NONE{

            @Override
            Representation getRepresentationFor(Representation delegate, float score) {
                return delegate;
            }

            @Override
            QueryContext updateQueryContext(QueryContext original) {
                return original;
            }
        };


        Representation getRepresentationFor(Representation delegate, float score) {
            if (delegate instanceof NodeRepresentation) {
                return new ScoredNodeRepresentation((NodeRepresentation)delegate, score);
            }
            if (delegate instanceof RelationshipRepresentation) {
                return new ScoredRelationshipRepresentation((RelationshipRepresentation)delegate, score);
            }
            return delegate;
        }

        abstract QueryContext updateQueryContext(QueryContext var1);
    }

    private class FindParams {
        private final long startId;
        private final long endId;
        private final Map<String, Object> map;
        private Node startNode;
        private Node endNode;
        private PathFinder<? extends Path> finder;
        private PathRepresentationCreator representationCreator = DatabaseActions.access$200();

        public FindParams(long startId, long endId, Map<String, Object> map) {
            this.startId = startId;
            this.endId = endId;
            this.map = map;
        }

        public Node getStartNode() {
            return this.startNode;
        }

        public Node getEndNode() {
            return this.endNode;
        }

        public PathFinder<? extends Path> getFinder() {
            return this.finder;
        }

        public PathRepresentation<? extends Path> pathRepresentationOf(Path path) {
            return this.representationCreator.from(path);
        }

        public FindParams invoke() {
            this.startNode = DatabaseActions.this.graphDb.getNodeById(this.startId);
            this.endNode = DatabaseActions.this.graphDb.getNodeById(this.endId);
            Integer maxDepthObj = (Integer)this.map.get("max_depth");
            int maxDepth = maxDepthObj != null ? maxDepthObj : 1;
            RelationshipExpander expander = RelationshipExpanderBuilder.describeRelationships(this.map);
            String algorithm = (String)this.map.get("algorithm");
            algorithm = algorithm != null ? algorithm : "shortestPath";
            this.finder = this.getAlgorithm(algorithm, expander, maxDepth);
            return this;
        }

        private PathFinder<? extends Path> getAlgorithm(String algorithm, RelationshipExpander expander, int maxDepth) {
            if (algorithm.equals("shortestPath")) {
                return GraphAlgoFactory.shortestPath((RelationshipExpander)expander, (int)maxDepth);
            }
            if (algorithm.equals("allSimplePaths")) {
                return GraphAlgoFactory.allSimplePaths((RelationshipExpander)expander, (int)maxDepth);
            }
            if (algorithm.equals("allPaths")) {
                return GraphAlgoFactory.allPaths((RelationshipExpander)expander, (int)maxDepth);
            }
            if (algorithm.equals("dijkstra")) {
                String costProperty = (String)this.map.get("cost_property");
                Number defaultCost = (Number)this.map.get("default_cost");
                CostEvaluator costEvaluator = defaultCost == null ? CommonEvaluators.doubleCostEvaluator((String)costProperty) : CommonEvaluators.doubleCostEvaluator((String)costProperty, (double)defaultCost.doubleValue());
                this.representationCreator = WEIGHTED_PATH_REPRESENTATION_CREATOR;
                return GraphAlgoFactory.dijkstra((RelationshipExpander)expander, (CostEvaluator)costEvaluator);
            }
            throw new RuntimeException("Failed to find matching algorithm");
        }
    }

    private class UniqueNodeFactory
    extends UniqueFactory.UniqueNodeFactory {
        private final Map<String, Object> properties;
        boolean created;

        UniqueNodeFactory(String index, Map<String, Object> properties) {
            super((GraphDatabaseService)DatabaseActions.this.graphDb, index);
            this.properties = properties;
        }

        protected void initialize(Node node, Map<String, Object> indexed) {
            for (Map.Entry<String, Object> property : (this.properties == null ? indexed : this.properties).entrySet()) {
                node.setProperty(property.getKey(), property.getValue());
            }
            this.created = true;
        }
    }

    private class UniqueRelationshipFactory
    extends UniqueFactory.UniqueRelationshipFactory {
        private final Node start;
        private final Node end;
        private final RelationshipType type;
        private final Map<String, Object> properties;
        boolean created;

        UniqueRelationshipFactory(String index, Node start, Node end, String type, Map<String, Object> properties) {
            super((GraphDatabaseService)DatabaseActions.this.graphDb, index);
            this.start = start;
            this.end = end;
            this.type = DynamicRelationshipType.withName((String)type);
            this.properties = properties;
        }

        protected Relationship create(Map<String, Object> ignored) {
            return this.start.createRelationshipTo(this.end, this.type);
        }

        protected void initialize(Relationship relationship, Map<String, Object> indexed) {
            for (Map.Entry<String, Object> property : (this.properties == null ? indexed : this.properties).entrySet()) {
                relationship.setProperty(property.getKey(), property.getValue());
            }
            this.created = true;
        }
    }

    public static enum IndexType {
        node("index"){}
        ,
        relationship("index"){};

        private final String pathPrefix;

        private IndexType(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        String path(String indexName, String key, String value, long id) {
            return String.format("%s/%s/%s/%s/%s", this.pathPrefix, indexName, key, value, id);
        }
    }

    public static enum RelationshipDirection {
        all(Direction.BOTH),
        in(Direction.INCOMING),
        out(Direction.OUTGOING);

        final Direction internal;

        private RelationshipDirection(Direction internal) {
            this.internal = internal;
        }
    }

    public static class Provider
    extends InjectableProvider<DatabaseActions> {
        private final DatabaseActions database;

        public Provider(DatabaseActions database) {
            super(DatabaseActions.class);
            this.database = database;
        }

        public DatabaseActions getValue(HttpContext c) {
            return this.database;
        }
    }
}

