/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.mortbay.log.Log;
import org.neo4j.server.rest.batch.BatchOperations;
import org.neo4j.server.rest.batch.StreamingBatchOperationResults;
import org.neo4j.server.rest.domain.BatchOperationFailedException;
import org.neo4j.server.rest.web.InternalJettyServletRequest;
import org.neo4j.server.rest.web.InternalJettyServletResponse;
import org.neo4j.server.rest.web.OperationFailureException;
import org.neo4j.server.web.WebServer;

public class StreamingBatchOperations
extends BatchOperations {
    private StreamingBatchOperationResults results;

    public StreamingBatchOperations(WebServer webServer) {
        super(webServer);
    }

    public void readAndExecuteOperations(UriInfo uriInfo, HttpHeaders httpHeaders, InputStream body, ServletOutputStream output) throws IOException, ServletException {
        this.results = new StreamingBatchOperationResults(jsonFactory.createJsonGenerator((OutputStream)output), output);
        Map<Integer, String> locations = this.results.getLocations();
        this.parseAndPerform(uriInfo, httpHeaders, body, locations);
        this.results.close();
    }

    @Override
    protected void invoke(String method, String path, String body, Integer id, URI targetUri, InternalJettyServletRequest req, InternalJettyServletResponse res) throws IOException, ServletException {
        this.results.startOperation(path, id);
        try {
            res = new BatchInternalJettyServletResponse(this.results.getServletOutputStream());
            this.webServer.invokeDirectly(targetUri.getPath(), (HttpServletRequest)req, (HttpServletResponse)res);
        }
        catch (Exception e) {
            Log.warn((Throwable)e);
            this.results.writeError(500, e.getMessage());
            throw new BatchOperationFailedException(500, e.getMessage(), e);
        }
        int status = res.getStatus();
        if (!this.is2XXStatusCode(status)) {
            String message = "Error " + status + " executing batch operation: " + (id != null ? id + ". " : "") + method + " " + path + " " + body;
            this.results.writeError(status, res.getReason());
            throw new BatchOperationFailedException(status, message, new OperationFailureException(res.getReason()));
        }
        this.results.addOperationResult(status, id, res.getHeader("Location"));
    }

    @Override
    protected void addHeaders(InternalJettyServletRequest res, HttpHeaders httpHeaders) {
        super.addHeaders(res, httpHeaders);
        res.addHeader("X-Stream", "true");
    }

    private static class BatchInternalJettyServletResponse
    extends InternalJettyServletResponse {
        private final ServletOutputStream output;

        public BatchInternalJettyServletResponse(ServletOutputStream output) {
            this.output = output;
        }

        @Override
        public ServletOutputStream getOutputStream() throws IOException {
            return this.output;
        }

        @Override
        public PrintWriter getWriter() throws IOException {
            return new PrintWriter((OutputStream)this.output);
        }
    }
}

