/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.TestData;

public class CypherDocIT
extends AbstractRestFunctionalTestBase {
    @Test
    @Documented(value=" A simple query returning all nodes connected to node 1, returning the\n node and the name property, if it exists, otherwise `null`:\n")
    @TestData.Title(value="Send a Query")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true), @GraphDescription.NODE(name="you", setNameProperty=true), @GraphDescription.NODE(name="him", setNameProperty=true, properties={@GraphDescription.PROP(key="age", value="25", type=GraphDescription.PropType.INTEGER)})}, relationships={@GraphDescription.REL(start="I", end="him", type="know", properties={}), @GraphDescription.REL(start="I", end="you", type="know", properties={})})
    public void testPropertyColumn() throws UnsupportedEncodingException {
        String script = this.createScript("start x  = node(%I%) match x -[r]-> n return type(r), n.name?, n.age?");
        String response = this.cypherRestCall(script, Response.Status.OK, new Pair[0]);
        Assert.assertThat((Object)response, (Matcher)JUnitMatchers.containsString((String)"you"));
        Assert.assertThat((Object)response, (Matcher)JUnitMatchers.containsString((String)"him"));
        Assert.assertThat((Object)response, (Matcher)JUnitMatchers.containsString((String)"25"));
        Assert.assertThat((Object)response, (Matcher)IsNot.not((Matcher)JUnitMatchers.containsString((String)"\"x\"")));
    }

    @Test
    @Documented(value=" By passing in an additional GET header when you execute cypher queries, meta data about the query will\n be returned, such as how many labels were added or removed by the query.\n")
    @TestData.Title(value="Retrieve query meta data")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", labels={@GraphDescription.LABEL(value="bar")})})
    public void testQueryStatistics() throws JsonParseException {
        String script = this.createScript("start n = node(%I%) set n:foo remove n:bar return labels(n)");
        Map output = JsonHelper.jsonToMap((String)this.doCypherRestCall(this.cypherUri() + "?includeStats=true", script, Response.Status.OK, new Pair[0]));
        Map stats = (Map)output.get("stats");
        Assert.assertThat((Object)stats, (Matcher)Is.is(Map.class));
        Assert.assertThat((Object)((Boolean)stats.get("contains_updates")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((Integer)stats.get("labels_added")), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((Integer)stats.get("labels_removed")), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((Integer)stats.get("nodes_created")), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)((Integer)stats.get("nodes_deleted")), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)((Integer)stats.get("properties_set")), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)((Integer)stats.get("relationships_created")), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)((Integer)stats.get("relationship_deleted")), (Matcher)Is.is((Object)0));
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true), @GraphDescription.NODE(name="you", setNameProperty=true), @GraphDescription.NODE(name="him", setNameProperty=true, properties={@GraphDescription.PROP(key="age", value="25", type=GraphDescription.PropType.INTEGER)})}, relationships={@GraphDescription.REL(start="I", end="him", type="know", properties={}), @GraphDescription.REL(start="I", end="you", type="know", properties={})})
    public void testDataColumnOrder() throws UnsupportedEncodingException {
        String script = this.createScript("start x  = node(%I%) match x -[r]-> n return type(r), n.name?, n.age?");
        String response = this.cypherRestCall(script, Response.Status.OK, new Pair[0]);
        Assert.assertThat((Object)(response.indexOf("columns") < response.indexOf("data") ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Documented(value=" Errors on the server will be reported as a JSON-formatted stacktrace and\n message.\n")
    @TestData.Title(value="Server errors")
    @GraphDescription.Graph(value={"I know you"})
    public void error_gets_returned_as_json() throws Exception {
        String response = this.cypherRestCall("start x = node(%I%) return x.dummy", Response.Status.BAD_REQUEST, new Pair[0]);
        Map output = JsonHelper.jsonToMap((String)response);
        Assert.assertTrue((boolean)output.containsKey("message"));
        Assert.assertTrue((boolean)output.containsKey("stacktrace"));
    }

    @Test
    @Documented(value=" Paths can be returned\n together with other return types by just\n specifying returns.\n")
    @GraphDescription.Graph(value={"I know you"})
    public void return_paths() throws Exception {
        String script = "start x  = node(%I%) match path = (x--friend) return path, friend.name";
        String response = this.cypherRestCall(script, Response.Status.OK, new Pair[0]);
        Assert.assertEquals((long)2L, (long)JsonHelper.jsonToMap((String)response).size());
        Assert.assertThat((Object)response, (Matcher)JUnitMatchers.containsString((String)"data"));
        Assert.assertThat((Object)response, (Matcher)JUnitMatchers.containsString((String)"you"));
    }

    @Test
    @Documented(value=" Cypher supports queries with parameters\n which are submitted as a JSON map.\n")
    @GraphDescription.Graph(value={"I know you"}, autoIndexNodes=true)
    public void send_queries_with_parameters() throws Exception {
        this.data.get();
        String script = "start x  = node:node_auto_index(name={startName}) match path = (x-[r]-friend) where friend.name = {name} return TYPE(r)";
        String response = this.cypherRestCall(script, Response.Status.OK, Pair.of((Object)"startName", (Object)"I"), Pair.of((Object)"name", (Object)"you"));
        Assert.assertEquals((long)2L, (long)JsonHelper.jsonToMap((String)response).size());
        Assert.assertTrue((boolean)response.contains("know"));
        Assert.assertTrue((boolean)response.contains("data"));
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", properties={@GraphDescription.PROP(key="prop", value="Hello", type=GraphDescription.PropType.STRING)}), @GraphDescription.NODE(name="you")}, relationships={@GraphDescription.REL(start="I", end="him", type="know", properties={@GraphDescription.PROP(key="prop", value="World", type=GraphDescription.PropType.STRING)})})
    public void nodes_are_represented_as_nodes() throws Exception {
        this.data.get();
        String script = "start n = node(%I%) match n-[r]->() return n, r";
        String response = this.cypherRestCall(script, Response.Status.OK, new Pair[0]);
        Assert.assertThat((Object)response, (Matcher)JUnitMatchers.containsString((String)"Hello"));
        Assert.assertThat((Object)response, (Matcher)JUnitMatchers.containsString((String)"World"));
    }

    @Test
    @Documented(value=" Sending a query with syntax errors will give a bad request (HTTP 400)\n response together with an error message.\n")
    @TestData.Title(value="Send queries with syntax errors")
    @GraphDescription.Graph(value={"I know you"}, autoIndexNodes=true)
    public void send_queries_with_syntax_errors() throws Exception {
        this.data.get();
        String script = "start x  = node:node_auto_index(name={startName}) matc path = (x-[r]-friend) where friend.name = {name} return TYPE(r)";
        String response = this.cypherRestCall(script, Response.Status.BAD_REQUEST, Pair.of((Object)"startName", (Object)"I"), Pair.of((Object)"name", (Object)"you"));
        Map output = JsonHelper.jsonToMap((String)response);
        Assert.assertTrue((boolean)output.containsKey("message"));
        Assert.assertTrue((boolean)output.containsKey("stacktrace"));
    }

    @Test
    @Documented(value=" When sending queries that\n return nested results like list and maps,\n these will get serialized into nested JSON representations\n according to their types.\n")
    @GraphDescription.Graph(value={"I know you"}, autoIndexNodes=true)
    public void nested_results() throws Exception {
        this.data.get();
        String script = "start n = node(%I%,%you%) return collect(n.name)";
        String response = this.cypherRestCall(script, Response.Status.OK, new Pair[0]);
        Map resultMap = JsonHelper.jsonToMap((String)response);
        Assert.assertEquals((long)2L, (long)resultMap.size());
        Assert.assertThat((Object)response, (Matcher)Matchers.anyOf((Matcher)JUnitMatchers.containsString((String)"\"I\", \"you\""), (Matcher)JUnitMatchers.containsString((String)"\"I\",\"you\"")));
    }

    @Test
    @Documented(value=" By passing in an extra parameter, you can ask the cypher executor to return a profile of the query\n as it is executed. This can help in locating bottlenecks.\n")
    @TestData.Title(value="Profile a query")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true), @GraphDescription.NODE(name="you", setNameProperty=true), @GraphDescription.NODE(name="him", setNameProperty=true, properties={@GraphDescription.PROP(key="age", value="25", type=GraphDescription.PropType.INTEGER)})}, relationships={@GraphDescription.REL(start="I", end="him", type="know", properties={}), @GraphDescription.REL(start="I", end="you", type="know", properties={})})
    public void testProfiling() throws Exception {
        String script = this.createScript("start x  = node(%I%) match x -[r]-> n return type(r), n.name?, n.age?");
        String response = this.doCypherRestCall(this.cypherUri() + "?profile=true", script, Response.Status.OK, new Pair[0]);
        Map des = JsonHelper.jsonToMap((String)response);
        Assert.assertThat(des.get("plan"), (Matcher)IsInstanceOf.instanceOf(Map.class));
        Map plan = (Map)des.get("plan");
        Assert.assertThat(plan.get("name"), (Matcher)IsInstanceOf.instanceOf(String.class));
        Assert.assertThat(plan.get("children"), (Matcher)IsInstanceOf.instanceOf(Collection.class));
        Assert.assertThat(plan.get("rows"), (Matcher)IsInstanceOf.instanceOf(Number.class));
        Assert.assertThat(plan.get("dbHits"), (Matcher)IsInstanceOf.instanceOf(Number.class));
    }

    @Test
    @GraphDescription.Graph(value={"I know you"}, autoIndexNodes=false)
    public void array_property() throws Exception {
        this.setProperty("I", "array1", new int[]{1, 2, 3});
        this.setProperty("I", "array2", new String[]{"a", "b", "c"});
        String script = "start n = node(%I%) return n.array1, n.array2";
        String response = this.cypherRestCall(script, Response.Status.OK, new Pair[0]);
        Assert.assertThat((Object)response, (Matcher)Matchers.anyOf((Matcher)JUnitMatchers.containsString((String)"[ 1, 2, 3 ]"), (Matcher)JUnitMatchers.containsString((String)"[1,2,3]")));
        Assert.assertThat((Object)response, (Matcher)Matchers.anyOf((Matcher)JUnitMatchers.containsString((String)"[ \"a\", \"b\", \"c\" ]"), (Matcher)JUnitMatchers.containsString((String)"[\"a\",\"b\",\"c\"]")));
    }

    void setProperty(String nodeName, String propertyName, Object propertyValue) {
        Node i = this.getNode(nodeName);
        GraphDatabaseService db = i.getGraphDatabase();
        Transaction tx = db.beginTx();
        i.setProperty(propertyName, propertyValue);
        tx.success();
        tx.finish();
    }

    @Test
    @Documented(value=" This example shows what happens if you misspell\n an identifier.\n")
    @TestData.Title(value="Send queries with errors")
    @GraphDescription.Graph(value={"I know you"}, autoIndexNodes=true)
    public void send_queries_with_errors() throws Exception {
        this.data.get();
        String script = "start x  = node:node_auto_index(name={startName}) match path = (x-[r]-friend) where frien.name = {name} return TYPE(r)";
        String response = this.cypherRestCall(script, Response.Status.BAD_REQUEST, Pair.of((Object)"startName", (Object)"I"), Pair.of((Object)"name", (Object)"you"));
        Map responseMap = JsonHelper.jsonToMap((String)response);
        Assert.assertEquals((long)4L, (long)responseMap.size());
        Assert.assertThat((Object)response, (Matcher)JUnitMatchers.containsString((String)"message"));
        Assert.assertThat((Object)((String)responseMap.get("message")), (Matcher)JUnitMatchers.containsString((String)"Unknown identifier"));
        Assert.assertThat((Object)((String)responseMap.get("message")), (Matcher)JUnitMatchers.containsString((String)"frien"));
    }

    private String cypherRestCall(String script, Response.Status status, Pair<String, String> ... params) {
        return this.doCypherRestCall(this.cypherUri(), script, status, params);
    }

    private String cypherUri() {
        return this.getDataUri() + "cypher";
    }
}

