/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.stubbing.Answer;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.impl.util.TestLogger;
import org.neo4j.server.rest.transactional.ExecutionResultSerializer;
import org.neo4j.server.rest.transactional.error.Neo4jError;
import org.neo4j.server.rest.transactional.error.StatusCode;

public class ExecutionResultSerializerTest {
    @Test
    public void shouldSerializeResponseWithCommitUriOnly() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, StringLogger.DEV_NULL);
        serializer.transactionCommitUri(URI.create("commit/uri/1"));
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"commit\":\"commit/uri/1\",\"results\":[],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithCommitUriAndResults() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, StringLogger.DEV_NULL);
        ExecutionResult executionResult = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"column1", "value1", "column2", "value2"}));
        serializer.transactionCommitUri(URI.create("commit/uri/1"));
        serializer.statementResult(executionResult);
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"commit\":\"commit/uri/1\",\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[[\"value1\",\"value2\"]]}],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithResultsOnly() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, StringLogger.DEV_NULL);
        ExecutionResult executionResult = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"column1", "value1", "column2", "value2"}));
        serializer.statementResult(executionResult);
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[[\"value1\",\"value2\"]]}],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithCommitUriAndResultsAndErrors() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, StringLogger.DEV_NULL);
        ExecutionResult executionResult = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"column1", "value1", "column2", "value2"}));
        serializer.transactionCommitUri(URI.create("commit/uri/1"));
        serializer.statementResult(executionResult);
        serializer.errors(Arrays.asList(new Neo4jError(StatusCode.INVALID_REQUEST_FORMAT, "error1")));
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"commit\":\"commit/uri/1\",\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[[\"value1\",\"value2\"]]}],\"errors\":[{\"code\":40001,\"status\":\"INVALID_REQUEST_FORMAT\",\"message\":\"Unable to deserialize request due to invalid request format. Details: error1\"}]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithResultsAndErrors() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, StringLogger.DEV_NULL);
        ExecutionResult executionResult = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"column1", "value1", "column2", "value2"}));
        serializer.statementResult(executionResult);
        serializer.errors(Arrays.asList(new Neo4jError(StatusCode.INVALID_REQUEST_FORMAT, "error1")));
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[[\"value1\",\"value2\"]]}],\"errors\":[{\"code\":40001,\"status\":\"INVALID_REQUEST_FORMAT\",\"message\":\"Unable to deserialize request due to invalid request format. Details: error1\"}]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithCommitUriAndErrors() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, StringLogger.DEV_NULL);
        serializer.transactionCommitUri(URI.create("commit/uri/1"));
        serializer.errors(Arrays.asList(new Neo4jError(StatusCode.INVALID_REQUEST_FORMAT, "error1")));
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"commit\":\"commit/uri/1\",\"results\":[],\"errors\":[{\"code\":40001,\"status\":\"INVALID_REQUEST_FORMAT\",\"message\":\"Unable to deserialize request due to invalid request format. Details: error1\"}]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithErrorsOnly() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, StringLogger.DEV_NULL);
        serializer.errors(Arrays.asList(new Neo4jError(StatusCode.INVALID_REQUEST_FORMAT, "error1")));
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[],\"errors\":[{\"code\":40001,\"status\":\"INVALID_REQUEST_FORMAT\",\"message\":\"Unable to deserialize request due to invalid request format. Details: error1\"}]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithNoCommitUriResultsOrErrors() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, StringLogger.DEV_NULL);
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithMultipleResultRows() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, StringLogger.DEV_NULL);
        ExecutionResult executionResult = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"column1", "value1", "column2", "value2"}), MapUtil.map((Object[])new Object[]{"column1", "value3", "column2", "value4"}));
        serializer.statementResult(executionResult);
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[[\"value1\",\"value2\"],[\"value3\",\"value4\"]]}],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldSerializeResponseWithMultipleResults() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, StringLogger.DEV_NULL);
        ExecutionResult executionResult1 = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"column1", "value1", "column2", "value2"}));
        ExecutionResult executionResult2 = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"column3", "value3", "column4", "value4"}));
        serializer.statementResult(executionResult1);
        serializer.statementResult(executionResult2);
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[[\"value1\",\"value2\"]]},{\"columns\":[\"column3\",\"column4\"],\"data\":[[\"value3\",\"value4\"]]}],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldSerializeNodeAsMapOfProperties() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, StringLogger.DEV_NULL);
        ExecutionResult executionResult = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"node", ExecutionResultSerializerTest.mockNode(MapUtil.map((Object[])new Object[]{"a", 12, "b", true, "c", new int[]{1, 0, 1, 2}, "d", new byte[]{1, 0, 1, 2}, "e", new String[]{"a", "b", "\u00e4\u00e4\u00f6"}}))}));
        serializer.statementResult(executionResult);
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"node\"],\"data\":[[{\"d\":[1,0,1,2],\"e\":[\"a\",\"b\",\"\u00e4\u00e4\u00f6\"],\"b\":true,\"c\":[1,0,1,2],\"a\":12}]]}],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldSerializePathAsListOfMapsOfProperties() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, StringLogger.DEV_NULL);
        ExecutionResult executionResult = ExecutionResultSerializerTest.mockExecutionResult(MapUtil.map((Object[])new Object[]{"path", ExecutionResultSerializerTest.mockPath(MapUtil.map((Object[])new Object[]{"key1", "value1"}), MapUtil.map((Object[])new Object[]{"key2", "value2"}), MapUtil.map((Object[])new Object[]{"key3", "value3"}))}));
        serializer.statementResult(executionResult);
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"path\"],\"data\":[[[{\"key1\":\"value1\"},{\"key2\":\"value2\"},{\"key3\":\"value3\"}]]]}],\"errors\":[]}", (Object)result);
    }

    @Test
    public void shouldProduceWellFormedJsonEvenIfResultIteratorThrowsExceptionOnNext() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, StringLogger.DEV_NULL);
        Map data = MapUtil.map((Object[])new Object[]{"column1", "value1", "column2", "value2"});
        ExecutionResult executionResult = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)executionResult.columns()).thenReturn(new ArrayList(data.keySet()));
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(iterator.next()).thenReturn((Object)data).thenThrow(new Throwable[]{new RuntimeException("Stuff went wrong!")});
        Mockito.when((Object)executionResult.iterator()).thenReturn((Object)iterator);
        try {
            serializer.statementResult(executionResult);
            Assert.fail((String)"should have thrown exception");
        }
        catch (RuntimeException e) {
            serializer.errors(Arrays.asList(new Neo4jError(StatusCode.INTERNAL_STATEMENT_EXECUTION_ERROR, (Throwable)e)));
        }
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[[\"value1\",\"value2\"]]}],\"errors\":[{\"code\":50001,\"status\":\"INTERNAL_STATEMENT_EXECUTION_ERROR\",\"message\":\"Internal error when executing statement. Cause: Stuff went wrong!\",\"stackTrace\":***}]}", (Object)this.replaceStackTrace(result, "***"));
    }

    @Test
    public void shouldProduceWellFormedJsonEvenIfResultIteratorThrowsExceptionOnHasNext() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer((OutputStream)output, StringLogger.DEV_NULL);
        Map data = MapUtil.map((Object[])new Object[]{"column1", "value1", "column2", "value2"});
        ExecutionResult executionResult = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)executionResult.columns()).thenReturn(new ArrayList(data.keySet()));
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true).thenThrow(new Throwable[]{new RuntimeException("Stuff went wrong!")});
        Mockito.when(iterator.next()).thenReturn((Object)data);
        Mockito.when((Object)executionResult.iterator()).thenReturn((Object)iterator);
        try {
            serializer.statementResult(executionResult);
            Assert.fail((String)"should have thrown exception");
        }
        catch (RuntimeException e) {
            serializer.errors(Arrays.asList(new Neo4jError(StatusCode.INTERNAL_STATEMENT_EXECUTION_ERROR, (Throwable)e)));
        }
        serializer.finish();
        String result = output.toString("UTF-8");
        Assert.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[[\"value1\",\"value2\"]]}],\"errors\":[{\"code\":50001,\"status\":\"INTERNAL_STATEMENT_EXECUTION_ERROR\",\"message\":\"Internal error when executing statement. Cause: Stuff went wrong!\",\"stackTrace\":***}]}", (Object)this.replaceStackTrace(result, "***"));
    }

    @Test
    public void shouldLogIOErrors() throws Exception {
        IOException failure = new IOException();
        OutputStream output = (OutputStream)Mockito.mock(OutputStream.class, (Answer)new ThrowsException((Throwable)failure));
        TestLogger log = new TestLogger();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer(output, (StringLogger)log);
        serializer.finish();
        log.assertExactly(new TestLogger.LogCall[]{TestLogger.LogCall.error((String)"Failed to generate JSON output.", (Throwable)failure)});
    }

    private static ExecutionResult mockExecutionResult(Map<String, Object> ... rows) {
        HashSet<String> keys = new HashSet<String>();
        for (Map<String, Object> row : rows) {
            keys.addAll(row.keySet());
        }
        ExecutionResult executionResult = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)executionResult.columns()).thenReturn(new ArrayList(keys));
        Mockito.when((Object)executionResult.iterator()).thenReturn(Arrays.asList(rows).iterator());
        return executionResult;
    }

    private static Node mockNode(Map<String, Object> properties) {
        return ExecutionResultSerializerTest.mockPropertiesContainer(Node.class, properties);
    }

    private static <T extends PropertyContainer> T mockPropertiesContainer(Class<T> containerType, Map<String, Object> properties) {
        PropertyContainer propertyContainer = (PropertyContainer)Mockito.mock(containerType);
        Mockito.when((Object)propertyContainer.getPropertyKeys()).thenReturn(properties.keySet());
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Mockito.when((Object)propertyContainer.getProperty(entry.getKey())).thenReturn(entry.getValue());
        }
        return (T)propertyContainer;
    }

    private static Relationship mockRelationship(Map<String, Object> properties) {
        return ExecutionResultSerializerTest.mockPropertiesContainer(Relationship.class, properties);
    }

    private static Path mockPath(Map<String, Object> startNodeProperties, Map<String, Object> relationshipProperties, Map<String, Object> endNodeProperties) {
        Path p = (Path)Mockito.mock(Path.class);
        Node startNode = ExecutionResultSerializerTest.mockNode(startNodeProperties);
        Relationship relationship = ExecutionResultSerializerTest.mockRelationship(relationshipProperties);
        Node endNode = ExecutionResultSerializerTest.mockNode(endNodeProperties);
        Mockito.when((Object)p.iterator()).thenReturn((Object)IteratorUtil.iterator((Object[])new PropertyContainer[]{startNode, relationship, endNode}));
        return p;
    }

    private String replaceStackTrace(String json, String matchableStackTrace) {
        return json.replaceAll("\"stackTrace\":\"[^\"]*\"", "\"stackTrace\":" + matchableStackTrace);
    }
}

