/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.Assert;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.transactional.Statement;
import org.neo4j.server.rest.transactional.StatementDeserializer;
import org.neo4j.server.rest.transactional.error.Neo4jError;
import org.neo4j.server.rest.transactional.error.StatusCode;

public class StatementDeserializerTest {
    @Test
    public void shouldDeserializeSingleStatement() throws Exception {
        String json = JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"statements", Arrays.asList(MapUtil.map((Object[])new Object[]{"statement", "Blah blah", "parameters", MapUtil.map((Object[])new Object[]{"one", 12})}))}));
        StatementDeserializer de = new StatementDeserializer((InputStream)new ByteArrayInputStream(json.getBytes("UTF-8")));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)true));
        Statement stmt = (Statement)de.next();
        MatcherAssert.assertThat((Object)stmt.statement(), (Matcher)Matchers.equalTo((Object)"Blah blah"));
        MatcherAssert.assertThat((Object)stmt.parameters(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"one", 12})));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldRejectMapWithADifferentFieldBeforeStatement() throws Exception {
        String json = "{ \"timeout\" : 200, \"statements\" : [ { \"statement\" : \"ignored\", \"parameters\" : {}} ] }";
        this.assertYieldsErrors(json, new Neo4jError(StatusCode.INVALID_REQUEST_FORMAT, "Unable to deserialize request, expected first field to be 'statements', but was 'timeout'"));
    }

    @Test
    public void shouldTotallyIgnoreInvalidJsonAfterStatementArrayHasFinished() throws Exception {
        String json = "{ \"statements\" : [ { \"statement\" : \"Blah blah\", \"parameters\" : {\"one\" : 12}} ] totally invalid json is totally ignored";
        StatementDeserializer de = new StatementDeserializer((InputStream)new ByteArrayInputStream(json.getBytes("UTF-8")));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)true));
        Statement stmt = (Statement)de.next();
        MatcherAssert.assertThat((Object)stmt.statement(), (Matcher)Matchers.equalTo((Object)"Blah blah"));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldTreatEmptyInputStreamAsEmptyStatementList() throws Exception {
        byte[] json = new byte[]{};
        StatementDeserializer de = new StatementDeserializer((InputStream)new ByteArrayInputStream(json));
        Assert.assertFalse((boolean)de.hasNext());
        Assert.assertFalse((boolean)de.errors().hasNext());
    }

    @Test
    public void shouldDeserializeMultipleStatements() throws Exception {
        String json = JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"statements", Arrays.asList(MapUtil.map((Object[])new Object[]{"statement", "Blah blah", "parameters", MapUtil.map((Object[])new Object[]{"one", 12})}), MapUtil.map((Object[])new Object[]{"statement", "Blah bluh", "parameters", MapUtil.map((Object[])new Object[]{"asd", Arrays.asList("one, two")})}))}));
        StatementDeserializer de = new StatementDeserializer((InputStream)new ByteArrayInputStream(json.getBytes("UTF-8")));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)true));
        Statement stmt = (Statement)de.next();
        MatcherAssert.assertThat((Object)stmt.statement(), (Matcher)Matchers.equalTo((Object)"Blah blah"));
        MatcherAssert.assertThat((Object)stmt.parameters(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"one", 12})));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)true));
        Statement stmt2 = (Statement)de.next();
        MatcherAssert.assertThat((Object)stmt2.statement(), (Matcher)Matchers.equalTo((Object)"Blah bluh"));
        MatcherAssert.assertThat((Object)stmt2.parameters(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"asd", Arrays.asList("one, two")})));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldNotThrowButReportErrorOnInvalidInput() throws Exception {
        this.assertYieldsErrors("{}", new Neo4jError(StatusCode.INVALID_REQUEST_FORMAT, "Unable to deserialize request, expected [START_OBJECT, FIELD_NAME, START_ARRAY], found [START_OBJECT, END_OBJECT, null]."));
        this.assertYieldsErrors("[{]}", new Neo4jError(StatusCode.INVALID_REQUEST_FORMAT, "Unable to deserialize request: Unexpected close marker ']': expected '}' (for OBJECT starting at [Source: TestInputStream; line: 1, column: 1])\n at [Source: TestInputStream; line: 1, column: 4]"));
    }

    private void assertYieldsErrors(String json, Neo4jError ... expectedErrors) throws UnsupportedEncodingException {
        StatementDeserializer de = new StatementDeserializer((InputStream)new ByteArrayInputStream(json.getBytes("UTF-8")){

            public String toString() {
                return "TestInputStream";
            }
        });
        while (de.hasNext()) {
            de.next();
        }
        Iterator actual = de.errors();
        Iterator<Neo4jError> expected = Arrays.asList(expectedErrors).iterator();
        while (actual.hasNext()) {
            Assert.assertTrue((boolean)expected.hasNext());
            Neo4jError error = (Neo4jError)actual.next();
            Neo4jError expectedError = expected.next();
            MatcherAssert.assertThat((Object)error.getStatusCode(), (Matcher)Matchers.equalTo((Object)expectedError.getStatusCode()));
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.equalTo((Object)expectedError.getMessage()));
        }
        Assert.assertFalse((boolean)expected.hasNext());
    }
}

