/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.util.List;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.WrappedDatabase;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.web.DatabaseMetadataService;
import org.neo4j.test.ImpermanentGraphDatabase;

public class DatabaseMetadataServiceTest {
    @Test
    public void shouldAdvertiseRelationshipTyoesThatCurrentlyExistInTheDatabase() throws Throwable {
        ImpermanentGraphDatabase db = new ImpermanentGraphDatabase();
        Transaction tx = db.beginTx();
        Node node = db.createNode();
        node.createRelationshipTo(db.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"a"));
        node.createRelationshipTo(db.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"b"));
        node.createRelationshipTo(db.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"c"));
        tx.success();
        tx.finish();
        WrappedDatabase database = new WrappedDatabase((AbstractGraphDatabase)db);
        DatabaseMetadataService service = new DatabaseMetadataService((Database)database);
        Response response = service.getRelationshipTypes();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        List jsonList = JsonHelper.jsonToList((String)response.getEntity().toString());
        Assert.assertEquals((long)3L, (long)jsonList.size());
        database.stop();
    }
}

