/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.cypher.javacompat.PlanDescription;
import org.neo4j.cypher.javacompat.ProfilerStatistics;
import org.neo4j.cypher.javacompat.QueryStatistics;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.ObjectToRepresentationConverter;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationExceptionHandlingIterable;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.server.webadmin.rest.representations.JmxAttributeRepresentationDispatcher;

public class CypherResultRepresentation
extends MappingRepresentation {
    private final ListRepresentation resultRepresentation;
    private final ListRepresentation columns;
    private final MappingRepresentation statsRepresentation;
    private final MappingRepresentation plan;

    public CypherResultRepresentation(ExecutionResult result, boolean includeStats, boolean includePlan) {
        super(RepresentationType.STRING);
        this.resultRepresentation = this.createResultRepresentation(result);
        this.columns = ListRepresentation.string((Iterable)result.columns());
        this.statsRepresentation = includeStats ? this.createStatsRepresentation(result.getQueryStatistics()) : null;
        this.plan = includePlan ? this.createPlanRepresentation(this.planProvider(result)) : null;
    }

    private MappingRepresentation createStatsRepresentation(final QueryStatistics stats) {
        return new MappingRepresentation("stats"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putBoolean("contains_updates", stats.containsUpdates());
                serializer.putNumber("nodes_created", (Number)stats.getNodesCreated());
                serializer.putNumber("nodes_deleted", (Number)stats.getDeletedNodes());
                serializer.putNumber("properties_set", (Number)stats.getPropertiesSet());
                serializer.putNumber("relationships_created", (Number)stats.getRelationshipsCreated());
                serializer.putNumber("relationship_deleted", (Number)stats.getDeletedRelationships());
                serializer.putNumber("labels_added", (Number)stats.getAddedLabels());
                serializer.putNumber("labels_removed", (Number)stats.getRemovedLabels());
            }
        };
    }

    protected void serialize(MappingSerializer serializer) {
        serializer.putList("columns", this.columns);
        serializer.putList("data", this.resultRepresentation);
        if (this.statsRepresentation != null) {
            serializer.putMapping("stats", this.statsRepresentation);
        }
        if (this.plan != null) {
            serializer.putMapping("plan", this.plan);
        }
    }

    private ListRepresentation createResultRepresentation(ExecutionResult executionResult) {
        final List columns = executionResult.columns();
        RepresentationExceptionHandlingIterable inner = new RepresentationExceptionHandlingIterable(executionResult);
        return new ListRepresentation("data", (Iterable)new IterableWrapper<Representation, Map<String, Object>>(inner){

            protected Representation underlyingObjectToObject(final Map<String, Object> row) {
                return new ListRepresentation("row", (Iterable)new IterableWrapper<Representation, String>((Iterable)columns){

                    protected Representation underlyingObjectToObject(String column) {
                        return CypherResultRepresentation.this.getRepresentation(row.get(column));
                    }
                });
            }
        });
    }

    private MappingRepresentation createPlanRepresentation(final Function<Object, PlanDescription> getPlan) {
        return new MappingRepresentation("plan"){

            protected void serialize(MappingSerializer mappingSerializer) {
                PlanDescription planDescription = (PlanDescription)getPlan.apply(null);
                mappingSerializer.putString("name", planDescription.getName());
                MappingRepresentation argsRepresentation = ObjectToRepresentationConverter.getMapRepresentation(planDescription.getArguments());
                mappingSerializer.putMapping("args", argsRepresentation);
                if (planDescription.hasProfilerStatistics()) {
                    ProfilerStatistics stats = planDescription.getProfilerStatistics();
                    mappingSerializer.putNumber("rows", (Number)stats.getRows());
                    mappingSerializer.putNumber("dbHits", (Number)stats.getDbHits());
                }
                mappingSerializer.putList("children", new ListRepresentation("children", (Iterable)new IterableWrapper<Representation, PlanDescription>((Iterable)planDescription.getChildren()){

                    protected Representation underlyingObjectToObject(final PlanDescription childPlan) {
                        return CypherResultRepresentation.this.createPlanRepresentation((Function<Object, PlanDescription>)((Function)new Function<Object, PlanDescription>(){

                            public PlanDescription apply(Object from) {
                                return childPlan;
                            }
                        }));
                    }
                }));
            }
        };
    }

    private Representation getRepresentation(Object r) {
        if (r == null) {
            return ValueRepresentation.string(null);
        }
        if (r instanceof Path) {
            return new PathRepresentation<Path>((Path)r);
        }
        if (r instanceof Iterable) {
            return this.handleIterable((Iterable)r);
        }
        if (r instanceof Node) {
            return new NodeRepresentation((Node)r);
        }
        if (r instanceof Relationship) {
            return new RelationshipRepresentation((Relationship)r);
        }
        JmxAttributeRepresentationDispatcher representationDispatcher = new JmxAttributeRepresentationDispatcher();
        return (Representation)representationDispatcher.dispatch(r, "");
    }

    private Representation handleIterable(Iterable data) {
        ArrayList<Representation> results = new ArrayList<Representation>();
        for (Object value : data) {
            Representation rep = this.getRepresentation(value);
            results.add(rep);
        }
        RepresentationType representationType = this.getType(results);
        return new ListRepresentation(representationType, results);
    }

    private RepresentationType getType(List<Representation> representations) {
        if (representations == null || representations.isEmpty()) {
            return RepresentationType.STRING;
        }
        return representations.get(0).getRepresentationType();
    }

    private Function<Object, PlanDescription> planProvider(final ExecutionResult result) {
        return new Function<Object, PlanDescription>(){

            public PlanDescription apply(Object from) {
                return result.executionPlanDescription();
            }
        };
    }
}

