/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.error;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.neo4j.server.rest.transactional.error.StatusCode;

public class Neo4jError {
    private final StatusCode statusCode;
    private final String message;
    private final Throwable cause;

    public Neo4jError(StatusCode statusCode) {
        this(statusCode, null, null);
    }

    public Neo4jError(StatusCode statusCode, Throwable cause) {
        this(statusCode, null, cause);
    }

    public Neo4jError(StatusCode statusCode, String message) {
        this(statusCode, message, null);
    }

    public Neo4jError(StatusCode statusCode, String message, Throwable cause) {
        if (statusCode == null) {
            throw new IllegalArgumentException("statusCode must not be null");
        }
        this.statusCode = statusCode;
        this.cause = cause;
        this.message = this.buildMessage(statusCode, message, cause);
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean shouldSerializeStackTrace() {
        return this.statusCode.includeStackTrace();
    }

    public String getStackTraceAsString() {
        if (this.cause == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.cause.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private String buildMessage(StatusCode statusCode, String message, Throwable cause) {
        StringBuilder builder = new StringBuilder(statusCode.getDefaultMessage());
        if (message != null) {
            builder.append(" Details: ");
            builder.append(message);
            return builder.toString();
        }
        if (cause != null) {
            builder.append(" Cause: ");
            builder.append(cause.getMessage());
            return builder.toString();
        }
        return builder.toString();
    }
}

