/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.error;

public enum StatusCode {
    NETWORK_ERROR(30000, "Failed to transfer request or response.", StackTraceStrategy.SEND_TO_CLIENT),
    INVALID_REQUEST(40000, "Invalid request was not understood by the server."),
    INVALID_REQUEST_FORMAT(40001, "Unable to deserialize request due to invalid request format."),
    INVALID_TRANSACTION_ID(40010, "Unrecognized transaction id. Transaction may have timed out and been rolled back."),
    INVALID_CONCURRENT_TRANSACTION_ACCESS(40011, "The requested transaction is being used concurrently by another request."),
    STATEMENT_EXECUTION_ERROR(42000, "Error when executing statement."),
    STATEMENT_SYNTAX_ERROR(42001, "Syntax error in statement."),
    STATEMENT_MISSING_PARAMETER_ERROR(42002, "Parameter missing in statement."),
    INTERNAL_DATABASE_ERROR(50000, "Internal database error. Please refer to the attached stack trace for details.", StackTraceStrategy.SEND_TO_CLIENT),
    INTERNAL_STATEMENT_EXECUTION_ERROR(50001, "Internal error when executing statement.", StackTraceStrategy.SEND_TO_CLIENT),
    INTERNAL_BEGIN_TRANSACTION_ERROR(53010, "Unable to start transaction, and unable to determine cause of failure. ", StackTraceStrategy.SEND_TO_CLIENT),
    INTERNAL_ROLLBACK_TRANSACTION_ERROR(53011, "Unable to roll back transaction, and unable to determine cause of failure. ", StackTraceStrategy.SEND_TO_CLIENT),
    INTERNAL_COMMIT_TRANSACTION_ERROR(53012, "It was not possible to commit your transaction. ", StackTraceStrategy.SEND_TO_CLIENT);

    private final int code;
    private final String defaultMessage;
    private final StackTraceStrategy stackTraceStrategy;

    private StatusCode(int code, String defaultMessage) {
        this(code, defaultMessage, StackTraceStrategy.SWALLOW);
    }

    private StatusCode(int code, String defaultMessage, StackTraceStrategy stackTraceStrategy) {
        this.code = code;
        this.defaultMessage = defaultMessage;
        this.stackTraceStrategy = stackTraceStrategy;
    }

    public int getCode() {
        return this.code;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public boolean includeStackTrace() {
        return StackTraceStrategy.SEND_TO_CLIENT == this.stackTraceStrategy;
    }

    static enum StackTraceStrategy {
        SWALLOW,
        SEND_TO_CLIENT;

    }
}

