/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.neo4j.server.rest.transactional.ExecutionResultSerializer;
import org.neo4j.server.rest.transactional.TransactionFacade;
import org.neo4j.server.rest.transactional.TransactionHandle;
import org.neo4j.server.rest.transactional.error.Neo4jError;
import org.neo4j.server.rest.transactional.error.TransactionLifecycleException;
import org.neo4j.server.rest.web.TransactionUriScheme;

@Path(value="/transaction")
public class TransactionalService {
    private final TransactionFacade facade;
    private final TransactionUriScheme uriScheme;

    public TransactionalService(@Context TransactionFacade facade, @Context UriInfo uriInfo) {
        this.facade = facade;
        this.uriScheme = new TransactionUriBuilder(uriInfo);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response executeStatementsInNewTransaction(InputStream input) {
        TransactionHandle transactionHandle;
        try {
            transactionHandle = this.facade.newTransactionHandle(this.uriScheme);
        }
        catch (TransactionLifecycleException e) {
            return this.invalidTransaction(e);
        }
        return this.createdResponse(transactionHandle, this.executeStatements(input, transactionHandle));
    }

    @POST
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response executeStatements(@PathParam(value="id") long id, InputStream input) {
        TransactionHandle transactionHandle;
        try {
            transactionHandle = this.facade.findTransactionHandle(id);
        }
        catch (TransactionLifecycleException e) {
            return this.invalidTransaction(e);
        }
        return this.okResponse(this.executeStatements(input, transactionHandle));
    }

    @POST
    @Path(value="/{id}/commit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response commitTransaction(@PathParam(value="id") long id, InputStream input) {
        TransactionHandle transactionHandle;
        try {
            transactionHandle = this.facade.findTransactionHandle(id);
        }
        catch (TransactionLifecycleException e) {
            return this.invalidTransaction(e);
        }
        return this.okResponse(this.executeStatementsAndCommit(input, transactionHandle));
    }

    @POST
    @Path(value="/commit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response commitNewTransaction(InputStream input) {
        TransactionHandle transactionHandle;
        try {
            transactionHandle = this.facade.newTransactionHandle(this.uriScheme);
        }
        catch (TransactionLifecycleException e) {
            return this.invalidTransaction(e);
        }
        return this.okResponse(this.executeStatementsAndCommit(input, transactionHandle));
    }

    @DELETE
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    public Response rollbackTransaction(@PathParam(value="id") long id) {
        TransactionHandle transactionHandle;
        try {
            transactionHandle = this.facade.findTransactionHandle(id);
        }
        catch (TransactionLifecycleException e) {
            return this.invalidTransaction(e);
        }
        return this.okResponse(this.rollback(transactionHandle));
    }

    private Response invalidTransaction(TransactionLifecycleException e) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).header("Content-Encoding", (Object)"UTF-8").entity((Object)this.serializeError(e.toNeo4jError())).build();
    }

    private Response createdResponse(TransactionHandle transactionHandle, StreamingOutput streamingResults) {
        return Response.created((URI)transactionHandle.uri()).header("Content-Encoding", (Object)"UTF-8").entity((Object)streamingResults).build();
    }

    private Response okResponse(StreamingOutput streamingResults) {
        return Response.ok().header("Content-Encoding", (Object)"UTF-8").entity((Object)streamingResults).build();
    }

    private StreamingOutput executeStatements(final InputStream input, final TransactionHandle transactionHandle) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                transactionHandle.execute(TransactionalService.this.facade.deserializer(input), TransactionalService.this.facade.serializer(output));
            }
        };
    }

    private StreamingOutput executeStatementsAndCommit(final InputStream input, final TransactionHandle transactionHandle) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                transactionHandle.commit(TransactionalService.this.facade.deserializer(input), TransactionalService.this.facade.serializer(output));
            }
        };
    }

    private StreamingOutput rollback(final TransactionHandle transactionHandle) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                transactionHandle.rollback(TransactionalService.this.facade.serializer(output));
            }
        };
    }

    private StreamingOutput serializeError(final Neo4jError neo4jError) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                ExecutionResultSerializer serializer = TransactionalService.this.facade.serializer(output);
                serializer.errors(Arrays.asList(neo4jError));
                serializer.finish();
            }
        };
    }

    public static class TransactionUriBuilder
    implements TransactionUriScheme {
        private final UriInfo uriInfo;

        public TransactionUriBuilder(UriInfo uriInfo) {
            this.uriInfo = uriInfo;
        }

        @Override
        public URI txUri(long id) {
            return this.builder(id).build(new Object[0]);
        }

        @Override
        public URI txCommitUri(long id) {
            return this.builder(id).path("/commit").build(new Object[0]);
        }

        private UriBuilder builder(long id) {
            return this.uriInfo.getBaseUriBuilder().path(TransactionalService.class).path("/" + id);
        }
    }
}

