/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.paging;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.server.rest.paging.Clock;
import org.neo4j.server.rest.paging.FakeClock;
import org.neo4j.server.rest.paging.HexMatcher;
import org.neo4j.server.rest.paging.Lease;
import org.neo4j.server.rest.paging.LeaseAlreadyExpiredException;
import org.neo4j.server.rest.paging.PagedTraverser;

public class LeaseTest {
    private static final long SIXTY_SECONDS = 60L;
    private static final long THIRTY_SECONDS = 30L;

    @Test
    public void shouldReturnHexIdentifierString() throws Exception {
        Lease lease = new Lease((PagedTraverser)Mockito.mock(PagedTraverser.class), 60L, (Clock)new FakeClock());
        Assert.assertThat((Object)lease.getId(), HexMatcher.containsOnlyHex());
    }

    @Test(expected=LeaseAlreadyExpiredException.class)
    public void shouldNotAllowLeasesInThePast() throws Exception {
        FakeClock clock = new FakeClock();
        new Lease((PagedTraverser)Mockito.mock(PagedTraverser.class), this.oneMinuteInThePast(), (Clock)clock);
    }

    private long oneMinuteInThePast() {
        return -60L;
    }

    @Test
    public void leasesShouldExpire() throws Exception {
        FakeClock clock = new FakeClock();
        Lease lease = new Lease((PagedTraverser)Mockito.mock(PagedTraverser.class), 60L, (Clock)clock);
        clock.forwardMinutes(10);
        Assert.assertTrue((boolean)lease.expired());
    }

    @Test
    public void shouldRenewLeaseForSamePeriod() {
        FakeClock clock = new FakeClock();
        Lease lease = new Lease((PagedTraverser)Mockito.mock(PagedTraverser.class), 60L, (Clock)clock);
        clock.forwardSeconds(30L);
        lease.getLeasedItemAndRenewLease();
        clock.forwardSeconds(30L);
        Assert.assertFalse((boolean)lease.expired());
        clock.forwardMinutes(10);
        Assert.assertTrue((boolean)lease.expired());
    }
}

