/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.Version;
import org.neo4j.server.rest.repr.ExtensibleRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.RepresentationType;

public class DatabaseRepresentation
extends MappingRepresentation
implements ExtensibleRepresentation {
    private final GraphDatabaseService graphDb;

    public DatabaseRepresentation(GraphDatabaseService graphDb) {
        super(RepresentationType.GRAPHDB);
        this.graphDb = graphDb;
    }

    public String getIdentity() {
        return null;
    }

    protected void serialize(MappingSerializer serializer) {
        serializer.putUri("node", "node");
        try {
            serializer.putUri("reference_node", NodeRepresentation.path(this.graphDb.getReferenceNode()));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        serializer.putUri("node_index", "index/node");
        serializer.putUri("relationship_index", "index/relationship");
        serializer.putUri("extensions_info", "ext");
        serializer.putUri("relationship_types", "relationship/types");
        serializer.putUri("batch", "batch");
        serializer.putUri("cypher", "cypher");
        serializer.putUri("transaction", "transaction");
        serializer.putString("neo4j_version", Version.getKernelRevision());
    }
}

