/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.TransactionContext;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.transaction.TxManager;

class TransitionalTxManagementTransactionContext
implements TransactionContext {
    private final TransactionContext ctx;
    private final TxManager txManager;
    private Transaction suspendedTransaction;

    public TransitionalTxManagementTransactionContext(TransactionContext ctx, TxManager txManager) {
        this.ctx = ctx;
        this.txManager = txManager;
    }

    public StatementContext newStatementContext() {
        return this.ctx.newStatementContext();
    }

    public void prepare() {
        throw new UnsupportedOperationException();
    }

    public void commit() throws TransactionFailureException {
        this.ctx.commit();
    }

    public void rollback() throws TransactionFailureException {
        this.ctx.rollback();
    }

    public void suspendSinceTransactionsAreStillThreadBound() {
        try {
            assert (this.suspendedTransaction == null) : "Can't suspend the transaction if it already is suspended.";
            this.suspendedTransaction = this.txManager.suspend();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public void resumeSinceTransactionsAreStillThreadBound() {
        try {
            assert (this.suspendedTransaction != null) : "Can't suspend the transaction if it has not first been suspended.";
            this.txManager.resume(this.suspendedTransaction);
            this.suspendedTransaction = null;
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }
}

