/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.scripting.javascript.GlobalJavascriptInitializer;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class ServerConfigDocIT
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;

    @After
    public void stopTheServer() {
        this.server.stop();
    }

    @Test
    public void shouldPickUpPortFromConfig() throws Exception {
        int NON_DEFAULT_PORT = 4321;
        this.server = CommunityServerBuilder.server().onPort(4321).usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).build();
        this.server.start();
        Assert.assertEquals((long)4321L, (long)this.server.getWebServerPort());
        JaxRsResponse response = new RestRequest(this.server.baseUri()).get();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        response.close();
    }

    @Test
    public void shouldPickupRelativeUrisForWebAdminAndWebAdminRest() throws IOException {
        String webAdminDataUri = "/a/different/webadmin/data/uri/";
        String webAdminManagementUri = "/a/different/webadmin/management/uri/";
        this.server = CommunityServerBuilder.server().withRelativeWebDataAdminUriPath(webAdminDataUri).usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).withRelativeWebAdminUriPath(webAdminManagementUri).build();
        this.server.start();
        JaxRsResponse response = new RestRequest().get("http://localhost:7474" + webAdminDataUri, MediaType.TEXT_HTML_TYPE);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response = new RestRequest().get("http://localhost:7474" + webAdminManagementUri);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldGenerateWADLWhenExplicitlyEnabledInConfig() throws IOException {
        this.server = CommunityServerBuilder.server().withProperty("unsupported_wadl_generation_enabled", "true").usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).build();
        this.server.start();
        JaxRsResponse response = new RestRequest().get("http://localhost:7474/application.wadl", MediaType.WILDCARD_TYPE);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/vnd.sun.wadl+xml", ((List)response.getHeaders().get((Object)"Content-Type")).iterator().next());
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.containsString((String)"<application xmlns=\"http://wadl.dev.java.net/2009/02\">"));
    }

    @Test
    public void shouldNotGenerateWADLWhenNotExplicitlyEnabledInConfig() throws IOException {
        this.server = CommunityServerBuilder.server().usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).build();
        this.server.start();
        JaxRsResponse response = new RestRequest().get("http://localhost:7474/application.wadl", MediaType.WILDCARD_TYPE);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldNotGenerateWADLWhenExplicitlyDisabledInConfig() throws IOException {
        this.server = CommunityServerBuilder.server().withProperty("unsupported_wadl_generation_enabled", "false").usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).build();
        this.server.start();
        JaxRsResponse response = new RestRequest().get("http://localhost:7474/application.wadl", MediaType.WILDCARD_TYPE);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldHaveSandboxingEnabledByDefault() throws Exception {
        this.server = CommunityServerBuilder.server().usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).build();
        this.server.start();
        JaxRsResponse response = new RestRequest().post("http://localhost:7474/db/data/node/0/traverse/node", "{\n  \"order\" : \"breadth_first\",\n  \"return_filter\" : {\n    \"body\" : \"position.getClass().getClassLoader()\",\n    \"language\" : \"javascript\"\n  },\n  \"prune_evaluator\" : {\n    \"body\" : \"position.getClass().getClassLoader()\",\n    \"language\" : \"javascript\"\n  },\n  \"uniqueness\" : \"node_global\",\n  \"relationships\" : [ {\n    \"direction\" : \"all\",\n    \"type\" : \"knows\"\n  }, {\n    \"direction\" : \"all\",\n    \"type\" : \"loves\"\n  } ],\n  \"max_depth\" : 3\n}", MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test(expected=RuntimeException.class)
    public void shouldBeAbleToDisableSandboxing() throws Exception {
        GlobalJavascriptInitializer.initialize((GlobalJavascriptInitializer.Mode)GlobalJavascriptInitializer.Mode.SANDBOXED);
        this.server = CommunityServerBuilder.server().withProperty("org.neo4j.server.script.sandboxing.enabled", "false").usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).build();
        this.server.start();
    }
}

