/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.Platforms;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.InterruptThreadTimer;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.helpers.Transactor;
import org.neo4j.server.helpers.UnitOfWork;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.tooling.GlobalGraphOperations;

public class StartupTimeoutDocIT {
    TargetDirectory target = TargetDirectory.forTest(StartupTimeoutDocIT.class);
    private static final String DIRSEP = File.separator;
    @Rule
    public TargetDirectory.TestDirectory test = this.target.testDirectory();
    public CommunityNeoServer server;
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();

    @After
    public void stopServer() {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    @Test
    public void shouldTimeoutIfStartupTakesLongerThanTimeout() throws IOException {
        if (Platforms.platformIsWindows()) {
            return;
        }
        Configurator configurator = this.buildProperties();
        configurator.configuration().setProperty("org.neo4j.server.startup_timeout", (Object)1);
        this.server = this.createSlowServer(configurator);
        try {
            this.server.start();
            Assert.fail((String)"Should have been interrupted.");
        }
        catch (ServerStartupException serverStartupException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotFailIfStartupTakesLessTimeThanTimeout() throws IOException {
        Configurator configurator = this.buildProperties();
        configurator.configuration().setProperty("org.neo4j.server.startup_timeout", (Object)100);
        this.server = new CommunityNeoServer(configurator){

            protected Iterable<ServerModule> createServerModules() {
                return Arrays.asList(new Object[0]);
            }
        };
        try {
            this.server.start();
        }
        catch (ServerStartupException e) {
            Assert.fail((String)"Should not have been interupted.");
        }
        InterruptThreadTimer timer = (InterruptThreadTimer)this.server.getDependencyResolver().resolveDependency(InterruptThreadTimer.class);
        Assert.assertThat((Object)timer.getState(), (Matcher)Is.is((Object)InterruptThreadTimer.State.IDLE));
    }

    @Test
    public void shouldNotTimeOutIfTimeoutDisabled() throws IOException {
        Configurator configurator = this.buildProperties();
        configurator.configuration().setProperty("org.neo4j.server.startup_timeout", (Object)0);
        this.server = this.createSlowServer(configurator);
        this.server.start();
    }

    private CommunityNeoServer createSlowServer(Configurator configurator) {
        CommunityNeoServer server = new CommunityNeoServer(configurator){

            protected Iterable<ServerModule> createServerModules() {
                ServerModule slowModule = new ServerModule(){

                    public void start(StringLogger logger) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public void stop() {
                    }
                };
                return Arrays.asList(slowModule);
            }
        };
        return server;
    }

    private Configurator buildProperties() throws IOException {
        new File(this.test.directory().getAbsolutePath() + DIRSEP + "conf").mkdirs();
        Properties databaseProperties = new Properties();
        String databasePropertiesFileName = this.test.directory().getAbsolutePath() + DIRSEP + "conf" + DIRSEP + "neo4j.properties";
        databaseProperties.store(new FileWriter(databasePropertiesFileName), null);
        Properties serverProperties = new Properties();
        String serverPropertiesFilename = this.test.directory().getAbsolutePath() + DIRSEP + "conf" + DIRSEP + "neo4j-server.properties";
        serverProperties.setProperty("org.neo4j.server.database.location", this.test.directory().getAbsolutePath() + DIRSEP + "data" + DIRSEP + "graph.db");
        serverProperties.setProperty("org.neo4j.server.db.tuning.properties", databasePropertiesFileName);
        serverProperties.setProperty("org.neo4j.server.properties", serverPropertiesFilename);
        serverProperties.store(new FileWriter(serverPropertiesFilename), null);
        return new PropertyFileConfigurator(new File(serverPropertiesFilename));
    }

    @Test
    public void shoulWOrk() throws Exception {
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        tx.finish();
        this.clearAll();
        tx = db.beginTx();
        db.createNode();
        tx.success();
        tx.finish();
        this.clearAll();
    }

    private void clearAll() {
        new Transactor(this.dbRule.getGraphDatabaseService(), new UnitOfWork(){

            @Override
            public void doWork() {
                this.deleteAllNodesAndRelationships(StartupTimeoutDocIT.this.dbRule.getGraphDatabaseService());
                this.deleteAllIndexes(StartupTimeoutDocIT.this.dbRule.getGraphDatabaseService());
            }

            private void deleteAllNodesAndRelationships(GraphDatabaseService db) {
                Iterable allNodes = GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes();
                for (Node n : allNodes) {
                    Iterable relationships = n.getRelationships();
                    for (Relationship rel : relationships) {
                        rel.delete();
                    }
                    if (n.getId() != 0L) {
                        n.delete();
                        continue;
                    }
                    for (String key : n.getPropertyKeys()) {
                        n.removeProperty(key);
                    }
                }
            }

            private void deleteAllIndexes(GraphDatabaseService db) {
                IndexManager indexManager = db.index();
                for (String indexName : indexManager.nodeIndexNames()) {
                    try {
                        db.index().forNodes(indexName).delete();
                    }
                    catch (UnsupportedOperationException e) {
                        // empty catch block
                    }
                }
                for (String indexName : indexManager.relationshipIndexNames()) {
                    try {
                        db.index().forRelationships(indexName).delete();
                    }
                    catch (UnsupportedOperationException e) {
                        // empty catch block
                    }
                }
                for (String k : indexManager.getNodeAutoIndexer().getAutoIndexedProperties()) {
                    indexManager.getNodeAutoIndexer().stopAutoIndexingProperty(k);
                }
                indexManager.getNodeAutoIndexer().setEnabled(false);
                for (String k : indexManager.getRelationshipAutoIndexer().getAutoIndexedProperties()) {
                    indexManager.getRelationshipAutoIndexer().stopAutoIndexingProperty(k);
                }
                indexManager.getRelationshipAutoIndexer().setEnabled(false);
            }
        }).execute();
    }
}

