/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.configuration.validation.DatabaseLocationMustBeSpecifiedRule;
import org.neo4j.server.configuration.validation.ValidationRule;
import org.neo4j.server.configuration.validation.Validator;
import org.neo4j.server.database.CommunityDatabase;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.EphemeralDatabase;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.preflight.PreflightTask;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.web.DatabaseActions;
import org.neo4j.tooling.Clock;
import org.neo4j.tooling.FakeClock;
import org.neo4j.tooling.RealClock;

public class CommunityServerBuilder {
    private String portNo = "7474";
    private String maxThreads = null;
    protected String dbDir = null;
    private String webAdminUri = "/db/manage/";
    private String webAdminDataUri = "/db/data/";
    protected PreFlightTasks preflightTasks;
    private final HashMap<String, String> thirdPartyPackages = new HashMap();
    private final Properties arbitraryProperties = new Properties();
    private WhatToDo action;
    protected Clock clock = null;
    private String[] autoIndexedNodeKeys = null;
    private String[] autoIndexedRelationshipKeys = null;
    private String host = null;
    private String[] securityRuleClassNames;
    public boolean persistent;
    private Boolean httpsEnabled = Boolean.FALSE;

    public static CommunityServerBuilder server() {
        return new CommunityServerBuilder();
    }

    public CommunityNeoServer build() throws IOException {
        if (this.dbDir == null && this.persistent) {
            throw new IllegalStateException("Must specify path");
        }
        File configFile = this.createPropertiesFiles();
        if (this.preflightTasks == null) {
            this.preflightTasks = new PreFlightTasks(new PreflightTask[0]){

                public boolean run() {
                    return true;
                }
            };
        }
        return new TestCommunityNeoServer(new PropertyFileConfigurator(new Validator(new ValidationRule[]{new DatabaseLocationMustBeSpecifiedRule()}), configFile), configFile);
    }

    public File createPropertiesFiles() throws IOException {
        File temporaryConfigFile = ServerTestUtils.createTempPropertyFile();
        this.createPropertiesFile(temporaryConfigFile);
        this.createTuningFile(temporaryConfigFile);
        return temporaryConfigFile;
    }

    public CommunityServerBuilder withClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    private void createPropertiesFile(File temporaryConfigFile) {
        String propertyKeys;
        Map properties = MapUtil.stringMap((String[])new String[]{"org.neo4j.server.webadmin.management.uri", this.webAdminUri, "org.neo4j.server.webadmin.data.uri", this.webAdminDataUri});
        if (this.dbDir != null) {
            properties.put("org.neo4j.server.database.location", this.dbDir);
        }
        if (this.portNo != null) {
            properties.put("org.neo4j.server.webserver.port", this.portNo);
        }
        if (this.host != null) {
            properties.put("org.neo4j.server.webserver.address", this.host);
        }
        if (this.maxThreads != null) {
            properties.put("org.neo4j.server.webserver.maxthreads", this.maxThreads);
        }
        if (this.thirdPartyPackages.keySet().size() > 0) {
            properties.put("org.neo4j.server.thirdparty_jaxrs_classes", ServerTestUtils.asOneLine(this.thirdPartyPackages));
        }
        if (this.autoIndexedNodeKeys != null && this.autoIndexedNodeKeys.length > 0) {
            properties.put("node_auto_indexing", "true");
            propertyKeys = StringUtils.join((Object[])this.autoIndexedNodeKeys, (String)",");
            properties.put("node_keys_indexable", propertyKeys);
        }
        if (this.autoIndexedRelationshipKeys != null && this.autoIndexedRelationshipKeys.length > 0) {
            properties.put("relationship_auto_indexing", "true");
            propertyKeys = StringUtils.join((Object[])this.autoIndexedRelationshipKeys, (String)",");
            properties.put("relationship_keys_indexable", propertyKeys);
        }
        if (this.securityRuleClassNames != null && this.securityRuleClassNames.length > 0) {
            propertyKeys = StringUtils.join((Object[])this.securityRuleClassNames, (String)",");
            properties.put("org.neo4j.server.rest.security_rules", propertyKeys);
        }
        if (this.httpsEnabled != null) {
            if (this.httpsEnabled.booleanValue()) {
                properties.put("org.neo4j.server.webserver.https.enabled", "true");
            } else {
                properties.put("org.neo4j.server.webserver.https.enabled", "false");
            }
        }
        for (Object key : this.arbitraryProperties.keySet()) {
            properties.put(String.valueOf(key), String.valueOf(this.arbitraryProperties.get(key)));
        }
        ServerTestUtils.writePropertiesToFile(properties, temporaryConfigFile);
    }

    private void createTuningFile(File temporaryConfigFile) throws IOException {
        if (this.action == WhatToDo.CREATE_GOOD_TUNING_FILE) {
            File databaseTuningPropertyFile = ServerTestUtils.createTempPropertyFile();
            Map properties = MapUtil.stringMap((String[])new String[]{"neostore.nodestore.db.mapped_memory", "25M", "neostore.relationshipstore.db.mapped_memory", "50M", "neostore.propertystore.db.mapped_memory", "90M", "neostore.propertystore.db.strings.mapped_memory", "130M", "neostore.propertystore.db.arrays.mapped_memory", "130M"});
            ServerTestUtils.writePropertiesToFile(properties, databaseTuningPropertyFile);
            ServerTestUtils.writePropertyToFile("org.neo4j.server.db.tuning.properties", databaseTuningPropertyFile.getAbsolutePath(), temporaryConfigFile);
        } else if (this.action == WhatToDo.CREATE_DANGLING_TUNING_FILE_PROPERTY) {
            ServerTestUtils.writePropertyToFile("org.neo4j.server.db.tuning.properties", ServerTestUtils.createTempPropertyFile().getAbsolutePath(), temporaryConfigFile);
        } else if (this.action == WhatToDo.CREATE_CORRUPT_TUNING_FILE) {
            File corruptTuningFile = this.trashFile();
            ServerTestUtils.writePropertyToFile("org.neo4j.server.db.tuning.properties", corruptTuningFile.getAbsolutePath(), temporaryConfigFile);
        }
    }

    private File trashFile() throws IOException {
        File f = ServerTestUtils.createTempPropertyFile();
        try (FileWriter fstream = new FileWriter(f, true);
             BufferedWriter out = new BufferedWriter(fstream);){
            for (int i = 0; i < 100; ++i) {
                out.write((int)System.currentTimeMillis());
            }
        }
        return f;
    }

    protected CommunityServerBuilder() {
    }

    public CommunityServerBuilder persistent() {
        this.persistent = true;
        return this;
    }

    public CommunityServerBuilder onPort(int portNo) {
        this.portNo = String.valueOf(portNo);
        return this;
    }

    public CommunityServerBuilder withMaxJettyThreads(int maxThreads) {
        this.maxThreads = String.valueOf(maxThreads);
        return this;
    }

    public CommunityServerBuilder usingDatabaseDir(String dbDir) {
        this.dbDir = dbDir;
        return this;
    }

    public CommunityServerBuilder withRelativeWebAdminUriPath(String webAdminUri) {
        try {
            URI theUri = new URI(webAdminUri);
            this.webAdminUri = theUri.isAbsolute() ? theUri.getPath() : theUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public CommunityServerBuilder withRelativeWebDataAdminUriPath(String webAdminDataUri) {
        try {
            URI theUri = new URI(webAdminDataUri);
            this.webAdminDataUri = theUri.isAbsolute() ? theUri.getPath() : theUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public CommunityServerBuilder withoutWebServerPort() {
        this.portNo = null;
        return this;
    }

    public CommunityServerBuilder withFailingPreflightTasks() {
        this.preflightTasks = new PreFlightTasks(new PreflightTask[0]){

            public boolean run() {
                return false;
            }

            public PreflightTask failedTask() {
                return new PreflightTask(){

                    public String getFailureMessage() {
                        return "mockFailure";
                    }

                    public boolean run() {
                        return false;
                    }
                };
            }
        };
        return this;
    }

    public CommunityServerBuilder withDefaultDatabaseTuning() {
        this.action = WhatToDo.CREATE_GOOD_TUNING_FILE;
        return this;
    }

    public CommunityServerBuilder withNonResolvableTuningFile() {
        this.action = WhatToDo.CREATE_DANGLING_TUNING_FILE_PROPERTY;
        return this;
    }

    public CommunityServerBuilder withCorruptTuningFile() {
        this.action = WhatToDo.CREATE_CORRUPT_TUNING_FILE;
        return this;
    }

    public CommunityServerBuilder withThirdPartyJaxRsPackage(String packageName, String mountPoint) {
        this.thirdPartyPackages.put(packageName, mountPoint);
        return this;
    }

    public CommunityServerBuilder withFakeClock() {
        this.clock = new FakeClock();
        return this;
    }

    public CommunityServerBuilder withAutoIndexingEnabledForNodes(String ... keys) {
        this.autoIndexedNodeKeys = keys;
        return this;
    }

    public CommunityServerBuilder withAutoIndexingEnabledForRelationships(String ... keys) {
        this.autoIndexedRelationshipKeys = keys;
        return this;
    }

    public CommunityServerBuilder onHost(String host) {
        this.host = host;
        return this;
    }

    public CommunityServerBuilder withSecurityRules(String ... securityRuleClassNames) {
        this.securityRuleClassNames = securityRuleClassNames;
        return this;
    }

    public CommunityServerBuilder withHttpsEnabled() {
        this.httpsEnabled = Boolean.TRUE;
        return this;
    }

    public CommunityServerBuilder withProperty(String key, String value) {
        this.arbitraryProperties.put(key, value);
        return this;
    }

    public CommunityServerBuilder withPreflightTasks(PreflightTask ... tasks) {
        this.preflightTasks = new PreFlightTasks(tasks);
        return this;
    }

    private class TestCommunityNeoServer
    extends CommunityNeoServer {
        private final File configFile;

        public TestCommunityNeoServer(PropertyFileConfigurator propertyFileConfigurator, File configFile) {
            super((Configurator)propertyFileConfigurator);
            this.configFile = configFile;
        }

        protected PreFlightTasks createPreflightTasks() {
            return CommunityServerBuilder.this.preflightTasks;
        }

        protected Database createDatabase() {
            return CommunityServerBuilder.this.persistent ? new CommunityDatabase(this.configurator) : new EphemeralDatabase(this.configurator);
        }

        protected DatabaseActions createDatabaseActions() {
            RealClock clockToUse = CommunityServerBuilder.this.clock != null ? CommunityServerBuilder.this.clock : new RealClock();
            return new DatabaseActions(new LeaseManager((Clock)clockToUse), ForceMode.forced, this.configurator.configuration().getBoolean("org.neo4j.server.script.sandboxing.enabled", Configurator.DEFAULT_SCRIPT_SANDBOXING_ENABLED).booleanValue(), this.database.getGraph());
        }

        public void stop() {
            super.stop();
            this.configFile.delete();
        }
    }

    private static enum WhatToDo {
        CREATE_GOOD_TUNING_FILE,
        CREATE_DANGLING_TUNING_FILE_PROPERTY,
        CREATE_CORRUPT_TUNING_FILE;

    }
}

