/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.Transactor;
import org.neo4j.server.helpers.UnitOfWork;
import org.neo4j.tooling.GlobalGraphOperations;

public class ServerHelper {
    public static void cleanTheDatabase(NeoServer server) {
        if (server == null) {
            return;
        }
        ServerHelper.rollbackAllOpenTransactions(server);
        ServerHelper.cleanTheDatabase(server.getDatabase().getGraph());
        ServerHelper.removeLogs(server);
    }

    public static void cleanTheDatabase(final GraphDatabaseAPI db) {
        new Transactor((GraphDatabaseService)db, new UnitOfWork(){

            @Override
            public void doWork() {
                this.deleteAllNodesAndRelationships();
                this.deleteAllIndexes();
                this.deleteAllIndexRules();
                this.deleteAllConstraints();
            }

            private void deleteAllIndexRules() {
                for (IndexDefinition index : db.schema().getIndexes()) {
                    if (index.isConstraintIndex()) continue;
                    index.drop();
                }
            }

            private void deleteAllConstraints() {
                for (ConstraintDefinition constraint : db.schema().getConstraints()) {
                    constraint.drop();
                }
            }

            private void deleteAllNodesAndRelationships() {
                Iterable allNodes = GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes();
                for (Node n : allNodes) {
                    Iterable relationships = n.getRelationships();
                    for (Relationship rel : relationships) {
                        rel.delete();
                    }
                    if (n.getId() != 0L) {
                        n.delete();
                        continue;
                    }
                    for (String key : n.getPropertyKeys()) {
                        n.removeProperty(key);
                    }
                }
            }

            private void deleteAllIndexes() {
                IndexManager indexManager = db.index();
                for (String indexName : indexManager.nodeIndexNames()) {
                    try {
                        db.index().forNodes(indexName).delete();
                    }
                    catch (UnsupportedOperationException e) {
                        // empty catch block
                    }
                }
                for (String indexName : indexManager.relationshipIndexNames()) {
                    try {
                        db.index().forRelationships(indexName).delete();
                    }
                    catch (UnsupportedOperationException e) {
                        // empty catch block
                    }
                }
                for (String k : indexManager.getNodeAutoIndexer().getAutoIndexedProperties()) {
                    indexManager.getNodeAutoIndexer().stopAutoIndexingProperty(k);
                }
                indexManager.getNodeAutoIndexer().setEnabled(false);
                for (String k : indexManager.getRelationshipAutoIndexer().getAutoIndexedProperties()) {
                    indexManager.getRelationshipAutoIndexer().stopAutoIndexingProperty(k);
                }
                indexManager.getRelationshipAutoIndexer().setEnabled(false);
            }
        }).execute();
    }

    private static void removeLogs(NeoServer server) {
        File logDir = new File(server.getDatabase().getLocation() + File.separator + ".." + File.separator + "log");
        try {
            FileUtils.deleteDirectory((File)logDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static NeoServer createNonPersistentServer() throws IOException {
        return ServerHelper.createServer(false, null);
    }

    public static NeoServer createPersistentServer(File path) throws IOException {
        return ServerHelper.createServer(true, path);
    }

    private static NeoServer createServer(boolean persistent, File path) throws IOException {
        CommunityServerBuilder builder = CommunityServerBuilder.server();
        ServerHelper.configureHostname(builder);
        if (persistent) {
            builder = builder.persistent();
        }
        CommunityNeoServer server = builder.usingDatabaseDir(path != null ? path.getAbsolutePath() : null).build();
        ServerHelper.checkServerCanStart(server.baseUri().getHost(), server.baseUri().getPort());
        server.start();
        return server;
    }

    private static void checkServerCanStart(String host, int port) throws IOException {
        try (ServerSocket serverSocket = null;){
            serverSocket = new ServerSocket(port, 1, InetAddress.getByName(host));
        }
    }

    private static void configureHostname(CommunityServerBuilder builder) {
        String hostName = System.getProperty("neo-server.test.hostname");
        if (StringUtils.isNotEmpty((String)hostName)) {
            builder.onHost(hostName);
        }
    }

    private static void rollbackAllOpenTransactions(NeoServer server) {
        server.getTransactionRegistry().rollbackAllSuspendedTransactions();
    }
}

