/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.kernel.impl.recovery.StoreRecoverer;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.server.configuration.MapBasedConfiguration;
import org.neo4j.server.preflight.PerformRecoveryIfNecessary;

public class TestPerformRecoveryIfNecessary {
    public static final String HOME_DIRECTORY = "target/" + TestPerformRecoveryIfNecessary.class.getSimpleName();
    public static final String STORE_DIRECTORY = HOME_DIRECTORY + "/data/graph.db";
    private static final String LINEBREAK = System.getProperty("line.separator");

    @Test
    public void shouldNotDoAnythingIfNoDBPresent() throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Configuration config = this.buildProperties();
        PerformRecoveryIfNecessary task = new PerformRecoveryIfNecessary(config, new HashMap(), new PrintStream(outputStream));
        Assert.assertThat((String)"Recovery task runs successfully.", (Object)task.run(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"No database should have been created.", (Object)new File(STORE_DIRECTORY).exists(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((String)"Recovery task should not print anything.", (Object)outputStream.toString(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void doesNotPrintAnythingIfDatabaseWasCorrectlyShutdown() throws Exception {
        Configuration config = this.buildProperties();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new GraphDatabaseFactory().newEmbeddedDatabase(STORE_DIRECTORY).shutdown();
        PerformRecoveryIfNecessary task = new PerformRecoveryIfNecessary(config, new HashMap(), new PrintStream(outputStream));
        Assert.assertThat((String)"Recovery task should run successfully.", (Object)task.run(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Database should exist.", (Object)new File(STORE_DIRECTORY).exists(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Recovery should not print anything.", (Object)outputStream.toString(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void shouldPerformRecoveryIfNecessary() throws Exception {
        StoreRecoverer recoverer = new StoreRecoverer();
        Configuration config = this.buildProperties();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new GraphDatabaseFactory().newEmbeddedDatabase(STORE_DIRECTORY).shutdown();
        new File(STORE_DIRECTORY, "nioneo_logical.log.active").delete();
        Assert.assertThat((String)"Store should not be recovered", (Object)recoverer.recoveryNeededAt(new File(STORE_DIRECTORY), new HashMap()), (Matcher)CoreMatchers.is((Object)true));
        PerformRecoveryIfNecessary task = new PerformRecoveryIfNecessary(config, new HashMap(), new PrintStream(outputStream));
        Assert.assertThat((String)"Recovery task should run successfully.", (Object)task.run(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Database should exist.", (Object)new File(STORE_DIRECTORY).exists(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Recovery should print status message.", (Object)outputStream.toString(), (Matcher)CoreMatchers.is((Object)("Detected incorrectly shut down database, performing recovery.." + LINEBREAK)));
        Assert.assertThat((String)"Store should be recovered", (Object)recoverer.recoveryNeededAt(new File(STORE_DIRECTORY), new HashMap()), (Matcher)CoreMatchers.is((Object)false));
    }

    private Configuration buildProperties() throws IOException {
        FileUtils.deleteRecursively((File)new File(HOME_DIRECTORY));
        new File(HOME_DIRECTORY + "/conf").mkdirs();
        Properties databaseProperties = new Properties();
        String databasePropertiesFileName = HOME_DIRECTORY + "/conf/neo4j.properties";
        databaseProperties.store(new FileWriter(databasePropertiesFileName), null);
        MapBasedConfiguration serverProperties = new MapBasedConfiguration();
        serverProperties.setProperty("org.neo4j.server.database.location", (Object)STORE_DIRECTORY);
        serverProperties.setProperty("org.neo4j.server.db.tuning.properties", (Object)databasePropertiesFileName);
        return serverProperties;
    }
}

