/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.TestData;

public class AutoIndexDocIT
extends AbstractRestFunctionalTestBase {
    @Documented(value=" Find node by query from an automatic index.\n \n See Find node by query for the actual query syntax.\n")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true)}, autoIndexNodes=true)
    public void shouldRetrieveFromAutoIndexByQuery() throws PropertyValueException {
        this.data.get();
        this.assertSize(1, ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).get(this.nodeAutoIndexUri() + "?query=name:I").entity());
    }

    private String nodeAutoIndexUri() {
        return this.getDataUri() + "index/auto/node/";
    }

    @Documented(value=" Automatic index nodes can be found via exact lookups with normal Index\n REST syntax.\n")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true)}, autoIndexNodes=true)
    public void find_node_by_exact_match_from_an_automatic_index() throws PropertyValueException {
        this.data.get();
        this.assertSize(1, ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).get(this.nodeAutoIndexUri() + "name/I").entity());
    }

    @Test
    @Documented(value=" The automatic relationship index can not be removed.\n")
    @TestData.Title(value="Relationship AutoIndex is not removable")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true)}, autoIndexNodes=true)
    public void Relationship_AutoIndex_is_not_removable() {
        this.data.get();
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(405).delete(this.relationshipAutoIndexUri()).entity();
    }

    @Test
    @Documented(value=" The automatic node index can not be removed.\n")
    @TestData.Title(value="Node AutoIndex is not removable")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true)}, autoIndexNodes=true)
    public void AutoIndex_is_not_removable() throws JsonParseException {
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(405).delete(this.nodeAutoIndexUri()).entity();
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true)}, autoIndexNodes=true)
    @Documented(value=" It is not allowed to add items manually to automatic indexes.\n")
    @TestData.Title(value="Items can not be added manually to an node AutoIndex")
    public void items_can_not_be_added_manually_to_an_AutoIndex() throws Exception {
        this.data.get();
        String indexName = this.graphdb().index().getNodeAutoIndexer().getAutoIndex().getName();
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(405).payload(this.createJsonStringFor(this.getNodeUri((Node)((Map)this.data.get()).get("I")), "name", "I")).post(this.postNodeIndexUri(indexName)).entity();
    }

    private String createJsonStringFor(String targetUri, String key, String value) {
        return "{\"key\": \"" + key + "\", \"value\": \"" + value + "\", \"uri\": \"" + targetUri + "\"}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I"), @GraphDescription.NODE(name="you")}, relationships={@GraphDescription.REL(start="I", end="you", type="know", properties={@GraphDescription.PROP(key="since", value="today")})}, autoIndexRelationships=true)
    @Documented(value=" It is not allowed to add items manually to automatic indexes.\n")
    @TestData.Title(value="Items can not be added manually to a relationship AutoIndex")
    public void items_can_not_be_added_manually_to_a_Relationship_AutoIndex() throws Exception {
        this.data.get();
        String indexName = this.graphdb().index().getRelationshipAutoIndexer().getAutoIndex().getName();
        Transaction transaction = this.graphdb().beginTx();
        try {
            ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(405).payload(this.createJsonStringFor(this.getRelationshipUri((Relationship)((Node)((Map)this.data.get()).get("I")).getRelationships().iterator().next()), "name", "I")).post(this.postRelationshipIndexUri(indexName)).entity();
        }
        finally {
            transaction.finish();
        }
    }

    @Test
    @Documented(value=" It is not allowed to remove entries manually from automatic indexes.\n")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true)}, autoIndexNodes=true)
    @TestData.Title(value="Automatically indexed nodes cannot be removed from the index manually")
    public void autoindexed_items_cannot_be_removed_manually() throws JsonParseException {
        long id = ((Node)((Map)this.data.get()).get("I")).getId();
        String indexName = this.graphdb().index().getNodeAutoIndexer().getAutoIndex().getName();
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(405).delete(this.getDataUri() + "index/node/" + indexName + "/name/I/" + id).entity();
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(405).delete(this.getDataUri() + "index/node/" + indexName + "/name/" + id).entity();
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(405).delete(this.getDataUri() + "index/node/" + indexName + "/" + id).entity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Documented(value=" It is not allowed to remove entries manually from automatic indexes.\n")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I"), @GraphDescription.NODE(name="you")}, relationships={@GraphDescription.REL(start="I", end="you", type="know", properties={@GraphDescription.PROP(key="since", value="today")})}, autoIndexRelationships=true)
    @TestData.Title(value="Automatically indexed relationships cannot be removed from the index manually")
    public void autoindexed_relationships_cannot_be_removed_manually() throws JsonParseException {
        Transaction transaction = this.graphdb().beginTx();
        try {
            long id = ((Relationship)((Node)((Map)this.data.get()).get("I")).getRelationships().iterator().next()).getId();
            String indexName = this.graphdb().index().getRelationshipAutoIndexer().getAutoIndex().getName();
            ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(405).delete(this.getDataUri() + "index/relationship/" + indexName + "/since/today/" + id).entity();
            ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(405).delete(this.getDataUri() + "index/relationship/" + indexName + "/since/" + id).entity();
            ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(405).delete(this.getDataUri() + "index/relationship/" + indexName + "/" + id).entity();
        }
        finally {
            transaction.finish();
        }
    }

    @Documented(value=" See the example request.\n")
    @TestData.Title(value="Find relationship by query from an automatic index")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I"), @GraphDescription.NODE(name="you")}, relationships={@GraphDescription.REL(start="I", end="you", type="know", properties={@GraphDescription.PROP(key="since", value="today")})}, autoIndexRelationships=true)
    public void Find_relationship_by_query_from_an_automatic_index() throws PropertyValueException {
        this.data.get();
        this.assertSize(1, ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).get(this.relationshipAutoIndexUri() + "?query=since:today").entity());
    }

    @Documented(value=" See the example request.\n")
    @TestData.Title(value="Find relationship by exact match from an automatic index")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I"), @GraphDescription.NODE(name="you")}, relationships={@GraphDescription.REL(start="I", end="you", type="know", properties={@GraphDescription.PROP(key="since", value="today")})}, autoIndexRelationships=true)
    public void Find_relationship_by_exact_match_from_an_automatic_index() throws PropertyValueException {
        this.data.get();
        this.assertSize(1, ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).get(this.relationshipAutoIndexUri() + "since/today/").entity());
    }

    @Test
    @Documented(value=" Get current status for autoindexing on nodes.\n")
    public void getCurrentStatusForNodes() {
        this.checkAndAssertAutoIndexerIsEnabled("node", false);
    }

    @Test
    @Documented(value=" Enable node autoindexing.\n")
    public void enableNodeAutoIndexing() {
        this.setEnabledAutoIndexingForType("node", true);
    }

    @Test
    @Documented(value=" Add a property for autoindexing on nodes.\n")
    public void addAutoIndexingPropertyForNodes() {
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(204).payload("myProperty1").post(this.autoIndexURI("node") + "/properties");
    }

    @Test
    @Documented(value=" Lookup list of properties being autoindexed.\n")
    public void listAutoIndexingPropertiesForNodes() throws JsonParseException {
        String propName = "some-property";
        AutoIndexDocIT.server().getDatabase().getGraph().index().getNodeAutoIndexer().startAutoIndexingProperty(propName);
        List<String> properties = this.getAutoIndexedPropertiesForType("node");
        Assert.assertEquals((long)1L, (long)properties.size());
        Assert.assertEquals((Object)propName, (Object)properties.get(0));
    }

    @Test
    @Documented(value=" Remove a property for autoindexing on nodes.\n")
    public void removeAutoIndexingPropertyForNodes() {
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(204).delete(this.autoIndexURI("node") + "/properties/myProperty1");
    }

    @Test
    public void switchOnOffAutoIndexingForNodes() {
        this.switchOnOffAutoIndexingForType("node");
    }

    @Test
    public void switchOnOffAutoIndexingForRelationships() {
        this.switchOnOffAutoIndexingForType("relationship");
    }

    @Test
    public void addRemoveAutoIndexedPropertyForNodes() throws JsonParseException {
        this.addRemoveAutoIndexedPropertyForType("node");
    }

    @Test
    public void addRemoveAutoIndexedPropertyForRelationships() throws JsonParseException {
        this.addRemoveAutoIndexedPropertyForType("relationship");
    }

    private String relationshipAutoIndexUri() {
        return this.getDataUri() + "index/auto/relationship/";
    }

    private void addRemoveAutoIndexedPropertyForType(String uriPartForType) throws JsonParseException {
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(204).payload("myProperty1").post(this.autoIndexURI(uriPartForType) + "/properties");
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(204).payload("myProperty2").post(this.autoIndexURI(uriPartForType) + "/properties");
        List<String> properties = this.getAutoIndexedPropertiesForType(uriPartForType);
        Assert.assertEquals((long)2L, (long)properties.size());
        Assert.assertTrue((boolean)properties.contains("myProperty1"));
        Assert.assertTrue((boolean)properties.contains("myProperty2"));
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(204).payload(null).delete(this.autoIndexURI(uriPartForType) + "/properties/myProperty2");
        properties = this.getAutoIndexedPropertiesForType(uriPartForType);
        Assert.assertEquals((long)1L, (long)properties.size());
        Assert.assertTrue((boolean)properties.contains("myProperty1"));
    }

    private List<String> getAutoIndexedPropertiesForType(String uriPartForType) throws JsonParseException {
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).get(this.autoIndexURI(uriPartForType) + "/properties").entity();
        return (List)JsonHelper.readJson((String)result);
    }

    private void switchOnOffAutoIndexingForType(String uriPartForType) {
        this.setEnabledAutoIndexingForType(uriPartForType, true);
        this.checkAndAssertAutoIndexerIsEnabled(uriPartForType, true);
        this.setEnabledAutoIndexingForType(uriPartForType, false);
        this.checkAndAssertAutoIndexerIsEnabled(uriPartForType, false);
    }

    private void setEnabledAutoIndexingForType(String uriPartForType, boolean enabled) {
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(204).payload(Boolean.toString(enabled)).put(this.autoIndexURI(uriPartForType) + "/status");
    }

    private void checkAndAssertAutoIndexerIsEnabled(String uriPartForType, boolean enabled) {
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).get(this.autoIndexURI(uriPartForType) + "/status").entity();
        Assert.assertEquals((Object)enabled, (Object)Boolean.parseBoolean(result));
    }

    private String autoIndexURI(String type) {
        return this.getDataUri() + "index/auto/{type}".replace("{type}", type);
    }
}

