/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.test.GraphDescription;

public class SchemaIndexDocIT
extends AbstractRestFunctionalTestBase {
    @Documented(value=" Create schema index.\n\n This will start a background job in the database that will create and populate the new index.\n You can check the status of your index by listing all the indexes for the relevant label.\n The new index will show up, but have a state of \"POPULATING\" until the index is ready.\n")
    @Test
    @GraphDescription.Graph(nodes={})
    public void create_schema_index() throws PropertyValueException {
        this.data.get();
        String labelName = "person";
        String propertyKey = "name";
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Arrays.asList(propertyKey)});
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).payload(JsonHelper.createJsonFrom((Object)definition)).post(this.getSchemaIndexLabelUri(labelName)).entity();
        Map serialized = JsonHelper.jsonToMap((String)result);
        Assert.assertEquals((Object)labelName, serialized.get("label"));
        Assert.assertEquals(Arrays.asList(propertyKey), serialized.get("property-keys"));
    }

    @Documented(value=" List indexes for a label.\n")
    @Test
    @GraphDescription.Graph(nodes={})
    public void get_schema_indexes() throws PropertyValueException {
        this.data.get();
        String labelName = "user";
        String propertyKey = "name";
        this.createSchemaIndex(labelName, propertyKey);
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Arrays.asList(propertyKey)});
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).payload(JsonHelper.createJsonFrom((Object)definition)).get(this.getSchemaIndexLabelUri(labelName)).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        Assert.assertEquals((long)1L, (long)serializedList.size());
        Map serialized = (Map)serializedList.get(0);
        Assert.assertEquals((Object)labelName, serialized.get("label"));
        Assert.assertEquals(Arrays.asList(propertyKey), serialized.get("property-keys"));
    }

    @Documented(value=" Drop schema index\n")
    @Test
    @GraphDescription.Graph(nodes={})
    public void drop_schema_index() throws Exception {
        this.data.get();
        String labelName = "SomeLabel";
        String propertyKey = "name";
        IndexDefinition schemaIndex = this.createSchemaIndex(labelName, propertyKey);
        Assert.assertThat((Object)Neo4jMatchers.getIndexes((GraphDatabaseService)this.graphdb(), (Label)DynamicLabel.label((String)labelName)), (Matcher)Neo4jMatchers.containsOnly((Object[])new IndexDefinition[]{schemaIndex}));
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(204).delete(this.getSchemaIndexLabelPropertyUri(labelName, propertyKey)).entity();
        Assert.assertThat((Object)Neo4jMatchers.getIndexes((GraphDatabaseService)this.graphdb(), (Label)DynamicLabel.label((String)labelName)), (Matcher)IsNot.not((Matcher)Neo4jMatchers.containsOnly((Object[])new IndexDefinition[]{schemaIndex})));
    }

    @Test
    public void create_existing_schema_index() throws PropertyValueException {
        String labelName = "mylabel";
        String propertyKey = "name";
        this.createSchemaIndex(labelName, propertyKey);
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Arrays.asList(propertyKey)});
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(409).payload(JsonHelper.createJsonFrom((Object)definition)).post(this.getSchemaIndexLabelUri(labelName));
    }

    @Test
    public void drop_non_existent_schema_index() throws Exception {
        String labelName = "ALabel";
        String propertyKey = "name";
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(404).delete(this.getSchemaIndexLabelPropertyUri(labelName, propertyKey));
    }

    @Test
    public void create_compound_schema_index() throws PropertyValueException {
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Arrays.asList("first", "other")});
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(400).payload(JsonHelper.createJsonFrom((Object)definition)).post(this.getSchemaIndexLabelUri("a_label"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexDefinition createSchemaIndex(String labelName, String propertyKey) {
        Transaction tx = this.graphdb().beginTx();
        try {
            IndexDefinition indexDefinition = this.graphdb().schema().indexFor(DynamicLabel.label((String)labelName)).on(propertyKey).create();
            tx.success();
            IndexDefinition indexDefinition2 = indexDefinition;
            return indexDefinition2;
        }
        finally {
            tx.finish();
        }
    }

    private Set<Set<String>> asProperties(Iterable<IndexDefinition> indexes) {
        return IteratorUtil.asSet((Iterable)Iterables.map((Function)new Function<IndexDefinition, Set<String>>(){

            public Set<String> apply(IndexDefinition from) {
                return IteratorUtil.asSet((Iterable)from.getPropertyKeys());
            }
        }, indexes));
    }
}

