/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.server.rest.repr.formats.StreamingJsonFormat;
import org.neo4j.test.TestGraphDatabaseFactory;

public class StreamingJsonFormatTest {
    private OutputFormat json;
    private ByteArrayOutputStream stream;

    @Before
    public void createOutputFormat() throws Exception {
        this.stream = new ByteArrayOutputStream();
        this.json = new OutputFormat((RepresentationFormat)new StreamingJsonFormat().writeTo((OutputStream)this.stream).usePrettyPrinter(), new URI("http://localhost/"), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void canFormatNode() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        Transaction transaction = db.beginTx();
        try {
            Node refNode = db.getReferenceNode();
            this.json.assemble((Representation)new NodeRepresentation(refNode));
        }
        finally {
            transaction.finish();
            db.shutdown();
        }
        Assert.assertTrue((boolean)this.stream.toString().contains("\"self\" : \"http://localhost/node/0\","));
    }

    @Test
    public void canFormatString() throws Exception {
        this.json.assemble((Representation)ValueRepresentation.string((String)"expected value"));
        Assert.assertEquals((Object)this.stream.toString(), (Object)"\"expected value\"");
    }

    @Test
    public void canFormatListOfStrings() throws Exception {
        this.json.assemble((Representation)ListRepresentation.strings((String[])new String[]{"hello", "world"}));
        String expectedString = JsonHelper.createJsonFrom(Arrays.asList("hello", "world"));
        Assert.assertEquals((Object)expectedString, (Object)this.stream.toString());
    }

    @Test
    public void canFormatInteger() throws Exception {
        this.json.assemble((Representation)ValueRepresentation.number((int)10));
        Assert.assertEquals((Object)"10", (Object)this.stream.toString());
    }

    @Test
    public void canFormatEmptyObject() throws Exception {
        this.json.assemble((Representation)new MappingRepresentation("empty"){

            protected void serialize(MappingSerializer serializer) {
            }
        });
        Assert.assertEquals((Object)JsonHelper.createJsonFrom(Collections.emptyMap()), (Object)this.stream.toString());
    }

    @Test
    public void canFormatObjectWithStringField() throws Exception {
        this.json.assemble((Representation)new MappingRepresentation("string"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putString("key", "expected string");
            }
        });
        Assert.assertEquals((Object)JsonHelper.createJsonFrom(Collections.singletonMap("key", "expected string")), (Object)this.stream.toString());
    }

    @Test
    public void canFormatObjectWithUriField() throws Exception {
        this.json.assemble((Representation)new MappingRepresentation("uri"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putUri("URL", "subpath");
            }
        });
        Assert.assertEquals((Object)JsonHelper.createJsonFrom(Collections.singletonMap("URL", "http://localhost/subpath")), (Object)this.stream.toString());
    }

    @Test
    public void canFormatObjectWithNestedObject() throws Exception {
        this.json.assemble((Representation)new MappingRepresentation("nesting"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putMapping("nested", new MappingRepresentation("data"){

                    protected void serialize(MappingSerializer nested) {
                        nested.putString("data", "expected data");
                    }
                });
            }
        });
        Assert.assertEquals((Object)JsonHelper.createJsonFrom(Collections.singletonMap("nested", Collections.singletonMap("data", "expected data"))), (Object)this.stream.toString());
    }
}

