/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.CouldNotCreateConstraintException;
import org.neo4j.cypher.CypherException;
import org.neo4j.cypher.InternalException;
import org.neo4j.cypher.ParameterNotFoundException;
import org.neo4j.cypher.SyntaxException;
import org.neo4j.server.rest.transactional.CypherExceptionMapping;
import org.neo4j.server.rest.transactional.error.StatusCode;

public class CypherExceptionMappingTest {
    @Test
    public void shouldMap_SyntaxException_to_STATEMENT_SYNTAX_ERROR() throws Exception {
        Assert.assertEquals((Object)StatusCode.STATEMENT_SYNTAX_ERROR, (Object)this.map((CypherException)new SyntaxException("message")));
    }

    @Test
    public void shouldMap_ParameterNotFoundException_to_STATEMENT_MISSING_PARAMETER() throws Exception {
        Assert.assertEquals((Object)StatusCode.STATEMENT_MISSING_PARAMETER, (Object)this.map((CypherException)new ParameterNotFoundException("message")));
    }

    @Test
    public void shouldMap_CouldNotCreateConstraintException_to_COULD_NOT_CREATE_CONSTRAINT() throws Exception {
        Assert.assertEquals((Object)StatusCode.COULD_NOT_CREATE_CONSTRAINT, (Object)this.map((CypherException)new CouldNotCreateConstraintException("message", (Throwable)new Exception())));
    }

    @Test
    public void shouldMap_InternalException_to_INTERNAL_STATEMENT_EXECUTION_ERROR() throws Exception {
        Assert.assertEquals((Object)StatusCode.INTERNAL_STATEMENT_EXECUTION_ERROR, (Object)this.map((CypherException)new InternalException("message", null)));
    }

    @Test
    public void shouldMap_CypherException_to_STATEMENT_EXECUTION_ERROR() throws Exception {
        Assert.assertEquals((Object)StatusCode.STATEMENT_EXECUTION_ERROR, (Object)this.map(new CypherException("message", null){}));
    }

    private StatusCode map(CypherException cypherException) {
        return new CypherExceptionMapping().apply(cypherException);
    }
}

