/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.rest.transactional.ExecutionResultSerializer;
import org.neo4j.server.rest.transactional.ResultDataContent;
import org.neo4j.server.rest.transactional.Statement;
import org.neo4j.server.rest.transactional.StatementDeserializer;
import org.neo4j.server.rest.transactional.StubStatementDeserializer;
import org.neo4j.server.rest.transactional.TransactionHandle;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.rest.transactional.error.Neo4jError;
import org.neo4j.server.rest.transactional.error.StatusCode;
import org.neo4j.server.rest.web.TransactionUriScheme;

public class TransactionHandleTest {
    private static final TransactionUriScheme uriScheme = new TransactionUriScheme(){

        public URI txUri(long id) {
            return URI.create("transaction/" + id);
        }

        public URI txCommitUri(long id) {
            return URI.create("transaction/" + id + "/commit");
        }
    };

    @Test
    public void shouldExecuteStatements() throws Exception {
        KernelAPI kernel = this.mockKernel();
        ExecutionEngine executionEngine = (ExecutionEngine)Mockito.mock(ExecutionEngine.class);
        ExecutionResult executionResult = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)executionEngine.execute("query", MapUtil.map((Object[])new Object[0]))).thenReturn((Object)executionResult);
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, StringLogger.DEV_NULL);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), null)), output);
        ((ExecutionEngine)Mockito.verify((Object)executionEngine)).execute("query", MapUtil.map((Object[])new Object[0]));
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionCommitUri(uriScheme.txCommitUri(1337L));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(executionResult, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionStatus(Matchers.anyLong());
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Matchers.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldSuspendTransactionAndReleaseForOtherRequestsAfterExecutingStatements() throws Exception {
        KernelAPI kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = (TransitionalTxManagementKernelTransaction)kernel.newTransaction();
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        ExecutionEngine engine = (ExecutionEngine)Mockito.mock(ExecutionEngine.class);
        ExecutionResult executionResult = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)engine.execute("query", MapUtil.map((Object[])new Object[0]))).thenReturn((Object)executionResult);
        TransactionHandle handle = new TransactionHandle(kernel, engine, registry, uriScheme, StringLogger.DEV_NULL);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), null)), output);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{transactionContext, registry});
        ((TransitionalTxManagementKernelTransaction)transactionOrder.verify((Object)transactionContext)).suspendSinceTransactionsAreStillThreadBound();
        ((TransactionRegistry)transactionOrder.verify((Object)registry)).release(1337L, handle);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionCommitUri(uriScheme.txCommitUri(1337L));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(executionResult, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionStatus(Matchers.anyLong());
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Matchers.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldResumeTransactionWhenExecutingStatementsOnSecondRequest() throws Exception {
        KernelAPI kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = (TransitionalTxManagementKernelTransaction)kernel.newTransaction();
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        ExecutionEngine executionEngine = (ExecutionEngine)Mockito.mock(ExecutionEngine.class);
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, StringLogger.DEV_NULL);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), null)), output);
        Mockito.reset((Object[])new Object[]{transactionContext, registry, executionEngine, output});
        ExecutionResult executionResult = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)executionEngine.execute("query", MapUtil.map((Object[])new Object[0]))).thenReturn((Object)executionResult);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), null)), output);
        InOrder order = Mockito.inOrder((Object[])new Object[]{transactionContext, registry, executionEngine});
        ((TransitionalTxManagementKernelTransaction)order.verify((Object)transactionContext)).resumeSinceTransactionsAreStillThreadBound();
        ((ExecutionEngine)order.verify((Object)executionEngine)).execute("query", MapUtil.map((Object[])new Object[0]));
        ((TransitionalTxManagementKernelTransaction)order.verify((Object)transactionContext)).suspendSinceTransactionsAreStillThreadBound();
        ((TransactionRegistry)order.verify((Object)registry)).release(1337L, handle);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionCommitUri(uriScheme.txCommitUri(1337L));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(executionResult, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionStatus(Matchers.anyLong());
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Matchers.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldCommitTransactionAndTellRegistryToForgetItsHandle() throws Exception {
        KernelAPI kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = (TransitionalTxManagementKernelTransaction)kernel.newTransaction();
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        ExecutionEngine engine = (ExecutionEngine)Mockito.mock(ExecutionEngine.class);
        ExecutionResult result = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)engine.execute("query", MapUtil.map((Object[])new Object[0]))).thenReturn((Object)result);
        TransactionHandle handle = new TransactionHandle(kernel, engine, registry, uriScheme, StringLogger.DEV_NULL);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.commit((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), null)), output);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{transactionContext, registry});
        ((TransitionalTxManagementKernelTransaction)transactionOrder.verify((Object)transactionContext)).commit();
        ((TransactionRegistry)transactionOrder.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(result, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Matchers.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldRollbackTransactionAndTellRegistryToForgetItsHandle() throws Exception {
        KernelAPI kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = (TransitionalTxManagementKernelTransaction)kernel.newTransaction();
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, (ExecutionEngine)Mockito.mock(ExecutionEngine.class), registry, uriScheme, StringLogger.DEV_NULL);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.rollback(output);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{transactionContext, registry});
        ((TransitionalTxManagementKernelTransaction)transactionOrder.verify((Object)transactionContext)).rollback();
        ((TransactionRegistry)transactionOrder.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Matchers.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldCreateTransactionContextOnlyWhenFirstNeeded() throws Exception {
        KernelAPI kernel = this.mockKernel();
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        ExecutionEngine engine = (ExecutionEngine)Mockito.mock(ExecutionEngine.class);
        ExecutionResult executionResult = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)engine.execute("query", MapUtil.map((Object[])new Object[0]))).thenReturn((Object)executionResult);
        TransactionHandle handle = new TransactionHandle(kernel, engine, registry, uriScheme, StringLogger.DEV_NULL);
        Mockito.verifyZeroInteractions((Object[])new Object[]{kernel});
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), null)), output);
        ((KernelAPI)Mockito.verify((Object)kernel)).newTransaction();
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionCommitUri(uriScheme.txCommitUri(1337L));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(executionResult, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionStatus(Matchers.anyLong());
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Matchers.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldRollbackTransactionIfDeserializationErrorOccurs() throws Exception {
        KernelAPI kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = (TransitionalTxManagementKernelTransaction)kernel.newTransaction();
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, (ExecutionEngine)Mockito.mock(ExecutionEngine.class), registry, uriScheme, StringLogger.DEV_NULL);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.execute((StatementDeserializer)StubStatementDeserializer.deserilizationErrors(new Neo4jError(StatusCode.INVALID_REQUEST_FORMAT, (Throwable)new Exception())), output);
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)transactionContext)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionCommitUri(uriScheme.txCommitUri(1337L));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Matchers.argThat(TransactionHandleTest.hasErrors(StatusCode.INVALID_REQUEST_FORMAT)));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldRollbackTransactionIfExecutionErrorOccurs() throws Exception {
        KernelAPI kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = (TransitionalTxManagementKernelTransaction)kernel.newTransaction();
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        ExecutionEngine executionEngine = (ExecutionEngine)Mockito.mock(ExecutionEngine.class);
        Mockito.when((Object)executionEngine.execute("query", MapUtil.map((Object[])new Object[0]))).thenThrow(new Throwable[]{new NullPointerException()});
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, StringLogger.DEV_NULL);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), null)), output);
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)transactionContext)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionCommitUri(uriScheme.txCommitUri(1337L));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Matchers.argThat(TransactionHandleTest.hasErrors(StatusCode.INTERNAL_STATEMENT_EXECUTION_ERROR)));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldLogMessageIfCommitErrorOccurs() throws Exception {
        KernelAPI kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = (TransitionalTxManagementKernelTransaction)kernel.newTransaction();
        ((TransitionalTxManagementKernelTransaction)Mockito.doThrow((Throwable)new NullPointerException()).when((Object)transactionContext)).commit();
        StringLogger log = (StringLogger)Mockito.mock(StringLogger.class);
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        ExecutionEngine engine = (ExecutionEngine)Mockito.mock(ExecutionEngine.class);
        ExecutionResult executionResult = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)engine.execute("query", MapUtil.map((Object[])new Object[0]))).thenReturn((Object)executionResult);
        TransactionHandle handle = new TransactionHandle(kernel, engine, registry, uriScheme, log);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.commit((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), null)), output);
        ((StringLogger)Mockito.verify((Object)log)).error((String)Matchers.eq((Object)"Failed to commit transaction."), (Throwable)Matchers.any(NullPointerException.class));
        ((TransactionRegistry)Mockito.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(executionResult, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Matchers.argThat(TransactionHandleTest.hasErrors(StatusCode.INTERNAL_COMMIT_TRANSACTION_ERROR)));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldLogMessageIfCypherSyntaxErrorOccurs() throws Exception {
        KernelAPI kernel = this.mockKernel();
        ExecutionEngine executionEngine = (ExecutionEngine)Mockito.mock(ExecutionEngine.class);
        Mockito.when((Object)executionEngine.execute("matsch (n) return n", MapUtil.map((Object[])new Object[0]))).thenThrow(new Throwable[]{new SyntaxException("did you mean MATCH?")});
        StringLogger log = (StringLogger)Mockito.mock(StringLogger.class);
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin()).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, log);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.commit((StatementDeserializer)StubStatementDeserializer.statements(new Statement("matsch (n) return n", MapUtil.map((Object[])new Object[0]), null)), output);
        ((TransactionRegistry)Mockito.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Matchers.argThat(TransactionHandleTest.hasErrors(StatusCode.STATEMENT_SYNTAX_ERROR)));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    private KernelAPI mockKernel() {
        TransitionalTxManagementKernelTransaction context = (TransitionalTxManagementKernelTransaction)Mockito.mock(TransitionalTxManagementKernelTransaction.class);
        KernelAPI kernel = (KernelAPI)Mockito.mock(KernelAPI.class);
        Mockito.when((Object)kernel.newTransaction()).thenReturn((Object)context);
        return kernel;
    }

    private static Matcher<Iterable<Neo4jError>> hasNoErrors() {
        return TransactionHandleTest.hasErrors(new StatusCode[0]);
    }

    private static Matcher<Iterable<Neo4jError>> hasErrors(StatusCode ... codes) {
        final HashSet<StatusCode> expectedErrorsCodes = new HashSet<StatusCode>(Arrays.asList(codes));
        return new TypeSafeMatcher<Iterable<Neo4jError>>(){

            protected boolean matchesSafely(Iterable<Neo4jError> item) {
                HashSet<StatusCode> actualErrorCodes = new HashSet<StatusCode>();
                for (Neo4jError neo4jError : item) {
                    actualErrorCodes.add(neo4jError.getStatusCode());
                }
                return expectedErrorsCodes.equals(actualErrorCodes);
            }

            public void describeTo(Description description) {
                description.appendText("Errors with set of codes").appendValue((Object)expectedErrorsCodes);
            }
        };
    }
}

