/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import java.util.UUID;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Settings;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.MapBasedConfiguration;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.preflight.EnsurePreparedForHttpLogging;
import org.neo4j.server.preflight.HTTPLoggingPreparednessRuleTest;
import org.neo4j.server.preflight.PreflightFailedException;
import org.neo4j.server.preflight.PreflightTask;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class HTTPLoggingDocIT
extends ExclusiveServerTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses() throws Exception {
        File logDirectory = TargetDirectory.forTest(this.getClass()).directory("givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses-logdir", true);
        FileUtils.forceMkdir((File)logDirectory);
        File confDir = TargetDirectory.forTest(this.getClass()).directory("givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses-confdir", true);
        FileUtils.forceMkdir((File)confDir);
        File configFile = HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDirectory), confDir);
        CommunityNeoServer server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withProperty("org.neo4j.server.http.log.enabled", "false").withProperty("org.neo4j.server.http.log.config", configFile.getPath()).usingDatabaseDir(TargetDirectory.forTest(this.getClass()).directory("givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses-dbdir", true).getAbsolutePath()).build();
        try {
            server.start();
            FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper((NeoServer)server);
            String query = "?implicitlyDisabled" + UUID.randomUUID().toString();
            JaxRsResponse response = new RestRequest().get(functionalTestHelper.webAdminUri() + query);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            response.close();
            Assert.assertFalse((boolean)this.occursIn(query, new File(logDirectory, "http.log")));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess() throws Exception {
        File logDirectory = TargetDirectory.forTest(this.getClass()).directory("givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess-logdir", true);
        FileUtils.forceMkdir((File)logDirectory);
        File confDir = TargetDirectory.forTest(this.getClass()).directory("givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess-confdir", true);
        FileUtils.forceMkdir((File)confDir);
        File configFile = HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDirectory), confDir);
        String query = "?explicitlyEnabled=" + UUID.randomUUID().toString();
        CommunityNeoServer server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withProperty("org.neo4j.server.http.log.enabled", "true").withProperty("org.neo4j.server.http.log.config", configFile.getPath()).usingDatabaseDir(TargetDirectory.forTest(this.getClass()).directory("givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess-dbdir", true).getAbsolutePath()).build();
        try {
            server.start();
            FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper((NeoServer)server);
            JaxRsResponse response = new RestRequest().get(functionalTestHelper.webAdminUri() + query);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            response.close();
            File outputLog = new File(logDirectory, "http.log");
            Assert.assertTrue((boolean)this.occursIn(query, outputLog));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenConfigurationWithUnwritableLogDirectoryShouldFailToStartServer() throws Exception {
        File confDir = TargetDirectory.forTest(this.getClass()).directory("confdir");
        FileUtils.forceMkdir((File)confDir);
        File unwritableLogDir = this.createUnwritableDirectory();
        File configFile = HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(unwritableLogDir), confDir);
        MapBasedConfiguration config = new MapBasedConfiguration();
        config.setProperty("org.neo4j.server.http.log.enabled", (Object)"true");
        config.setProperty("org.neo4j.server.http.log.config", (Object)configFile.getPath());
        CommunityNeoServer server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withPreflightTasks(new PreflightTask[]{new EnsurePreparedForHttpLogging((Configuration)config)}).withProperty("org.neo4j.server.http.log.enabled", "true").withProperty("org.neo4j.server.http.log.config", configFile.getPath()).usingDatabaseDir(TargetDirectory.forTest(this.getClass()).directory("confdir").getAbsolutePath()).build();
        try {
            server.start();
            Assert.fail((String)"should have thrown exception");
        }
        catch (PreflightFailedException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)String.format("HTTP log directory [%s]", unwritableLogDir.getAbsolutePath())));
        }
        finally {
            server.stop();
        }
    }

    private File createUnwritableDirectory() {
        File file;
        if (Settings.osIsWindows()) {
            file = new File("\\\\" + UUID.randomUUID().toString() + "\\http.log");
        } else {
            TargetDirectory targetDirectory = TargetDirectory.forTest(this.getClass());
            file = targetDirectory.file("unwritable-" + System.currentTimeMillis());
            Assert.assertTrue((String)"create directory to be unwritable", (boolean)file.mkdirs());
            Assert.assertTrue((String)"mark directory as unwritable", (boolean)file.setWritable(false, false));
        }
        return file;
    }

    private boolean occursIn(String lookFor, File file) throws FileNotFoundException {
        if (!file.exists()) {
            return false;
        }
        boolean result = false;
        Scanner scanner = new Scanner(file);
        while (scanner.hasNext()) {
            if (!scanner.next().contains(lookFor)) continue;
            result = true;
        }
        scanner.close();
        return result;
    }
}

