/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.rest.transactional.error.StatusCode;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class TransactionTimeoutDocIT
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;

    @After
    public void stopTheServer() {
        this.server.stop();
    }

    @Test
    public void shouldHonorReallyLowSessionTimeout() throws Exception {
        this.server = CommunityServerBuilder.server().withProperty("org.neo4j.server.transaction.timeout", "1").build();
        this.server.start();
        String tx = HTTP.POST(this.txURI(), Arrays.asList(MapUtil.map((Object[])new Object[]{"statement", "CREATE n"}))).location();
        Thread.sleep(2000L);
        Map response = (Map)HTTP.POST(tx + "/commit").content();
        List errors = (List)response.get("errors");
        MatcherAssert.assertThat((Object)((Number)((Map)errors.get(0)).get("code")).intValue(), (Matcher)CoreMatchers.equalTo((Object)StatusCode.INVALID_TRANSACTION_ID.getCode()));
    }

    private String txURI() {
        return this.server.baseUri().toString() + "db/data/transaction";
    }
}

