/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.HashMap;
import org.apache.commons.configuration.MapConfiguration;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.RrdDbWrapper;
import org.neo4j.server.modules.WebAdminModule;
import org.neo4j.server.web.WebServer;

public class WebAdminModuleTest {
    @Test
    public void shouldRegisterRrdDb() throws Exception {
        WebServer webServer = (WebServer)Mockito.mock(WebServer.class);
        CommunityNeoServer neoServer = (CommunityNeoServer)Mockito.mock(CommunityNeoServer.class);
        Mockito.when((Object)neoServer.baseUri()).thenReturn((Object)new URI("http://localhost:7575"));
        Mockito.when((Object)neoServer.getWebServer()).thenReturn((Object)webServer);
        Mockito.when((Object)neoServer.getConfiguration()).thenReturn((Object)new MapConfiguration(new HashMap()));
        Database db = (Database)Mockito.mock(Database.class);
        Mockito.when((Object)neoServer.getDatabase()).thenReturn((Object)db);
        AbstractGraphDatabase graph = (AbstractGraphDatabase)Mockito.mock(AbstractGraphDatabase.class);
        Mockito.when((Object)db.getGraph()).thenReturn((Object)graph);
        DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)graph.getDependencyResolver()).thenReturn((Object)resolver);
        NodeManager nodeManagerMock = (NodeManager)Mockito.mock(NodeManager.class);
        Mockito.when((Object)resolver.resolveDependency(NodeManager.class)).thenReturn((Object)nodeManagerMock);
        WebAdminModule module = new WebAdminModule(webServer, neoServer.getConfiguration(), db);
        module.start(StringLogger.DEV_NULL);
        ((Database)Mockito.verify((Object)db)).setRrdDb((RrdDbWrapper)Matchers.any(RrdDbWrapper.class));
    }
}

