/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.test.GraphDescription;

public class LabelsDocIT
extends AbstractRestFunctionalTestBase {
    @Documented(value=" Adding a label to a node.\n")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true)})
    public void adding_a_label_to_a_node() throws PropertyValueException {
        Map nodes = (Map)this.data.get();
        String nodeUri = this.getNodeUri((Node)nodes.get("I"));
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(204).payload(JsonHelper.createJsonFrom((Object)"MyLabel")).post(nodeUri + "/labels");
    }

    @Documented(value=" Adding multiple labels to a node.\n")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true)})
    public void adding_multiple_labels_to_a_node() throws PropertyValueException {
        Map nodes = (Map)this.data.get();
        String nodeUri = this.getNodeUri((Node)nodes.get("I"));
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(204).payload(JsonHelper.createJsonFrom((Object)new String[]{"MyLabel", "MyOtherLabel"})).post(nodeUri + "/labels");
        Assert.assertThat(nodes.get("I"), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Neo4jMatchers.hasLabels((String[])new String[]{"MyLabel", "MyOtherLabel"})));
    }

    @Documented(value=" Adding a label with an invalid name.\n\n Labels with empty names are not allowed, however, all other valid strings are accepted as label names.\n Adding an invalid label to a node will lead to a HTTP 400 response.\n")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true)})
    public void adding_an_invalid_label_to_a_node() throws PropertyValueException {
        Map nodes = (Map)this.data.get();
        String nodeUri = this.getNodeUri((Node)nodes.get("I"));
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(400).payload(JsonHelper.createJsonFrom((Object)"")).post(nodeUri + "/labels");
    }

    @Documented(value=" Replacing labels on a node.\n\n This removes any labels currently on a node, and replaces them with the labels passed in as the\n request body.\n")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true, labels={@GraphDescription.LABEL(value="Me"), @GraphDescription.LABEL(value="You")})})
    public void replacing_labels_on_a_node() throws PropertyValueException {
        Map nodes = (Map)this.data.get();
        String nodeUri = this.getNodeUri((Node)nodes.get("I"));
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(204).payload(JsonHelper.createJsonFrom((Object)new String[]{"MyOtherLabel", "MyThirdLabel"})).put(nodeUri + "/labels");
        Assert.assertThat(nodes.get("I"), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Neo4jMatchers.hasLabels((String[])new String[]{"MyOtherLabel", "MyThirdLabel"})));
    }

    @Documented(value=" Listing labels for a node.\n")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", labels={@GraphDescription.LABEL(value="Me"), @GraphDescription.LABEL(value="You")}, setNameProperty=true)})
    public void listing_node_labels() throws PropertyValueException {
        Map nodes = (Map)this.data.get();
        String nodeUri = this.getNodeUri((Node)nodes.get("I"));
        String body = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(nodeUri + "/labels").entity();
        List labels = (List)JsonHelper.readJson((String)body);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"Me", "You"}), (Object)IteratorUtil.asSet((Iterable)labels));
    }

    @Documented(value=" Removing a label from a node.\n")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true, labels={@GraphDescription.LABEL(value="MyLabel")})})
    public void removing_a_label_from_a_node() throws PropertyValueException {
        Map nodes = (Map)this.data.get();
        Node node = (Node)nodes.get("I");
        String nodeUri = this.getNodeUri(node);
        String labelName = "MyLabel";
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(204).delete(nodeUri + "/labels/" + labelName);
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Matchers.not((Matcher)Neo4jMatchers.hasLabel((Label)DynamicLabel.label((String)labelName)))));
    }

    @Documented(value=" Removing a non-existent label from a node.\n")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true)})
    public void removing_a_non_existent_label_from_a_node() throws PropertyValueException {
        Map nodes = (Map)this.data.get();
        Node node = (Node)nodes.get("I");
        String nodeUri = this.getNodeUri(node);
        String labelName = "MyLabel";
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(204).delete(nodeUri + "/labels/" + labelName);
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Matchers.not((Matcher)Neo4jMatchers.hasLabel((Label)DynamicLabel.label((String)labelName)))));
    }

    @Documented(value=" Get all nodes with a label.\n")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="a", setNameProperty=true, labels={@GraphDescription.LABEL(value="first"), @GraphDescription.LABEL(value="second")}), @GraphDescription.NODE(name="b", setNameProperty=true, labels={@GraphDescription.LABEL(value="first")}), @GraphDescription.NODE(name="c", setNameProperty=true, labels={@GraphDescription.LABEL(value="second")})})
    public void get_all_nodes_with_label() throws JsonParseException {
        this.data.get();
        String uri = this.getNodesWithLabelUri("first");
        String body = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(uri).entity();
        List parsed = (List)JsonHelper.readJson((String)body);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"a", "b"}), (Object)IteratorUtil.asSet((Iterable)Iterables.map(this.getProperty("name", String.class), (Iterable)parsed)));
    }

    @Test
    @Documented(value=" Get nodes by label and property.\n\n You can retrieve all nodes with a given label and property by passing one property as a query parameter.\n Notice that the property value is JSON-encoded and then URL-encoded.\n\n If there is an index available on the label/property combination you send, that index will be used. If no\n index is available, all nodes with the given label will be filtered through to find matching nodes.\n\n Currently, it is not possible to search using multiple properties.\n")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", labels={@GraphDescription.LABEL(value="Person")}), @GraphDescription.NODE(name="you", labels={@GraphDescription.LABEL(value="Person")}, properties={@GraphDescription.PROP(key="name", value="bob ross")}), @GraphDescription.NODE(name="him", labels={@GraphDescription.LABEL(value="Person")}, properties={@GraphDescription.PROP(key="name", value="cat stevens")})})
    public void get_nodes_with_label_and_property() throws PropertyValueException, UnsupportedEncodingException {
        this.data.get();
        String labelName = "Person";
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(this.getNodesWithLabelAndPropertyUri(labelName, "name", "bob ross")).entity();
        List parsed = (List)JsonHelper.readJson((String)result);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"bob ross"}), (Object)IteratorUtil.asSet((Iterable)Iterables.map(this.getProperty("name", String.class), (Iterable)parsed)));
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", labels={@GraphDescription.LABEL(value="Person")}), @GraphDescription.NODE(name="you", labels={@GraphDescription.LABEL(value="Person")}, properties={@GraphDescription.PROP(key="names", value="bob,ross", type=GraphDescription.PropType.ARRAY, componentType=GraphDescription.PropType.STRING)}), @GraphDescription.NODE(name="him", labels={@GraphDescription.LABEL(value="Person")}, properties={@GraphDescription.PROP(key="names", value="cat,stevens", type=GraphDescription.PropType.ARRAY, componentType=GraphDescription.PropType.STRING)})})
    public void get_nodes_with_label_and_array_property() throws PropertyValueException, UnsupportedEncodingException {
        this.data.get();
        String labelName = "Person";
        String uri = this.getNodesWithLabelAndPropertyUri(labelName, "names", new String[]{"bob", "ross"});
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(uri).entity();
        List parsed = (List)JsonHelper.readJson((String)result);
        Assert.assertEquals((long)1L, (long)parsed.size());
        Assert.assertEquals((Object)IteratorUtil.asSet(Arrays.asList(Arrays.asList("bob", "ross"))), (Object)IteratorUtil.asSet((Iterable)Iterables.map(this.getProperty("names", List.class), (Iterable)parsed)));
    }

    @Test
    @Documented(value=" List all labels.\n")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="a", setNameProperty=true, labels={@GraphDescription.LABEL(value="first"), @GraphDescription.LABEL(value="second")}), @GraphDescription.NODE(name="b", setNameProperty=true, labels={@GraphDescription.LABEL(value="first")}), @GraphDescription.NODE(name="c", setNameProperty=true, labels={@GraphDescription.LABEL(value="second")})})
    public void list_all_labels() throws JsonParseException {
        this.data.get();
        String uri = this.getLabelsUri();
        String body = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(uri).entity();
        Set parsed = IteratorUtil.asSet((Iterable)((List)JsonHelper.readJson((String)body)));
        Assert.assertTrue((boolean)parsed.contains("first"));
        Assert.assertTrue((boolean)parsed.contains("second"));
    }

    private <T> Function<Object, T> getProperty(final String propertyKey, final Class<T> propertyType) {
        return new Function<Object, T>(){

            public T apply(Object from) {
                Map node = (Map)from;
                Map data = (Map)node.get("data");
                return propertyType.cast(data.get(propertyKey));
            }
        };
    }
}

