/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.util.RFC1123;
import org.neo4j.server.rest.transactional.error.StatusCode;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.test.server.HTTP;

public class TransactionDocTest
extends AbstractRestFunctionalTestBase {
    @Test
    @Documented(value=" Begin a transaction\n\n You begin a new transaction by posting zero or more Cypher statements\n to the transaction endpoint. The server will respond with the result of\n your statements, as well as the location of your open transaction.\n")
    public void begin_a_transaction() throws PropertyValueException {
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(201).payload(this.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n {props}) RETURN n', 'parameters': { 'props': { 'name': 'My Node' } } } ] }")).post(this.getDataUri() + "transaction");
        Map result = JsonHelper.jsonToMap((String)response.entity());
        this.assertNoErrors(result);
        Map node = (Map)this.resultCell(result, 0, 0);
        MatcherAssert.assertThat((Object)((String)node.get("name")), (Matcher)CoreMatchers.equalTo((Object)"My Node"));
    }

    @Test
    @Documented(value=" Execute statements in an open transaction\n\n Given that you have an open transaction, you can make a number of requests, each of which executes additional\n statements, and keeps the transaction open by resetting the transaction timeout.\n")
    public void execute_statements_in_an_open_transaction() throws PropertyValueException {
        String location = HTTP.POST(this.getDataUri() + "transaction").location();
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payload(this.quotedJson("{ 'statements': [ { 'statement': 'CREATE n RETURN n' } ] }")).post(location);
        Map result = JsonHelper.jsonToMap((String)response.entity());
        this.assertNoErrors(result);
    }

    @Test
    @Documented(value=" Reset transaction timeout of an open transaction\n\n Every orphaned transaction is automatically expired after a period of inactivity.  This may be prevented\n by resetting the transaction timeout.\n\n The timeout may be reset by sending a keep-alive request to the server that executes an empty list of statements.\n This request will reset the transaction timeout and return the new time at which the transaction will\n expire as an RFC1123 formatted timestamp value in the ``transaction'' section of the response.\n")
    public void reset_transaction_timeout_of_an_open_transaction() throws PropertyValueException, ParseException, InterruptedException {
        HTTP.Response initialResponse = HTTP.POST(this.getDataUri() + "transaction");
        String location = initialResponse.location();
        long initialExpirationTime = this.expirationTime(JsonHelper.jsonToMap((String)initialResponse.rawContent()));
        Thread.sleep(3000L);
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payload(this.quotedJson("{ 'statements': [ ] }")).post(location);
        Map result = JsonHelper.jsonToMap((String)response.entity());
        this.assertNoErrors(result);
        long newExpirationTime = this.expirationTime(result);
        Assert.assertTrue((String)"Expiration time was not increased", (newExpirationTime > initialExpirationTime ? 1 : 0) != 0);
    }

    @Test
    @Documented(value=" Commit an open transaction\n\n Given you have an open transaction, you can send a commit request. Optionally, you submit additional statements\n along with the request that will be executed before committing the transaction.\n")
    public void commit_an_open_transaction() throws PropertyValueException {
        String location = HTTP.POST(this.getDataUri() + "transaction").location();
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payload(this.quotedJson("{ 'statements': [ { 'statement': 'CREATE n RETURN id(n)' } ] }")).post(location + "/commit");
        Map result = JsonHelper.jsonToMap((String)response.entity());
        this.assertNoErrors(result);
        Integer id = (Integer)this.resultCell(result, 0, 0);
        MatcherAssert.assertThat((Object)HTTP.GET(this.getNodeUri(id.intValue())).status(), (Matcher)CoreMatchers.is((Object)200));
    }

    @Test
    @Documented(value=" Begin and commit a transaction in one request\n\n If there is no need to keep a transaction open across multiple HTTP requests, you can begin a transaction,\n execute statements, and commit with just a single HTTP request.\n")
    public void begin_and_commit_a_transaction_in_one_request() throws PropertyValueException {
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payload(this.quotedJson("{ 'statements': [ { 'statement': 'CREATE n RETURN id(n)' } ] }")).post(this.getDataUri() + "transaction/commit");
        Map result = JsonHelper.jsonToMap((String)response.entity());
        this.assertNoErrors(result);
        Integer id = (Integer)this.resultCell(result, 0, 0);
        MatcherAssert.assertThat((Object)HTTP.GET(this.getNodeUri(id.intValue())).status(), (Matcher)CoreMatchers.is((Object)200));
    }

    @Test
    @Documented(value=" Return results in graph format\n\n If you want to understand the graph structure of nodes and relationships returned by your query,\n you can specify the \"graph\" results data format. For example, this is useful when you want to visualise the\n graph structure. The format collates all the nodes and relationships from all columns of the result,\n and also flattens collections of nodes and relationships, including paths.\n")
    public void return_results_in_graph_format() throws PropertyValueException {
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payload(this.quotedJson("{'statements':[{'statement':'CREATE ( bike:Bike { weight: 10 } )CREATE ( frontWheel:Wheel { spokes: 3 } )CREATE ( backWheel:Wheel { spokes: 32 } )CREATE p1 = bike -[:HAS { position: 1 } ]-> frontWheel CREATE p2 = bike -[:HAS { position: 2 } ]-> backWheel RETURN bike, p1, p2', 'resultDataContents': ['row','graph']}] }")).post(this.getDataUri() + "transaction/commit");
        Map result = JsonHelper.jsonToMap((String)response.entity());
        this.assertNoErrors(result);
        Map<String, List<Object>> row = this.graphRow(result, 0);
        Assert.assertEquals((long)3L, (long)row.get("nodes").size());
        Assert.assertEquals((long)2L, (long)row.get("relationships").size());
    }

    @Test
    @Documented(value=" Rollback an open transaction\n\n Given that you have an open transaction, you can send a roll back request. The server will roll back the\n transaction.\n")
    public void rollback_an_open_transaction() throws PropertyValueException {
        HTTP.Response firstReq = HTTP.POST(this.getDataUri() + "transaction", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n RETURN id(n)' } ] }"));
        String location = firstReq.location();
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).delete(location + "");
        Map result = JsonHelper.jsonToMap((String)response.entity());
        this.assertNoErrors(result);
        Integer id = (Integer)this.resultCell(firstReq, 0, 0);
        MatcherAssert.assertThat((Object)HTTP.GET(this.getNodeUri(id.intValue())).status(), (Matcher)CoreMatchers.is((Object)404));
    }

    @Test
    @Documented(value=" Handling errors\n\n The result of any request against the transaction endpoint is streamed back to the client.\n Therefore the server does not know whether the request will be successful or not when it sends the HTTP status\n code.\n\n Because of this, all requests against the transactional endpoint will return 200 or 201 status code, regardless\n of whether statements were successfully executed. At the end of the response payload, the server includes a list\n of errors that occurred while executing statements. If this list is empty, the request completed successfully.\n\n If any errors occur while executing statements, the server will roll back the transaction.\n\n In this example, we send the server an invalid statement to demonstrate error handling.\n")
    public void handling_errors() throws PropertyValueException {
        String location = HTTP.POST(this.getDataUri() + "transaction").location();
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payload(this.quotedJson("{ 'statements': [ { 'statement': 'This is not a valid Cypher Statement.' } ] }")).post(location + "/commit");
        Map result = JsonHelper.jsonToMap((String)response.entity());
        this.assertErrors(result, StatusCode.STATEMENT_SYNTAX_ERROR);
    }

    private void assertNoErrors(Map<String, Object> response) {
        this.assertErrors(response, new StatusCode[0]);
    }

    private void assertErrors(Map<String, Object> response, StatusCode ... expectedErrors) {
        Iterator errors = ((List)response.get("errors")).iterator();
        Iterator expected = IteratorUtil.iterator((Object[])expectedErrors);
        while (expected.hasNext()) {
            Assert.assertTrue((boolean)errors.hasNext());
            MatcherAssert.assertThat((Object)((Integer)((Map)errors.next()).get("code")), (Matcher)CoreMatchers.equalTo((Object)((StatusCode)expected.next()).getCode()));
        }
        if (errors.hasNext()) {
            Map error = (Map)errors.next();
            Assert.fail((String)("Expected no more errors, but got " + error.get("code") + " - '" + error.get("message") + "'."));
        }
    }

    private <T> T resultCell(HTTP.Response response, int row, int column) {
        return this.resultCell((Map)response.content(), row, column);
    }

    private <T> T resultCell(Map<String, Object> response, int row, int column) {
        Map result = (Map)((List)response.get("results")).get(0);
        List data = (List)result.get("data");
        return (T)((List)((Map)data.get(row)).get("row")).get(column);
    }

    private Map<String, List<Object>> graphRow(Map<String, Object> response, int row) {
        Map result = (Map)((List)response.get("results")).get(0);
        List data = (List)result.get("data");
        return (Map)((Map)data.get(row)).get("graph");
    }

    private String quotedJson(String singleQuoted) {
        return singleQuoted.replaceAll("'", "\"");
    }

    private long expirationTime(Map<String, Object> entity) throws ParseException {
        String timestampString = (String)((Map)entity.get("transaction")).get("expires");
        return RFC1123.parseTimestamp((String)timestampString).getTime();
    }
}

