/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.paging;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.database.Database;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.scripting.javascript.GlobalJavascriptInitializer;
import org.neo4j.test.Mute;
import org.neo4j.test.TestData;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.tooling.Clock;
import org.neo4j.tooling.FakeClock;

public class PagedTraverserDocIT
extends ExclusiveServerTestBase {
    private static CommunityNeoServer server;
    private static FunctionalTestHelper functionalTestHelper;
    private Node theStartNode;
    private static final String PAGED_TRAVERSE_LINK_REL = "paged_traverse";
    private static final int SHORT_LIST_LENGTH = 33;
    private static final int LONG_LIST_LENGTH = 444;
    @ClassRule
    public static TemporaryFolder staticFolder;
    @Rule
    public TestData<RESTDocsGenerator> gen = TestData.producedThrough(RESTDocsGenerator.PRODUCER);
    private static FakeClock clock;

    @Before
    public void setUp() {
        ((RESTDocsGenerator)((Object)this.gen.get())).setSection("dev/rest-api");
    }

    @BeforeClass
    public static void setupServer() throws Exception {
        clock = new FakeClock();
        server = CommunityServerBuilder.server().usingDatabaseDir(staticFolder.getRoot().getAbsolutePath()).withClock((Clock)clock).build();
        Mute.muteAll().call((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                server.start();
                return null;
            }
        });
        functionalTestHelper = new FunctionalTestHelper((NeoServer)server);
    }

    @Before
    public void setupTheDatabase() throws Exception {
        ServerHelper.cleanTheDatabase((NeoServer)server);
    }

    @AfterClass
    public static void stopServer() throws Exception {
        Mute.muteAll().call((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                server.stop();
                return null;
            }
        });
    }

    @Test
    public void nodeRepresentationShouldHaveLinkToPagedTraverser() throws Exception {
        this.theStartNode = this.createLinkedList(33, server.getDatabase());
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.nodeUri(this.theStartNode.getId()));
        Map jsonMap = JsonHelper.jsonToMap((String)response.getEntity());
        Assert.assertNotNull((Object)jsonMap.containsKey(PAGED_TRAVERSE_LINK_REL));
        Assert.assertThat((Object)String.valueOf(jsonMap.get(PAGED_TRAVERSE_LINK_REL)), (Matcher)Matchers.containsString((String)("/db/data/node/" + String.valueOf(this.theStartNode.getId()) + "/paged/traverse/{returnType}{?pageSize,leaseTime}")));
    }

    @Documented(value=" Creating a paged traverser. Paged traversers are created by +POST+-ing a\n traversal description to the link identified by the +paged_traverser+ key\n in a node representation. When creating a paged traverser, the same\n options apply as for a regular traverser, meaning that +node+, +path+,\n or +fullpath+, can be targeted.\n")
    @Test
    public void shouldPostATraverserWithDefaultOptionsAndReceiveTheFirstPageOfResults() throws Exception {
        this.theStartNode = this.createLinkedList(33, server.getDatabase());
        RESTDocsGenerator.ResponseEntity entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedType(MediaType.valueOf((String)"application/json; charset=UTF-8")).expectedHeader("Location").expectedStatus(201).payload(this.traverserDescription()).payloadType(MediaType.APPLICATION_JSON_TYPE).post(functionalTestHelper.nodeUri(this.theStartNode.getId()) + "/paged/traverse/node");
        Assert.assertEquals((long)201L, (long)entity.response().getStatus());
        Assert.assertThat((Object)entity.response().getLocation().toString(), (Matcher)Matchers.containsString((String)("/db/data/node/" + this.theStartNode.getId() + "/paged/traverse/node/")));
        Assert.assertEquals((Object)"application/json; charset=UTF-8", (Object)entity.response().getType().toString());
    }

    @Documented(value=" Paging through the results of a paged traverser. Paged traversers hold\n state on the server, and allow clients to page through the results of a\n traversal. To progress to the next page of traversal results, the client\n issues a HTTP GET request on the paged traversal URI which causes the\n traversal to fill the next page (or partially fill it if insufficient\n results are available).\n <p/>\n Note that if a traverser expires through inactivity it will cause a 404\n response on the next +GET+ request. Traversers' leases are renewed on\n every successful access for the same amount of time as originally\n specified.\n <p/>\n When the paged traverser reaches the end of its results, the client can\n expect a 404 response as the traverser is disposed by the server.\n")
    @Test
    public void shouldBeAbleToTraverseAllThePagesWithDefaultPageSize() {
        this.theStartNode = this.createLinkedList(444, server.getDatabase());
        URI traverserLocation = this.createPagedTraverser().getLocation();
        int enoughPagesToExpireTheTraverser = 3;
        for (int i = 0; i < enoughPagesToExpireTheTraverser; ++i) {
            ((RESTDocsGenerator)((Object)this.gen.get())).expectedType(MediaType.APPLICATION_JSON_TYPE).expectedStatus(200).payload(this.traverserDescription()).get(traverserLocation.toString());
        }
        JaxRsResponse response = new RestRequest(traverserLocation).get();
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldExpireTheTraverserAfterDefaultTimeoutAndGetA404Response() {
        this.theStartNode = this.createLinkedList(33, server.getDatabase());
        JaxRsResponse postResponse = this.createPagedTraverser();
        Assert.assertEquals((long)201L, (long)postResponse.getStatus());
        int TEN_MINUTES = 10;
        clock.forward(10L, TimeUnit.MINUTES);
        JaxRsResponse getResponse = new RestRequest(postResponse.getLocation()).get();
        Assert.assertEquals((long)404L, (long)getResponse.getStatus());
    }

    @Documented(value=" Paged traverser page size. The default page size is 50 items, but\n depending on the application larger or smaller pages sizes might be\n appropriate. This can be set by adding a +pageSize+ query parameter.\n")
    @Test
    public void shouldBeAbleToTraverseAllThePagesWithNonDefaultPageSize() {
        this.theStartNode = this.createLinkedList(33, server.getDatabase());
        URI traverserLocation = this.createPagedTraverserWithPageSize(1).getLocation();
        int enoughPagesToExpireTheTraverser = 12;
        for (int i = 0; i < enoughPagesToExpireTheTraverser; ++i) {
            JaxRsResponse response = new RestRequest(traverserLocation).get();
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
        JaxRsResponse response = new RestRequest(traverserLocation).get();
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Documented(value=" Paged traverser timeout. The default timeout for a paged traverser is 60\n seconds, but depending on the application larger or smaller timeouts\n might be appropriate. This can be set by adding a +leaseTime+ query\n parameter with the number of seconds the paged traverser should last.\n")
    @Test
    public void shouldExpireTraverserWithNonDefaultTimeout() {
        this.theStartNode = this.createLinkedList(33, server.getDatabase());
        URI traverserLocation = this.createPagedTraverserWithTimeoutInMinutes(10).getLocation();
        clock.forward(11L, TimeUnit.MINUTES);
        JaxRsResponse response = new RestRequest(traverserLocation).get();
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldTraverseAllPagesWithANonDefaultTimeoutAndNonDefaultPageSize() {
        this.theStartNode = this.createLinkedList(33, server.getDatabase());
        URI traverserLocation = this.createPagedTraverserWithTimeoutInMinutesAndPageSize(10, 2).getLocation();
        int enoughPagesToExpireTheTraverser = 6;
        for (int i = 0; i < enoughPagesToExpireTheTraverser; ++i) {
            JaxRsResponse response = new RestRequest(traverserLocation).get();
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
        JaxRsResponse response = new RestRequest(traverserLocation).get();
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith400OnNegativeLeaseTime() {
        this.theStartNode = this.createLinkedList(33, server.getDatabase());
        int negativeLeaseTime = -9;
        JaxRsResponse response = RestRequest.req().post(functionalTestHelper.nodeUri(this.theStartNode.getId()) + "/paged/traverse/node?leaseTime=" + String.valueOf(negativeLeaseTime), this.traverserDescription());
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith400OnNegativePageSize() {
        this.theStartNode = this.createLinkedList(33, server.getDatabase());
        int negativePageSize = -99;
        JaxRsResponse response = RestRequest.req().post(functionalTestHelper.nodeUri(this.theStartNode.getId()) + "/paged/traverse/node?pageSize=" + String.valueOf(negativePageSize), this.traverserDescription());
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith400OnScriptErrors() {
        GlobalJavascriptInitializer.initialize((GlobalJavascriptInitializer.Mode)GlobalJavascriptInitializer.Mode.SANDBOXED);
        JaxRsResponse response = RestRequest.req().post(functionalTestHelper.nodeUri(0L) + "/paged/traverse/node?pageSize=50", "{\"prune_evaluator\":{\"language\":\"builtin\",\"name\":\"none\"},\"return_filter\":{\"language\":\"javascript\",\"body\":\"position.getClass().getClassLoader();\"},\"order\":\"depth_first\",\"relationships\":{\"type\":\"NEXT\",\"direction\":\"out\"}}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith200OnFirstDeletionOfTraversalAnd404Afterwards() {
        this.theStartNode = this.createLinkedList(33, server.getDatabase());
        JaxRsResponse response = this.createPagedTraverser();
        RestRequest request = RestRequest.req();
        JaxRsResponse deleteResponse = request.delete(response.getLocation());
        Assert.assertEquals((long)200L, (long)deleteResponse.getStatus());
        deleteResponse = request.delete(response.getLocation());
        Assert.assertEquals((long)404L, (long)deleteResponse.getStatus());
    }

    @Test
    public void shouldAcceptJsonAndStreamingFlagAndProduceStreamedJson() {
        this.theStartNode = this.createLinkedList(33, server.getDatabase());
        JaxRsResponse pagedTraverserResponse = this.createStreamingPagedTraverserWithTimeoutInMinutesAndPageSize(60, 1);
        System.out.println((String)pagedTraverserResponse.getHeaders().getFirst((Object)"Content-Type"));
        Assert.assertNotNull((Object)pagedTraverserResponse.getHeaders().getFirst((Object)"Content-Type"));
        Assert.assertThat((Object)pagedTraverserResponse.getHeaders().getFirst((Object)"Content-Type"), (Matcher)Matchers.containsString((String)"application/json; charset=UTF-8; stream=true"));
    }

    private JaxRsResponse createStreamingPagedTraverserWithTimeoutInMinutesAndPageSize(int leaseTimeInSeconds, int pageSize) {
        String description = this.traverserDescription();
        return RestRequest.req().header("X-Stream", "true").post(functionalTestHelper.nodeUri(this.theStartNode.getId()) + "/paged/traverse/node?leaseTime=" + leaseTimeInSeconds + "&pageSize=" + pageSize, description);
    }

    @Test
    public void should201WithAcceptJsonHeader() {
        this.theStartNode = this.createLinkedList(33, server.getDatabase());
        String uri = functionalTestHelper.nodeUri(this.theStartNode.getId()) + "/paged/traverse/node";
        JaxRsResponse response = RestRequest.req().accept(MediaType.APPLICATION_JSON_TYPE).post(uri, this.traverserDescription());
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getHeaders().getFirst((Object)"Content-Type"));
        Assert.assertThat((Object)response.getType().toString(), (Matcher)Matchers.containsString((String)"application/json"));
    }

    @Test
    public void should201WithAcceptHtmlHeader() {
        this.theStartNode = this.createLinkedList(33, server.getDatabase());
        String uri = functionalTestHelper.nodeUri(this.theStartNode.getId()) + "/paged/traverse/node";
        JaxRsResponse response = RestRequest.req().accept(MediaType.TEXT_HTML_TYPE).post(uri, this.traverserDescription());
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getHeaders().getFirst((Object)"Content-Type"));
        Assert.assertThat((Object)response.getType().toString(), (Matcher)Matchers.containsString((String)"text/html"));
    }

    @Test
    public void shouldHaveTransportEncodingChunkedOnResponseHeader() {
        this.theStartNode = this.createLinkedList(33, server.getDatabase());
        JaxRsResponse response = this.createStreamingPagedTraverserWithTimeoutInMinutesAndPageSize(60, 1);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json; charset=UTF-8; stream=true", (Object)response.getHeaders().getFirst((Object)"Content-Type"));
        Assert.assertThat((Object)response.getHeaders().getFirst((Object)"Transfer-Encoding"), (Matcher)Matchers.containsString((String)"chunked"));
    }

    private JaxRsResponse createPagedTraverserWithTimeoutInMinutesAndPageSize(int leaseTimeInSeconds, int pageSize) {
        String description = this.traverserDescription();
        return RestRequest.req().post(functionalTestHelper.nodeUri(this.theStartNode.getId()) + "/paged/traverse/node?leaseTime=" + leaseTimeInSeconds + "&pageSize=" + pageSize, description);
    }

    private JaxRsResponse createPagedTraverserWithTimeoutInMinutes(int leaseTime) {
        RESTDocsGenerator.ResponseEntity responseEntity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedType(MediaType.APPLICATION_JSON_TYPE).expectedStatus(201).payload(this.traverserDescription()).post(functionalTestHelper.nodeUri(this.theStartNode.getId()) + "/paged/traverse/node?leaseTime=" + String.valueOf(leaseTime));
        return responseEntity.response();
    }

    private JaxRsResponse createPagedTraverserWithPageSize(int pageSize) {
        RESTDocsGenerator.ResponseEntity responseEntity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedType(MediaType.APPLICATION_JSON_TYPE).expectedStatus(201).payload(this.traverserDescription()).post(functionalTestHelper.nodeUri(this.theStartNode.getId()) + "/paged/traverse/node?pageSize=" + String.valueOf(pageSize));
        return responseEntity.response();
    }

    private JaxRsResponse createPagedTraverser() {
        String uri = functionalTestHelper.nodeUri(this.theStartNode.getId()) + "/paged/traverse/node";
        return RestRequest.req().post(uri, this.traverserDescription());
    }

    private String traverserDescription() {
        String description = "{\"prune_evaluator\":{\"language\":\"builtin\",\"name\":\"none\"},\"return_filter\":{\"language\":\"javascript\",\"body\":\"position.endNode().getProperty('name').contains('1');\"},\"order\":\"depth_first\",\"relationships\":{\"type\":\"NEXT\",\"direction\":\"out\"}}";
        return description;
    }

    private Node createLinkedList(int listLength, Database db) {
        Node startNode = null;
        try (Transaction tx = db.getGraph().beginTx();){
            Node previous = null;
            for (int i = 0; i < listLength; ++i) {
                Node current = db.getGraph().createNode();
                current.setProperty("name", (Object)String.valueOf(i));
                if (previous != null) {
                    previous.createRelationshipTo(current, (RelationshipType)DynamicRelationshipType.withName((String)"NEXT"));
                } else {
                    startNode = current;
                }
                previous = current;
            }
            tx.success();
            Node node = startNode;
            return node;
        }
    }

    static {
        staticFolder = new TemporaryFolder();
    }
}

