/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.InterruptThreadTimer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.NeoServerProvider;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.configuration.ConfigurationProvider;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.database.CypherExecutorProvider;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.DatabaseProvider;
import org.neo4j.server.database.GraphDatabaseServiceProvider;
import org.neo4j.server.database.InjectableProvider;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.RESTApiModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.PluginInvocatorProvider;
import org.neo4j.server.plugins.PluginManager;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.preflight.PreflightFailedException;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.repr.InputFormatProvider;
import org.neo4j.server.rest.repr.OutputFormatProvider;
import org.neo4j.server.rest.repr.RepresentationFormatRepository;
import org.neo4j.server.rest.transactional.TransactionFacade;
import org.neo4j.server.rest.transactional.TransactionFilter;
import org.neo4j.server.rest.transactional.TransactionHandleRegistry;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;
import org.neo4j.server.rest.web.DatabaseActions;
import org.neo4j.server.rrd.RrdDbProvider;
import org.neo4j.server.security.KeyStoreFactory;
import org.neo4j.server.security.KeyStoreInformation;
import org.neo4j.server.security.SslCertificateFactory;
import org.neo4j.server.statistic.StatisticCollector;
import org.neo4j.server.web.SimpleUriBuilder;
import org.neo4j.server.web.WebServer;
import org.neo4j.server.web.WebServerProvider;
import org.neo4j.tooling.Clock;
import org.neo4j.tooling.RealClock;

public abstract class AbstractNeoServer
implements NeoServer {
    @Deprecated
    public static final Logger log = Logger.getLogger(AbstractNeoServer.class);
    protected Database database;
    protected CypherExecutor cypherExecutor;
    protected Configurator configurator;
    protected WebServer webServer;
    protected final StatisticCollector statisticsCollector = new StatisticCollector();
    private PreFlightTasks preflight;
    private final List<ServerModule> serverModules = new ArrayList<ServerModule>();
    private final SimpleUriBuilder uriBuilder = new SimpleUriBuilder();
    private InterruptThreadTimer interruptStartupTimer;
    private DatabaseActions databaseActions;
    private TransactionFacade transactionFacade;
    private TransactionHandleRegistry transactionRegistry;
    private Logging logging;
    private final DependencyResolver dependencyResolver = new DependencyResolver.Adapter(){

        private <T> T resolveKnownSingleDependency(Class<T> type) {
            if (type.equals(Database.class)) {
                return (T)AbstractNeoServer.this.database;
            }
            if (type.equals(PreFlightTasks.class)) {
                return (T)AbstractNeoServer.this.preflight;
            }
            if (type.equals(InterruptThreadTimer.class)) {
                return (T)AbstractNeoServer.this.interruptStartupTimer;
            }
            DependencyResolver kernelDependencyResolver = AbstractNeoServer.this.database.getGraph().getDependencyResolver();
            return (T)kernelDependencyResolver.resolveDependency(type);
        }

        public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy<T> selector) {
            return (T)selector.select(type, Iterables.option(this.resolveKnownSingleDependency(type)));
        }
    };

    protected abstract PreFlightTasks createPreflightTasks();

    protected abstract Iterable<ServerModule> createServerModules();

    protected abstract Database createDatabase();

    protected abstract WebServer createWebServer();

    @Override
    public void init() {
        this.preflight = this.createPreflightTasks();
        this.database = this.createDatabase();
        this.webServer = this.createWebServer();
        for (ServerModule moduleClass : this.createServerModules()) {
            this.registerModule(moduleClass);
        }
    }

    @Override
    public void start() throws ServerStartupException {
        this.interruptStartupTimer = this.createInterruptStartupTimer();
        try {
            this.runPreflightTasks();
            this.interruptStartupTimer.startCountdown();
            this.database.start();
            DiagnosticsManager diagnosticsManager = this.resolveDependency(DiagnosticsManager.class);
            this.logging = this.resolveDependency(Logging.class);
            StringLogger diagnosticsLog = diagnosticsManager.getTargetLog();
            diagnosticsLog.info("--- SERVER STARTED START ---");
            this.databaseActions = this.createDatabaseActions();
            this.transactionFacade = this.createTransactionalActions();
            this.cypherExecutor = new CypherExecutor(this.database, this.logging.getMessagesLog(CypherExecutor.class));
            this.configureWebServer();
            this.cypherExecutor.start();
            diagnosticsManager.register(Configurator.DIAGNOSTICS, (Object)this.configurator);
            this.startModules(diagnosticsLog);
            this.startWebServer(diagnosticsLog);
            diagnosticsLog.info("--- SERVER STARTED END ---");
            this.interruptStartupTimer.stopCountdown();
        }
        catch (Throwable t) {
            this.interruptStartupTimer.stopCountdown();
            Thread.interrupted();
            if (this.interruptStartupTimer.wasTriggered()) {
                if (this.database.isRunning()) {
                    this.stopDatabase();
                }
                throw new ServerStartupException("Startup took longer than " + this.interruptStartupTimer.getTimeoutMillis() + "ms, " + "and was stopped. You can disable this behavior by setting '" + "org.neo4j.server.startup_timeout" + "' to 0.", 1);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new ServerStartupException("Starting neo server failed, see nested exception.", t);
        }
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    protected DatabaseActions createDatabaseActions() {
        return new DatabaseActions(new LeaseManager((Clock)new RealClock()), ForceMode.forced, this.configurator.configuration().getBoolean("org.neo4j.server.script.sandboxing.enabled", Configurator.DEFAULT_SCRIPT_SANDBOXING_ENABLED), this.database.getGraph());
    }

    private TransactionFacade createTransactionalActions() {
        long timeoutMillis = this.getTransactionTimeoutMillis();
        RealClock clock = new RealClock();
        this.transactionRegistry = new TransactionHandleRegistry((Clock)clock, timeoutMillis, this.logging.getMessagesLog(TransactionRegistry.class));
        long runEvery = Math.round((double)timeoutMillis / 2.0);
        this.resolveDependency(JobScheduler.class).scheduleRecurring(new Runnable((Clock)clock, timeoutMillis){
            final /* synthetic */ Clock val$clock;
            final /* synthetic */ long val$timeoutMillis;
            {
                this.val$clock = clock;
                this.val$timeoutMillis = l;
            }

            @Override
            public void run() {
                long maxAge = this.val$clock.currentTimeMillis() - this.val$timeoutMillis;
                AbstractNeoServer.this.transactionRegistry.rollbackSuspendedTransactionsIdleSince(maxAge);
            }
        }, runEvery, TimeUnit.MILLISECONDS);
        return new TransactionFacade(new TransitionalPeriodTransactionMessContainer(this.database.getGraph()), new ExecutionEngine((GraphDatabaseService)this.database.getGraph(), this.logging.getMessagesLog(ExecutionEngine.class)), this.transactionRegistry, this.baseUri(), this.logging.getMessagesLog(TransactionFacade.class));
    }

    private long getTransactionTimeoutMillis() {
        int timeout = this.configurator.configuration().getInt("org.neo4j.server.transaction.timeout", 60);
        return Math.max(TimeUnit.SECONDS.toMillis(timeout), 1000L);
    }

    protected InterruptThreadTimer createInterruptStartupTimer() {
        InterruptThreadTimer stopStartupTimer;
        long startupTimeout = TimeUnit.SECONDS.toMillis(this.getConfiguration().getInt("org.neo4j.server.startup_timeout", 120));
        if (startupTimeout > 0L) {
            log.info("Setting startup timeout to: " + startupTimeout + "ms based on " + this.getConfiguration().getInt("org.neo4j.server.startup_timeout", -1), new Object[0]);
            stopStartupTimer = InterruptThreadTimer.createTimer(startupTimeout, Thread.currentThread());
        } else {
            stopStartupTimer = InterruptThreadTimer.createNoOpTimer();
        }
        return stopStartupTimer;
    }

    protected final void registerModule(ServerModule module) {
        this.serverModules.add(module);
    }

    private void startModules(StringLogger logger) {
        for (ServerModule module : this.serverModules) {
            module.start(logger);
        }
    }

    private void stopModules() {
        for (ServerModule module : this.serverModules) {
            try {
                module.stop();
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }

    private void runPreflightTasks() {
        if (!this.preflight.run()) {
            throw new PreflightFailedException(this.preflight.failedTask());
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.configurator.configuration();
    }

    protected Logging getLogging() {
        return this.logging;
    }

    private void configureWebServer() {
        int webServerPort = this.getWebServerPort();
        String webServerAddr = this.getWebServerAddress();
        int maxThreads = this.getMaxThreads();
        int sslPort = this.getHttpsPort();
        boolean sslEnabled = this.getHttpsEnabled();
        log.info("Starting Neo Server on port [%s] with [%d] threads available", webServerPort, maxThreads);
        this.webServer.setPort(webServerPort);
        this.webServer.setAddress(webServerAddr);
        this.webServer.setMaxThreads(maxThreads);
        this.webServer.setEnableHttps(sslEnabled);
        this.webServer.setHttpsPort(sslPort);
        this.webServer.setWadlEnabled(Boolean.valueOf(String.valueOf(this.getConfiguration().getProperty("unsupported_wadl_generation_enabled"))));
        this.webServer.setDefaultInjectables(this.createDefaultInjectables());
        if (sslEnabled) {
            log.info("Enabling HTTPS on port [%s]", sslPort);
            this.webServer.setHttpsCertificateInformation(this.initHttpsKeyStore());
        }
    }

    private int getMaxThreads() {
        return this.configurator.configuration().containsKey("org.neo4j.server.webserver.maxthreads") ? this.configurator.configuration().getInt("org.neo4j.server.webserver.maxthreads") : this.defaultMaxWebServerThreads();
    }

    private int defaultMaxWebServerThreads() {
        return 10 * Runtime.getRuntime().availableProcessors();
    }

    private void startWebServer(StringLogger logger) {
        try {
            if (this.httpLoggingProperlyConfigured()) {
                this.webServer.setHttpLoggingConfiguration(new File(this.getConfiguration().getProperty("org.neo4j.server.http.log.config").toString()));
            }
            this.webServer.start();
            Integer limit = this.getConfiguration().getInteger("org.neo4j.server.webserver.limit.executiontime", null);
            if (limit != null) {
                this.webServer.addExecutionLimitFilter(limit, this.database.getGraph().getGuard());
            }
            if (logger != null) {
                logger.logMessage("Server started on: " + this.baseUri());
            }
            log.info("Server started on [%s]", this.baseUri());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed to start Neo Server on port [%d], reason [%s]", this.getWebServerPort(), e.getMessage());
        }
    }

    private boolean httpLoggingProperlyConfigured() {
        return this.loggingEnabled() && this.configLocated();
    }

    private boolean configLocated() {
        Object property = this.getConfiguration().getProperty("org.neo4j.server.http.log.config");
        return property != null && new File(String.valueOf(property)).exists();
    }

    private boolean loggingEnabled() {
        return "true".equals(String.valueOf(this.getConfiguration().getProperty("org.neo4j.server.http.log.enabled")));
    }

    protected int getWebServerPort() {
        return this.configurator.configuration().getInt("org.neo4j.server.webserver.port", 7474);
    }

    protected boolean getHttpsEnabled() {
        return this.configurator.configuration().getBoolean("org.neo4j.server.webserver.https.enabled", Configurator.DEFAULT_WEBSERVER_HTTPS_ENABLED);
    }

    protected int getHttpsPort() {
        return this.configurator.configuration().getInt("org.neo4j.server.webserver.https.port", 7473);
    }

    protected String getWebServerAddress() {
        return this.configurator.configuration().getString("org.neo4j.server.webserver.address", "localhost");
    }

    protected KeyStoreInformation initHttpsKeyStore() {
        File keystorePath = new File(this.configurator.configuration().getString("org.neo4j.server.webserver.https.keystore.location", "neo4j-home/ssl/keystore"));
        File privateKeyPath = new File(this.configurator.configuration().getString("org.neo4j.server.webserver.https.key.location", "neo4j-home/ssl/snakeoil.key"));
        File certificatePath = new File(this.configurator.configuration().getString("org.neo4j.server.webserver.https.cert.location", "neo4j-home/ssl/snakeoil.cert"));
        if (!certificatePath.exists()) {
            log.info("No SSL certificate found, generating a self-signed certificate..", new Object[0]);
            SslCertificateFactory certFactory = new SslCertificateFactory();
            certFactory.createSelfSignedCertificate(certificatePath, privateKeyPath, this.getWebServerAddress());
        }
        KeyStoreFactory keyStoreFactory = new KeyStoreFactory();
        return keyStoreFactory.createKeyStore(keystorePath, privateKeyPath, certificatePath);
    }

    @Override
    public void stop() {
        try {
            this.stopServerOnly();
            this.stopDatabase();
            log.info("Successfully shutdown database.", new Object[0]);
        }
        catch (Exception e) {
            log.warn("Failed to cleanly shutdown database.", new Object[0]);
        }
    }

    @Deprecated
    public void stopServerOnly() {
        try {
            this.stopWebServer();
            this.stopModules();
            log.info("Successfully shutdown Neo4j Server.", new Object[0]);
        }
        catch (Exception e) {
            log.warn("Failed to cleanly shutdown Neo4j Server.", new Object[0]);
        }
    }

    private void stopWebServer() {
        if (this.webServer != null) {
            this.webServer.stop();
        }
    }

    private void stopDatabase() {
        if (this.database != null) {
            try {
                this.database.stop();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    @Override
    public URI baseUri() {
        return this.uriBuilder.buildURI(this.getWebServerAddress(), this.getWebServerPort(), false);
    }

    public URI httpsUri() {
        return this.uriBuilder.buildURI(this.getWebServerAddress(), this.getHttpsPort(), true);
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    @Override
    public Configurator getConfigurator() {
        return this.configurator;
    }

    @Override
    public PluginManager getExtensionManager() {
        if (this.hasModule(RESTApiModule.class)) {
            return this.getModule(RESTApiModule.class).getPlugins();
        }
        return null;
    }

    protected Collection<InjectableProvider<?>> createDefaultInjectables() {
        ArrayList singletons = new ArrayList();
        Database database = this.getDatabase();
        singletons.add(new DatabaseProvider(database));
        singletons.add(new DatabaseActions.Provider(this.databaseActions));
        singletons.add(new GraphDatabaseServiceProvider(database));
        singletons.add(new NeoServerProvider(this));
        singletons.add(new ConfigurationProvider(this.getConfiguration()));
        singletons.add(new RrdDbProvider(database));
        singletons.add(new WebServerProvider(this.getWebServer()));
        PluginInvocatorProvider pluginInvocatorProvider = new PluginInvocatorProvider(this);
        singletons.add(pluginInvocatorProvider);
        RepresentationFormatRepository repository = new RepresentationFormatRepository(this);
        singletons.add(new InputFormatProvider(repository));
        singletons.add(new OutputFormatProvider(repository));
        singletons.add(new CypherExecutorProvider(this.cypherExecutor));
        singletons.add(InjectableProvider.providerForSingleton(this.transactionFacade, TransactionFacade.class));
        singletons.add(new TransactionFilter(database));
        return singletons;
    }

    private boolean hasModule(Class<? extends ServerModule> clazz) {
        for (ServerModule sm : this.serverModules) {
            if (sm.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    private <T extends ServerModule> T getModule(Class<T> clazz) {
        for (ServerModule sm : this.serverModules) {
            if (sm.getClass() != clazz) continue;
            return (T)sm;
        }
        return null;
    }

    protected <T> T resolveDependency(Class<T> type) {
        return (T)this.dependencyResolver.resolveDependency(type);
    }
}

