/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.UniquenessConstraintDefinition;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class ConstraintDefinitionRepresentation
extends MappingRepresentation {
    protected final ConstraintDefinition constraintDefinition;

    public ConstraintDefinitionRepresentation(ConstraintDefinition constraintDefinition) {
        super(RepresentationType.CONSTRAINT_DEFINITION);
        this.constraintDefinition = constraintDefinition;
    }

    protected void serialize(MappingSerializer serializer) {
        serializer.putString("label", this.constraintDefinition.getLabel().name());
        ConstraintType type = this.constraintDefinition.getConstraintType();
        serializer.putString("type", type.name());
        switch (type) {
            case UNIQUENESS: {
                this.serialize(this.constraintDefinition.asUniquenessConstraint(), serializer);
                break;
            }
            default: {
                throw new ThisShouldNotHappenError("Stefan", String.format("Attempt to serialize constraint of unsupported/unknown constraint type %s", type));
            }
        }
    }

    protected void serialize(UniquenessConstraintDefinition constraintDefinition, MappingSerializer serializer) {
        Function<String, Representation> converter = new Function<String, Representation>(){

            public Representation apply(String propertyKey) {
                return ValueRepresentation.string((String)propertyKey);
            }
        };
        Iterable propertyKeyRepresentations = Iterables.map((Function)converter, (Iterable)constraintDefinition.getPropertyKeys());
        serializer.putList("property-keys", new ListRepresentation(RepresentationType.STRING, propertyKeyRepresentations));
    }
}

