/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.StreamingJsonFormat;
import org.neo4j.server.rest.transactional.ResultDataContentWriter;

class RestRepresentationWriter
implements ResultDataContentWriter {
    private final URI baseUri;

    RestRepresentationWriter(URI baseUri) {
        this.baseUri = baseUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JsonGenerator out, Iterable<String> columns, Map<String, Object> row) throws IOException {
        StreamingJsonFormat.StreamingRepresentationFormat format = new StreamingJsonFormat.StreamingRepresentationFormat(out, null);
        out.writeArrayFieldStart("rest");
        try {
            for (String key : columns) {
                this.write(out, format, row.get(key));
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(JsonGenerator out, RepresentationFormat format, Object value) throws IOException {
        block20: {
            if (value instanceof Map) {
                out.writeStartObject();
                try {
                    out.writeObjectFieldStart("data");
                    try {
                        Map map = (Map)value;
                        for (Map.Entry entry : map.entrySet()) {
                            out.writeFieldName((String)entry.getKey());
                            this.write(out, format, entry.getValue());
                        }
                        break block20;
                    }
                    finally {
                        out.writeEndObject();
                    }
                }
                finally {
                    out.writeEndObject();
                }
            }
            if (value instanceof List) {
                out.writeStartArray();
                try {
                    for (Object item : (List)value) {
                        this.write(out, format, item);
                    }
                }
                finally {
                    out.writeEndArray();
                }
            } else if (value instanceof Node) {
                this.write(format, (Representation)new NodeRepresentation((Node)value));
            } else if (value instanceof Relationship) {
                this.write(format, (Representation)new RelationshipRepresentation((Relationship)value));
            } else if (value instanceof Path) {
                this.write(format, (Representation)new PathRepresentation<Path>((Path)value));
            } else {
                out.writeObject(value);
            }
        }
    }

    private void write(RepresentationFormat format, Representation representation) {
        OutputFormat.write(representation, format, this.baseUri);
    }
}

