/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.rest.transactional.ExecutionResultSerializer;
import org.neo4j.server.rest.transactional.StatementDeserializer;
import org.neo4j.server.rest.transactional.TransactionHandle;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.error.TransactionLifecycleException;
import org.neo4j.server.rest.web.TransactionUriScheme;

public class TransactionFacade {
    private final KernelAPI kernel;
    private final ExecutionEngine engine;
    private final TransactionRegistry registry;
    private final StringLogger log;
    private final URI baseUri;

    public TransactionFacade(KernelAPI kernel, ExecutionEngine engine, TransactionRegistry registry, URI baseUri, StringLogger log) {
        this.kernel = kernel;
        this.engine = engine;
        this.registry = registry;
        this.log = log;
        this.baseUri = baseUri;
    }

    public TransactionHandle newTransactionHandle(TransactionUriScheme uriScheme) throws TransactionLifecycleException {
        return new TransactionHandle(this.kernel, this.engine, this.registry, uriScheme, this.log);
    }

    public TransactionHandle findTransactionHandle(long txId) throws TransactionLifecycleException {
        return this.registry.acquire(txId);
    }

    public StatementDeserializer deserializer(InputStream input) {
        return new StatementDeserializer(input);
    }

    public ExecutionResultSerializer serializer(OutputStream output) {
        return new ExecutionResultSerializer(output, this.baseUri, this.log);
    }
}

