/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.rest.transactional.TransactionHandle;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.error.InvalidConcurrentTransactionAccess;
import org.neo4j.server.rest.transactional.error.InvalidTransactionId;
import org.neo4j.server.rest.transactional.error.TransactionLifecycleException;
import org.neo4j.tooling.Clock;

public class TransactionHandleRegistry
implements TransactionRegistry {
    private final AtomicLong idGenerator = new AtomicLong(0L);
    private final ConcurrentHashMap<Long, TransactionMarker> registry = new ConcurrentHashMap(64);
    private final Clock clock;
    private final StringLogger log;
    private final long timeoutMillis;

    public TransactionHandleRegistry(Clock clock, long timeoutMillis, StringLogger log) {
        this.clock = clock;
        this.timeoutMillis = timeoutMillis;
        this.log = log;
    }

    @Override
    public long begin() {
        long id = this.idGenerator.incrementAndGet();
        if (null == this.registry.putIfAbsent(id, ActiveTransaction.INSTANCE)) {
            return id;
        }
        throw new IllegalStateException("Attempt to begin transaction for id that was already registered");
    }

    @Override
    public long release(long id, TransactionHandle transactionHandle) {
        TransactionMarker marker = this.registry.get(id);
        if (null == marker) {
            throw new IllegalStateException("Trying to suspend unregistered transaction");
        }
        if (marker.isSuspended()) {
            throw new IllegalStateException("Trying to suspend transaction that was already suspended");
        }
        SuspendedTransaction suspendedTx = new SuspendedTransaction(transactionHandle);
        if (!this.registry.replace(id, marker, suspendedTx)) {
            throw new IllegalStateException("Trying to suspend transaction that has been concurrently suspended");
        }
        return this.computeNewExpiryTime(suspendedTx.getLastActiveTimestamp());
    }

    private long computeNewExpiryTime(long lastActiveTimestamp) {
        return lastActiveTimestamp + this.timeoutMillis;
    }

    @Override
    public TransactionHandle acquire(long id) throws TransactionLifecycleException {
        TransactionMarker marker = this.registry.get(id);
        if (null == marker) {
            throw new InvalidTransactionId();
        }
        if (!marker.isSuspended()) {
            throw new InvalidConcurrentTransactionAccess();
        }
        SuspendedTransaction transaction = marker.getTransaction();
        if (this.registry.replace(id, marker, ActiveTransaction.INSTANCE)) {
            return transaction.transactionHandle;
        }
        throw new InvalidConcurrentTransactionAccess();
    }

    @Override
    public void forget(long id) {
        TransactionMarker marker = this.registry.get(id);
        if (null == marker) {
            throw new IllegalStateException("Could not finish unregistered transaction");
        }
        if (marker.isSuspended()) {
            throw new IllegalStateException("Cannot finish suspended registered transaction");
        }
        if (!this.registry.remove(id, marker)) {
            throw new IllegalStateException("Trying to finish transaction that has been concurrently finished or suspended");
        }
    }

    @Override
    public void rollbackAllSuspendedTransactions() {
        this.rollbackSuspended((Predicate<TransactionMarker>)Predicates.TRUE());
    }

    public void rollbackSuspendedTransactionsIdleSince(final long oldestLastActiveTime) {
        this.rollbackSuspended(new Predicate<TransactionMarker>(){

            public boolean accept(TransactionMarker item) {
                try {
                    SuspendedTransaction transaction = item.getTransaction();
                    return transaction.lastActiveTimestamp < oldestLastActiveTime;
                }
                catch (InvalidConcurrentTransactionAccess concurrentTransactionAccessError) {
                    throw new RuntimeException(concurrentTransactionAccessError);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackSuspended(Predicate<TransactionMarker> predicate) {
        HashSet<Long> candidateTransactionIdsToRollback = new HashSet<Long>();
        for (Map.Entry<Long, TransactionMarker> entry : this.registry.entrySet()) {
            TransactionMarker marker = entry.getValue();
            if (!marker.isSuspended() || !predicate.accept((Object)marker)) continue;
            candidateTransactionIdsToRollback.add(entry.getKey());
        }
        Iterator<Map.Entry<Long, TransactionMarker>> i$ = candidateTransactionIdsToRollback.iterator();
        while (i$.hasNext()) {
            TransactionHandle handle;
            long id = (Long)((Object)i$.next());
            try {
                handle = this.acquire(id);
            }
            catch (TransactionLifecycleException invalidTransactionId) {
                continue;
            }
            try {
                handle.forceRollback();
                this.log.info(String.format("Transaction with id %d has been automatically rolled back.", id));
            }
            catch (TransactionFailureException e) {
                this.log.error(String.format("Transaction with id %d failed to roll back.", id), (Throwable)e);
            }
            finally {
                this.forget(id);
            }
        }
    }

    private class SuspendedTransaction
    extends TransactionMarker {
        final TransactionHandle transactionHandle;
        final long lastActiveTimestamp;

        private SuspendedTransaction(TransactionHandle transactionHandle) {
            this.transactionHandle = transactionHandle;
            this.lastActiveTimestamp = TransactionHandleRegistry.this.clock.currentTimeMillis();
        }

        @Override
        SuspendedTransaction getTransaction() throws InvalidConcurrentTransactionAccess {
            return this;
        }

        @Override
        boolean isSuspended() {
            return true;
        }

        public long getLastActiveTimestamp() {
            return this.lastActiveTimestamp;
        }
    }

    private static class ActiveTransaction
    extends TransactionMarker {
        public static final ActiveTransaction INSTANCE = new ActiveTransaction();

        private ActiveTransaction() {
        }

        @Override
        SuspendedTransaction getTransaction() throws InvalidConcurrentTransactionAccess {
            throw new InvalidConcurrentTransactionAccess();
        }

        @Override
        boolean isSuspended() {
            return false;
        }
    }

    private static abstract class TransactionMarker {
        private TransactionMarker() {
        }

        abstract SuspendedTransaction getTransaction() throws InvalidConcurrentTransactionAccess;

        abstract boolean isSuspended();
    }
}

