/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.kernel.api.DataStatement;
import org.neo4j.kernel.api.InvalidTransactionTypeException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.MicroTransaction;
import org.neo4j.kernel.api.ReadStatement;
import org.neo4j.kernel.api.SchemaStatement;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.transaction.TxManager;

class TransitionalTxManagementKernelTransaction
implements KernelTransaction {
    private final KernelTransaction ctx;
    private final TxManager txManager;
    private Transaction suspendedTransaction;

    public TransitionalTxManagementKernelTransaction(KernelTransaction ctx, TxManager txManager) {
        this.ctx = ctx;
        this.txManager = txManager;
    }

    public ReadStatement acquireReadStatement() {
        return this.ctx.acquireReadStatement();
    }

    public DataStatement acquireDataStatement() throws InvalidTransactionTypeException {
        return this.ctx.acquireDataStatement();
    }

    public SchemaStatement acquireSchemaStatement() throws InvalidTransactionTypeException {
        return this.ctx.acquireSchemaStatement();
    }

    public void commit() throws TransactionFailureException {
        this.ctx.commit();
    }

    public void rollback() throws TransactionFailureException {
        this.ctx.rollback();
    }

    public <RESULT, FAILURE extends KernelException> RESULT execute(MicroTransaction<RESULT, FAILURE> transaction) throws FAILURE {
        return (RESULT)this.ctx.execute(transaction);
    }

    public void suspendSinceTransactionsAreStillThreadBound() {
        try {
            assert (this.suspendedTransaction == null) : "Can't suspend the transaction if it already is suspended.";
            this.suspendedTransaction = this.txManager.suspend();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public void resumeSinceTransactionsAreStillThreadBound() {
        try {
            assert (this.suspendedTransaction != null) : "Can't suspend the transaction if it has not first been suspended.";
            this.txManager.resume(this.suspendedTransaction);
            this.suspendedTransaction = null;
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }
}

