/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.error;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.neo4j.server.rest.transactional.error.StatusCode;

public class Neo4jError {
    private final StatusCode statusCode;
    private final Throwable cause;

    public Neo4jError(StatusCode statusCode, Throwable cause) {
        if (statusCode == null) {
            throw new IllegalArgumentException("statusCode must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("cause must not be null");
        }
        this.statusCode = statusCode;
        this.cause = cause;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getMessage() {
        return this.cause.getMessage();
    }

    public boolean shouldSerializeStackTrace() {
        return this.statusCode.includeStackTrace();
    }

    public String getStackTraceAsString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.cause.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

