/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import org.mortbay.jetty.HttpURI;
import org.mortbay.jetty.Request;

public class InternalJettyServletRequest
extends Request {
    private final Map<String, Object> headers;
    private final Cookie[] cookies;
    private final Input input;
    private final BufferedReader inputReader;
    private String contentType;
    private final String method;

    public InternalJettyServletRequest(String method, String uri, String body) throws UnsupportedEncodingException {
        this(method, new HttpURI(uri), body, new Cookie[0], "application/json", "UTF-8");
    }

    public InternalJettyServletRequest(String method, HttpURI uri, String body, Cookie[] cookies, String contentType, String encoding) throws UnsupportedEncodingException {
        this.input = new Input(body);
        this.inputReader = new BufferedReader(new StringReader(body));
        this.contentType = contentType;
        this.cookies = cookies;
        this.method = method;
        this.headers = new HashMap<String, Object>();
        this.setUri(uri);
        this.setCharacterEncoding(encoding);
        this.setRequestURI(null);
        this.setQueryString(null);
        this.setScheme(uri.getScheme());
    }

    public int getContentLength() {
        return this.input.length();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public long getContentRead() {
        return this.input.contentRead();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.input;
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public BufferedReader getReader() throws IOException {
        return this.inputReader;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getLocalName() {
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public void addHeader(String header, String value) {
        this.headers.put(header, value);
    }

    public long getDateHeader(String name) {
        if (this.headers.containsKey(name)) {
            return (Long)this.headers.get(name);
        }
        return -1L;
    }

    public String getHeader(String name) {
        if (this.headers.containsKey(name)) {
            Object value = this.headers.get(name);
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Collection) {
                return ((Collection)value).iterator().next().toString();
            }
            return value.toString();
        }
        return null;
    }

    public Enumeration<?> getHeaders(String name) {
        if (this.headers.containsKey(name)) {
            Object value = this.headers.get(name);
            if (value instanceof Collection) {
                return Collections.enumeration((Collection)value);
            }
            return Collections.enumeration(Collections.singleton(value));
        }
        return null;
    }

    public Enumeration<?> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String name) {
        if (this.headers.containsKey(name)) {
            return (Integer)this.headers.get(name);
        }
        return -1;
    }

    public String getMethod() {
        return this.method;
    }

    public String toString() {
        return String.format("%s %s %s\n%s", this.getMethod(), this.getUri(), this.getProtocol(), this.getConnection() != null ? this.getConnection().getRequestFields() : "no HttpConnection");
    }

    private class Input
    extends ServletInputStream {
        private final byte[] bytes;
        private int position = 0;

        public Input(String data) {
            try {
                this.bytes = data.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public int read() throws IOException {
            if (this.bytes.length > this.position) {
                return this.bytes[this.position++];
            }
            return -1;
        }

        public int length() {
            return this.bytes.length;
        }

        public long contentRead() {
            return this.position;
        }
    }
}

