/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.StreamingFormat;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.TestData;

public class GetOnRootDocIT
extends AbstractRestFunctionalTestBase {
    @Documented(value=" The service root is your starting point to discover the REST API. It\n contains the basic starting points for the database, and some version and\n extension information. The +reference_node+ entry will only be present if\n there is a reference node set and that node actually exists in the\n database.\n")
    @Test
    @GraphDescription.Graph(value={"I know you"})
    @TestData.Title(value="Get service root")
    public void assert200OkFromGet() throws Exception {
        JaxRsResponse response;
        long referenceNodeId = this.setReferenceNodeIdToI();
        String body = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(this.getDataUri()).entity();
        Map map = JsonHelper.jsonToMap((String)body);
        Assert.assertEquals((Object)(this.getDataUri() + "node"), map.get("node"));
        Assert.assertNotNull(map.get("reference_node"));
        Assert.assertNotNull(map.get("node_index"));
        Assert.assertNotNull(map.get("relationship_index"));
        Assert.assertNotNull(map.get("extensions_info"));
        Assert.assertNotNull(map.get("batch"));
        Assert.assertNotNull(map.get("cypher"));
        Assert.assertEquals((Object)Version.getKernel().getReleaseVersion(), map.get("neo4j_version"));
        if (map.get("reference_node") != null) {
            response = RestRequest.req().get((String)map.get("reference_node"));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            response.close();
        }
        Assert.assertTrue(((response = RestRequest.req().get((String)map.get("node_index"))).getStatus() == 200 || response.getStatus() == 204 ? 1 : 0) != 0);
        response.close();
        response = RestRequest.req().get((String)map.get("relationship_index"));
        Assert.assertTrue((response.getStatus() == 200 || response.getStatus() == 204 ? 1 : 0) != 0);
        response.close();
        response = RestRequest.req().get((String)map.get("extensions_info"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        response = RestRequest.req().post((String)map.get("batch"), "[]");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        response = RestRequest.req().post((String)map.get("cypher"), "{\"query\":\"START n=node(" + referenceNodeId + ") RETURN n\"}");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
    }

    private long setReferenceNodeIdToI() {
        InternalAbstractGraphDatabase db = (InternalAbstractGraphDatabase)this.graphdb();
        try (Transaction tx = db.beginTx();){
            long referenceNodeId = ((Node)((Map)this.data.get()).get("I")).getId();
            db.getNodeManager().setReferenceNodeId(referenceNodeId);
            tx.success();
            long l = referenceNodeId;
            return l;
        }
    }

    @Documented(value=" The whole REST API can be transmitted as JSON streams, resulting in\n better performance and lower memory overhead on the server side. To use\n it, adjust the request headers for every call, see the example below for\n details.\n <p/>\n CAUTION: This feature is new, and you should make yourself comfortable\n with the streamed response style versus the non-streamed API where\n results are delivered in a single large response. Expect future releases\n to have streaming enabled by default since it is a far more efficient\n mechanism for both client and server.\n")
    @Test
    @GraphDescription.Graph(value={"I know you"})
    public void streaming() throws Exception {
        this.data.get();
        this.setReferenceNodeIdToI();
        RESTDocsGenerator.ResponseEntity responseEntity = this.gen().docHeadingLevel(2).withHeader("X-Stream", "true").expectedType(MediaType.APPLICATION_JSON_TYPE).expectedStatus(200).get(this.getDataUri());
        JaxRsResponse response = responseEntity.response();
        String foundMediaType = response.getType().toString();
        String expectedMediaType = StreamingFormat.MEDIA_TYPE.toString();
        Assert.assertEquals((Object)expectedMediaType, (Object)foundMediaType);
        String body = responseEntity.entity();
        Map map = JsonHelper.jsonToMap((String)body);
        Assert.assertEquals((Object)(this.getDataUri() + "node"), map.get("node"));
        Assert.assertNotNull(map.get("reference_node"));
    }
}

