/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.test.GraphDescription;

public class SchemaConstraintsDocIT
extends AbstractRestFunctionalTestBase {
    @Documented(value=" Create uniqueness constraint.\n Create a uniqueness constraint on a property.\n")
    @Test
    @GraphDescription.Graph(nodes={})
    public void createPropertyUniquenessConstraint() throws PropertyValueException {
        this.data.get();
        String labelName = "person";
        String propertyKey = "name";
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Arrays.asList(propertyKey)});
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payload(JsonHelper.createJsonFrom((Object)definition)).post(this.getSchemaConstraintLabelUniquenessUri(labelName)).entity();
        Map serialized = JsonHelper.jsonToMap((String)result);
        Assert.assertEquals((Object)labelName, serialized.get("label"));
        Assert.assertEquals((Object)ConstraintType.UNIQUENESS.name(), serialized.get("type"));
        Assert.assertEquals(Arrays.asList(propertyKey), serialized.get("property-keys"));
    }

    @Documented(value=" Get a specific uniqueness constraint.\n Get a specific uniqueness constraint for a label and a property.\n")
    @Test
    @GraphDescription.Graph(nodes={})
    public void getLabelUniquenessPropertyConstraint() throws PropertyValueException {
        this.data.get();
        String labelName = "user";
        String propertyKey = "name";
        this.createLabelUniquenessPropertyConstraint(labelName, propertyKey);
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).get(this.getSchemaConstraintLabelUniquenessPropertyUri(labelName, propertyKey)).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        Assert.assertEquals((long)1L, (long)serializedList.size());
        Map serialized = (Map)serializedList.get(0);
        Assert.assertEquals((Object)labelName, serialized.get("label"));
        Assert.assertEquals((Object)ConstraintType.UNIQUENESS.name(), serialized.get("type"));
        Assert.assertEquals(Arrays.asList(propertyKey), serialized.get("property-keys"));
    }

    @Documented(value=" Get all uniqueness constraints for a label.\n")
    @Test
    @GraphDescription.Graph(nodes={})
    public void getLabelUniquenessPropertyConstraints() throws PropertyValueException {
        this.data.get();
        String labelName = "user";
        String propertyKey1 = "name1";
        String propertyKey2 = "name2";
        this.createLabelUniquenessPropertyConstraint(labelName, propertyKey1);
        this.createLabelUniquenessPropertyConstraint(labelName, propertyKey2);
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).get(this.getSchemaConstraintLabelUniquenessUri(labelName)).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        Assert.assertEquals((long)2L, (long)serializedList.size());
        Map serialized1 = (Map)serializedList.get(0);
        Assert.assertEquals((Object)labelName, serialized1.get("label"));
        Assert.assertEquals((Object)ConstraintType.UNIQUENESS.name(), serialized1.get("type"));
        List keyList1 = (List)serialized1.get("property-keys");
        Map serialized2 = (Map)serializedList.get(1);
        Assert.assertEquals((Object)labelName, serialized2.get("label"));
        Assert.assertEquals((Object)ConstraintType.UNIQUENESS.name(), serialized2.get("type"));
        List keyList2 = (List)serialized2.get("property-keys");
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new List[]{Arrays.asList(propertyKey1), Arrays.asList(propertyKey2)}), (Object)IteratorUtil.asSet((Object[])new List[]{keyList1, keyList2}));
    }

    @Documented(value=" Get all constraints for a label.\n")
    @Test
    @GraphDescription.Graph(nodes={})
    public void getLabelPropertyConstraints() throws PropertyValueException {
        this.data.get();
        String labelName = "user";
        String propertyKey1 = "name1";
        String propertyKey2 = "name2";
        this.createLabelUniquenessPropertyConstraint(labelName, propertyKey1);
        this.createLabelUniquenessPropertyConstraint(labelName, propertyKey2);
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).get(this.getSchemaConstraintLabelUri(labelName)).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        Assert.assertEquals((long)2L, (long)serializedList.size());
        Map serialized1 = (Map)serializedList.get(0);
        Assert.assertEquals((Object)labelName, serialized1.get("label"));
        Assert.assertEquals((Object)ConstraintType.UNIQUENESS.name(), serialized1.get("type"));
        List keyList1 = (List)serialized1.get("property-keys");
        Map serialized2 = (Map)serializedList.get(1);
        Assert.assertEquals((Object)labelName, serialized2.get("label"));
        Assert.assertEquals((Object)ConstraintType.UNIQUENESS.name(), serialized2.get("type"));
        List keyList2 = (List)serialized2.get("property-keys");
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new List[]{Arrays.asList(propertyKey1), Arrays.asList(propertyKey2)}), (Object)IteratorUtil.asSet((Object[])new List[]{keyList1, keyList2}));
    }

    @Documented(value=" Get all constraints.\n")
    @Test
    @GraphDescription.Graph(nodes={})
    public void get_constraints() throws PropertyValueException {
        this.data.get();
        String labelName1 = "user";
        String propertyKey1 = "name1";
        String labelName2 = "prog";
        String propertyKey2 = "name2";
        this.createLabelUniquenessPropertyConstraint(labelName1, propertyKey1);
        this.createLabelUniquenessPropertyConstraint(labelName2, propertyKey2);
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).get(this.getSchemaConstraintUri()).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        Assert.assertEquals((long)2L, (long)serializedList.size());
        Map serialized1 = (Map)serializedList.get(0);
        Assert.assertEquals((Object)labelName1, serialized1.get("label"));
        Assert.assertEquals((Object)ConstraintType.UNIQUENESS.name(), serialized1.get("type"));
        List keyList1 = (List)serialized1.get("property-keys");
        Map serialized2 = (Map)serializedList.get(1);
        Assert.assertEquals((Object)labelName2, serialized2.get("label"));
        Assert.assertEquals((Object)ConstraintType.UNIQUENESS.name(), serialized2.get("type"));
        List keyList2 = (List)serialized2.get("property-keys");
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new List[]{Arrays.asList(propertyKey1), Arrays.asList(propertyKey2)}), (Object)IteratorUtil.asSet((Object[])new List[]{keyList1, keyList2}));
    }

    @Documented(value=" Drop constraint.\n Drop uniqueness constraint for a label and a property.\n")
    @Test
    @GraphDescription.Graph(nodes={})
    public void drop_constraint() throws Exception {
        this.data.get();
        String labelName = "SomeLabel";
        String propertyKey = "name";
        ConstraintDefinition constraintDefinition = this.createLabelUniquenessPropertyConstraint(labelName, propertyKey);
        Assert.assertThat((Object)Neo4jMatchers.getConstraints((GraphDatabaseService)this.graphdb(), (Label)DynamicLabel.label((String)labelName)), (Matcher)Neo4jMatchers.containsOnly((Object[])new ConstraintDefinition[]{constraintDefinition}));
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(204).delete(this.getSchemaConstraintLabelUniquenessPropertyUri(labelName, propertyKey)).entity();
        Assert.assertThat((Object)Neo4jMatchers.getConstraints((GraphDatabaseService)this.graphdb(), (Label)DynamicLabel.label((String)labelName)), (Matcher)Neo4jMatchers.isEmpty());
    }

    @Test
    public void create_existing_constraint() {
        String labelName = "mylabel";
        String propertyKey = "name";
        this.createLabelUniquenessPropertyConstraint(labelName, propertyKey);
    }

    @Test
    public void drop_non_existent_constraint() throws Exception {
        String labelName = "ALabel";
        String propertyKey = "name";
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(404).delete(this.getSchemaConstraintLabelUniquenessPropertyUri(labelName, propertyKey));
    }

    @Test
    public void create_compound_schema_index() {
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Arrays.asList("first", "other")});
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(400).payload(JsonHelper.createJsonFrom((Object)definition)).post(this.getSchemaIndexLabelUri("a_label"));
    }

    private ConstraintDefinition createLabelUniquenessPropertyConstraint(String labelName, String propertyKey) {
        try (Transaction tx = this.graphdb().beginTx();){
            ConstraintDefinition constraintDefinition = this.graphdb().schema().constraintFor(DynamicLabel.label((String)labelName)).unique().on(propertyKey).create();
            tx.success();
            ConstraintDefinition constraintDefinition2 = constraintDefinition;
            return constraintDefinition2;
        }
    }
}

