/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.paging;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.EphemeralDatabase;
import org.neo4j.server.rest.paging.PagedTraverser;

public class PagedTraverserTest {
    private static final int LIST_LENGTH = 100;
    private Database database;
    private Node startNode;

    @Before
    public void clearDb() throws Throwable {
        this.database = new EphemeralDatabase();
        this.database.start();
        this.createLinkedList(100, this.database);
    }

    @After
    public void shutdownDatabase() throws Throwable {
        this.database.getGraph().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLinkedList(int listLength, Database db) {
        Transaction tx = db.getGraph().beginTx();
        try {
            Node previous = null;
            for (int i = 0; i < listLength; ++i) {
                Node current = db.getGraph().createNode();
                if (previous != null) {
                    previous.createRelationshipTo(current, (RelationshipType)DynamicRelationshipType.withName((String)"NEXT"));
                } else {
                    this.startNode = current;
                }
                previous = current;
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @Test
    public void shouldPageThroughResultsForWhollyDivisiblePageSize() {
        Traverser myTraverser = this.simpleListTraverser();
        PagedTraverser traversalPager = new PagedTraverser(myTraverser, 10);
        int iterations = this.iterateThroughPagedTraverser(traversalPager);
        Assert.assertEquals((long)10L, (long)iterations);
        Assert.assertNull((Object)traversalPager.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int iterateThroughPagedTraverser(PagedTraverser traversalPager) {
        Transaction transaction = this.database.getGraph().beginTx();
        try {
            int count = 0;
            for (List paths : traversalPager) {
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            transaction.finish();
        }
    }

    @Test
    public void shouldPageThroughResultsForNonWhollyDivisiblePageSize() {
        int awkwardPageSize = 7;
        Traverser myTraverser = this.simpleListTraverser();
        PagedTraverser traversalPager = new PagedTraverser(myTraverser, awkwardPageSize);
        int iterations = this.iterateThroughPagedTraverser(traversalPager);
        Assert.assertEquals((long)15L, (long)iterations);
        Assert.assertNull((Object)traversalPager.next());
    }

    private Traverser simpleListTraverser() {
        return Traversal.description().expand((RelationshipExpander)Traversal.expanderForTypes((RelationshipType)DynamicRelationshipType.withName((String)"NEXT"), (Direction)Direction.OUTGOING)).depthFirst().uniqueness((UniquenessFactory)Uniqueness.NODE_GLOBAL).traverse(this.startNode);
    }
}

