/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.neo4j.ext.udc.UdcSettings;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.Database;
import org.neo4j.shell.ShellSettings;

public class CommunityDatabase
extends Database {
    protected final Configurator configurator;
    protected final Configuration serverConfiguration;
    private boolean isRunning = false;

    public CommunityDatabase(Configurator configurator) {
        this.configurator = configurator;
        this.serverConfiguration = configurator.configuration();
    }

    protected AbstractGraphDatabase createDb() {
        return (AbstractGraphDatabase)new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.serverConfiguration.getString("org.neo4j.server.database.location", "data/graph.db")).setConfig(this.getDbTuningPropertiesWithServerDefaults()).newGraphDatabase();
    }

    @Override
    public void start() throws Throwable {
        try {
            this.graph = this.createDb();
            this.isRunning = true;
            log.info("Successfully started database", new Object[0]);
        }
        catch (Exception e) {
            log.error("Failed to start database.", e);
            throw e;
        }
    }

    @Override
    public void stop() throws Throwable {
        try {
            if (this.graph != null) {
                this.graph.shutdown();
                this.isRunning = false;
                this.graph = null;
                log.info("Successfully stopped database", new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("Database did not stop cleanly. Reason [%s]", e.getMessage());
            throw e;
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    protected Map<String, String> getDbTuningPropertiesWithServerDefaults() {
        HashMap<String, String> result = new HashMap<String, String>(this.configurator.getDatabaseTuningProperties());
        this.putIfAbsent(result, ShellSettings.remote_shell_enabled.name(), "true");
        this.putIfAbsent(result, GraphDatabaseSettings.keep_logical_logs.name(), "true");
        try {
            result.put(UdcSettings.udc_source.name(), "server");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return result;
    }

    private void putIfAbsent(Map<String, String> databaseProperties, String configKey, String configValue) {
        if (databaseProperties.get(configKey) == null) {
            databaseProperties.put(configKey, configValue);
        }
    }
}

