/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.logging;

import java.util.IllegalFormatException;
import org.neo4j.server.logging.Logger;

public class JettyLoggerAdapter
implements org.eclipse.jetty.util.log.Logger {
    private static final String SYSTEM = "SYSTEM";
    private Logger delegate = Logger.getLogger("SYSTEM");

    public void debug(Throwable arg1) {
        this.delegate.debug(arg1.getMessage(), arg1);
    }

    public void debug(String arg0, Throwable arg1) {
        try {
            this.delegate.debug(JettyLoggerAdapter.wrapNull(arg0), arg1);
        }
        catch (IllegalFormatException e) {
            this.delegate.debug(JettyLoggerAdapter.safeFormat(arg0, arg1), new Object[0]);
        }
    }

    public void debug(String arg0, Object ... args) {
        try {
            this.delegate.debug(JettyLoggerAdapter.wrapNull(arg0), args);
        }
        catch (IllegalFormatException e) {
            this.delegate.debug(JettyLoggerAdapter.safeFormat(arg0, args), new Object[0]);
        }
    }

    public org.eclipse.jetty.util.log.Logger getLogger(String arg0) {
        JettyLoggerAdapter newInstance = new JettyLoggerAdapter();
        newInstance.delegate = Logger.getLogger(arg0);
        return newInstance;
    }

    public void info(String arg0, Object ... args) {
        try {
            this.delegate.info(JettyLoggerAdapter.wrapNull(arg0), args);
        }
        catch (IllegalFormatException e) {
            this.delegate.info(JettyLoggerAdapter.safeFormat(arg0, args), new Object[0]);
        }
    }

    public void info(Throwable arg1) {
        this.delegate.debug(arg1.getMessage(), arg1);
    }

    public void info(String arg0, Throwable arg1) {
        this.delegate.debug(arg0, arg1);
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void setDebugEnabled(boolean arg0) {
    }

    public void warn(Throwable arg1) {
        this.delegate.debug(arg1.getMessage(), arg1);
    }

    public void warn(String arg0, Throwable arg1) {
        this.delegate.warn(JettyLoggerAdapter.wrapNull(arg1), new Object[0]);
    }

    public void warn(String arg0, Object ... args) {
        try {
            this.delegate.warn(JettyLoggerAdapter.wrapNull(arg0), args);
        }
        catch (IllegalFormatException e) {
            this.delegate.warn(JettyLoggerAdapter.safeFormat(arg0, args), new Object[0]);
        }
    }

    static String safeFormat(String arg0, Object ... args) {
        StringBuilder builder = new StringBuilder();
        builder.append("Failed to format message: ");
        builder.append(JettyLoggerAdapter.armored(arg0));
        if (null != args) {
            for (int i = 0; i < args.length; ++i) {
                JettyLoggerAdapter.appendArg(builder, i + 1, args[i]);
            }
        }
        return builder.toString();
    }

    private static String armored(Object arg0) {
        return JettyLoggerAdapter.wrapNull(arg0).replaceAll("%", "?");
    }

    private static void appendArg(StringBuilder builder, int argNum, Object arg) {
        builder.append(" arg");
        builder.append(argNum);
        builder.append(": ");
        builder.append(JettyLoggerAdapter.armored(arg));
    }

    private static String wrapNull(Object arg0) {
        return null == arg0 ? "null" : arg0.toString();
    }

    public void ignore(Throwable arg1) {
        this.delegate.debug(arg1.getMessage(), arg1);
    }

    public String getName() {
        return SYSTEM;
    }
}

