/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonGenerator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.rest.transactional.ResultDataContentWriter;

class GraphExtractionWriter
implements ResultDataContentWriter {
    GraphExtractionWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JsonGenerator out, Iterable<String> columns, Map<String, Object> row) throws IOException {
        HashSet<Node> nodes = new HashSet<Node>();
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        this.extract(nodes, relationships, row.values());
        out.writeObjectFieldStart("graph");
        try {
            this.writeNodes(out, nodes);
            this.writeRelationships(out, relationships);
        }
        finally {
            out.writeEndObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNodes(JsonGenerator out, Iterable<Node> nodes) throws IOException {
        out.writeArrayFieldStart("nodes");
        try {
            for (Node node : nodes) {
                out.writeStartObject();
                try {
                    out.writeStringField("id", Long.toString(node.getId()));
                    out.writeArrayFieldStart("labels");
                    try {
                        for (Label label : node.getLabels()) {
                            out.writeString(label.name());
                        }
                    }
                    finally {
                        out.writeEndArray();
                    }
                    this.writeProperties(out, (PropertyContainer)node);
                }
                finally {
                    out.writeEndObject();
                }
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRelationships(JsonGenerator out, Iterable<Relationship> relationships) throws IOException {
        out.writeArrayFieldStart("relationships");
        try {
            for (Relationship relationship : relationships) {
                out.writeStartObject();
                try {
                    out.writeStringField("id", Long.toString(relationship.getId()));
                    out.writeStringField("type", relationship.getType().name());
                    out.writeStringField("startNode", Long.toString(relationship.getStartNode().getId()));
                    out.writeStringField("endNode", Long.toString(relationship.getEndNode().getId()));
                    this.writeProperties(out, (PropertyContainer)relationship);
                }
                finally {
                    out.writeEndObject();
                }
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProperties(JsonGenerator out, PropertyContainer container) throws IOException {
        out.writeObjectFieldStart("properties");
        try {
            for (String key : container.getPropertyKeys()) {
                out.writeObjectField(key, container.getProperty(key));
            }
        }
        finally {
            out.writeEndObject();
        }
    }

    private void extract(Set<Node> nodes, Set<Relationship> relationships, Iterable<?> source) {
        for (Object item : source) {
            if (item instanceof Node) {
                nodes.add((Node)item);
            } else if (item instanceof Relationship) {
                Relationship relationship = (Relationship)item;
                relationships.add(relationship);
                nodes.add(relationship.getStartNode());
                nodes.add(relationship.getEndNode());
            }
            if (item instanceof Path) {
                Path path = (Path)item;
                for (Node node : path.nodes()) {
                    nodes.add(node);
                }
                for (Relationship relationship : path.relationships()) {
                    relationships.add(relationship);
                }
                continue;
            }
            if (item instanceof Map) {
                this.extract(nodes, relationships, ((Map)item).values());
                continue;
            }
            if (!(item instanceof Iterable)) continue;
            this.extract(nodes, relationships, (Iterable)item);
        }
    }
}

