/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.IOException;
import java.util.Iterator;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;

public class Neo4jJsonCodec
extends ObjectMapper {
    public void writeValue(JsonGenerator out, Object value) throws IOException {
        if (value instanceof PropertyContainer) {
            this.writePropertyContainer(out, (PropertyContainer)value);
        } else if (value instanceof Path) {
            this.writePath(out, ((Path)value).iterator());
        } else if (value instanceof Iterable) {
            this.writeIterator(out, ((Iterable)value).iterator());
        } else if (value instanceof byte[]) {
            this.writeByteArray(out, (byte[])value);
        } else {
            super.writeValue(out, value);
        }
    }

    private void writeIterator(JsonGenerator out, Iterator value) throws IOException {
        out.writeStartArray();
        while (value.hasNext()) {
            this.writeValue(out, value.next());
        }
        out.writeEndArray();
    }

    private void writePath(JsonGenerator out, Iterator<PropertyContainer> value) throws IOException {
        out.writeStartArray();
        while (value.hasNext()) {
            this.writePropertyContainer(out, value.next());
        }
        out.writeEndArray();
    }

    private void writePropertyContainer(JsonGenerator out, PropertyContainer value) throws IOException {
        out.writeStartObject();
        for (String key : value.getPropertyKeys()) {
            out.writeObjectField(key, value.getProperty(key));
        }
        out.writeEndObject();
    }

    private void writeByteArray(JsonGenerator out, byte[] bytes) throws IOException {
        out.writeStartArray();
        for (byte b : bytes) {
            out.writeNumber((int)b);
        }
        out.writeEndArray();
    }
}

