/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.neo4j.server.rest.batch.BatchOperationResults;
import org.neo4j.server.rest.batch.NonStreamingBatchOperations;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationWriteHandler;
import org.neo4j.server.rest.web.StreamingBatchOperations;
import org.neo4j.server.web.HttpHeaderUtils;
import org.neo4j.server.web.WebServer;

@Path(value="/batch")
public class BatchOperationService {
    private static final Logger LOGGER = Log.getLogger(BatchOperationService.class);
    private final OutputFormat output;
    private final WebServer webServer;
    private RepresentationWriteHandler representationWriteHandler = RepresentationWriteHandler.DO_NOTHING;

    public BatchOperationService(@Context WebServer webServer, @Context OutputFormat output) {
        this.output = output;
        this.webServer = webServer;
    }

    public void setRepresentationWriteHandler(RepresentationWriteHandler representationWriteHandler) {
        this.representationWriteHandler = representationWriteHandler;
    }

    @POST
    public Response performBatchOperations(@Context UriInfo uriInfo, @Context HttpHeaders httpHeaders, InputStream body) {
        if (this.isStreaming(httpHeaders)) {
            return this.batchProcessAndStream(uriInfo, httpHeaders, body);
        }
        return this.batchProcess(uriInfo, httpHeaders, body);
    }

    private Response batchProcessAndStream(final UriInfo uriInfo, final HttpHeaders httpHeaders, final InputStream body) {
        try {
            StreamingOutput stream = new StreamingOutput(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void write(final OutputStream output) throws IOException, WebApplicationException {
                    try {
                        ServletOutputStream servletOutputStream = new ServletOutputStream(){

                            public void write(int i) throws IOException {
                                output.write(i);
                            }
                        };
                        new StreamingBatchOperations(BatchOperationService.this.webServer).readAndExecuteOperations(uriInfo, httpHeaders, body, servletOutputStream);
                        BatchOperationService.this.representationWriteHandler.onRepresentationWritten();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Error executing batch request ", (Throwable)e);
                    }
                    finally {
                        BatchOperationService.this.representationWriteHandler.onRepresentationFinal();
                    }
                }
            };
            return Response.ok((Object)stream).type(HttpHeaderUtils.mediaTypeWithCharsetUtf8(MediaType.APPLICATION_JSON_TYPE)).build();
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response batchProcess(UriInfo uriInfo, HttpHeaders httpHeaders, InputStream body) {
        try {
            NonStreamingBatchOperations batchOperations = new NonStreamingBatchOperations(this.webServer);
            BatchOperationResults results = batchOperations.performBatchJobs(uriInfo, httpHeaders, body);
            Response res = Response.ok().entity((Object)results.toJSON()).header("Content-Encoding", (Object)"UTF-8").type(HttpHeaderUtils.mediaTypeWithCharsetUtf8(MediaType.APPLICATION_JSON_TYPE)).build();
            this.representationWriteHandler.onRepresentationWritten();
            Response response = res;
            return response;
        }
        catch (Exception e) {
            Response response = this.output.serverError(e);
            return response;
        }
        finally {
            this.representationWriteHandler.onRepresentationFinal();
        }
    }

    private boolean isStreaming(HttpHeaders httpHeaders) {
        if ("true".equalsIgnoreCase((String)httpHeaders.getRequestHeaders().getFirst((Object)"X-Stream"))) {
            return true;
        }
        for (MediaType mediaType : httpHeaders.getAcceptableMediaTypes()) {
            Map parameters = mediaType.getParameters();
            if (!parameters.containsKey("stream") || !"true".equalsIgnoreCase((String)parameters.get("stream"))) continue;
            return true;
        }
        return false;
    }
}

